/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.config.RoundedRockConfig;

public class RoundedRock
extends Feature<RoundedRockConfig> {
    public RoundedRock(Codec<RoundedRockConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RoundedRockConfig> context) {
        RandomSource random = context.random();
        ImprovedNoise improvedNoise = new ImprovedNoise(random);
        RoundedRockConfig config = (RoundedRockConfig)context.config();
        BlockPos origin = context.origin();
        int rawRadius = config.radius().sample(random);
        int height = config.height().sample(random);
        float frequency = config.noiseFrequency().sample(random);
        BlendingFunction blendingFunction = (BlendingFunction)config.blendFunction().getRandomOrThrow(random);
        LongOpenHashSet cached = new LongOpenHashSet();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int y = -5; y < height; ++y) {
            double yDelta = 1.0 - (double)y / (double)height;
            if (yDelta >= 0.0 && yDelta <= 1.0) {
                yDelta = blendingFunction.apply(yDelta);
            }
            double radius = (double)rawRadius * yDelta;
            for (double x = -radius; x <= radius; x += 1.0) {
                for (double z = -radius; z <= radius; z += 1.0) {
                    mutableBlockPos.setWithOffset((Vec3i)origin, (int)x, y, (int)z);
                    if (!mutableBlockPos.closerThan((Vec3i)origin.atY(mutableBlockPos.getY()), radius)) continue;
                    double normalizedNoise = (improvedNoise.noise((double)((float)mutableBlockPos.getX() * frequency), (double)((float)mutableBlockPos.getY() * frequency), (double)((float)mutableBlockPos.getZ() * frequency)) + 1.0) * 0.5;
                    double localRadius = Mth.clampedLerp((double)(radius * 0.5), (double)radius, (double)normalizedNoise);
                    if (!mutableBlockPos.closerThan((Vec3i)origin.atY(mutableBlockPos.getY()), localRadius)) continue;
                    cached.add(mutableBlockPos.asLong());
                }
            }
        }
        for (Pair<BlockPredicate, BlockStateProvider> blockPlacement : config.checkedBlockPlacement().blockPlacement()) {
            cached.forEach(pos -> {
                mutableBlockPos.set(pos);
                if (((BlockPredicate)blockPlacement.getFirst()).test((Object)context.level(), (Object)mutableBlockPos)) {
                    context.level().setBlock((BlockPos)mutableBlockPos, ((BlockStateProvider)blockPlacement.getSecond()).getState(random, (BlockPos)mutableBlockPos), 2);
                }
            });
        }
        return true;
    }

    public static double easeInCirc(double x) {
        return 1.0 - Math.sqrt(1.0 - Math.pow(x, 1.1));
    }
}

