/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import corgitaco.corgilib.world.level.RandomTickScheduler;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2975;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3756;
import net.minecraft.class_4076;
import net.minecraft.class_4651;
import net.minecraft.class_5138;
import net.minecraft.class_5216;
import net.minecraft.class_5281;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_6580;
import net.minecraft.class_6625;
import net.minecraft.class_6677;
import net.minecraft.class_6731;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.potionstudios.biomeswevegone.util.BWGUtil;
import net.potionstudios.biomeswevegone.util.UnsafeBoundingBox;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructurePieceTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;

public class LargeLakePiece
extends class_3443 {
    private final class_2338 origin;
    private final int radius;
    private final int lakeDepth;
    private final class_6885<class_6796> lakeFeatures;

    protected LargeLakePiece(class_2338 origin, int radius, int lakeDepth, class_3341 boundingBox, class_6885<class_6796> lakeFeatures) {
        super(BWGStructurePieceTypes.LARGE_LAKE.get(), 0, boundingBox);
        this.origin = origin;
        this.radius = radius;
        this.lakeDepth = lakeDepth;
        this.lakeFeatures = lakeFeatures;
    }

    public LargeLakePiece(class_6625 context, class_2487 tag) {
        super(BWGStructurePieceTypes.LARGE_LAKE.get(), tag);
        this.origin = BWGUtil.readBlockPos(tag, "origin").orElseThrow();
        this.radius = tag.method_68083("radius", 0);
        this.lakeDepth = tag.method_68083("lakeDepth", 0);
        class_6903 tagRegistryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)context.comp_134());
        this.lakeFeatures = (class_6885)((Pair)class_6796.field_35731.decode((DynamicOps)tagRegistryOps, (Object)tag.method_10580("lake_features")).getOrThrow()).getFirst();
    }

    protected void method_14943(class_6625 context, class_2487 tag) {
        tag.method_10566("origin", BWGUtil.writeBlockPos(this.origin));
        tag.method_10569("radius", this.radius);
        tag.method_10569("lakeDepth", this.lakeDepth);
        class_6903 tagRegistryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)context.comp_134());
        tag.method_10566("lake_features", (class_2520)class_6796.field_35731.encodeStart((DynamicOps)tagRegistryOps, this.lakeFeatures).result().orElseThrow());
    }

    public void method_14931(class_5281 worldGenLevel, @NotNull class_5138 structureManager, @NotNull class_2794 generator, @NotNull class_5819 random, @NotNull class_3341 box, class_1923 chunkPos, @NotNull class_2338 pos) {
        class_3756 noiseSampler = new class_3756((class_5819)new class_6677(worldGenLevel.method_8412()));
        UnsafeBoundingBox unsafeBoundingBox = new UnsafeBoundingBox();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_2791 chunk = worldGenLevel.method_8392(chunkPos.field_9181, chunkPos.field_9180);
        boolean[] placedWater = new boolean[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int blockX = chunkPos.method_33939(x);
                int blockZ = chunkPos.method_33941(z);
                mutableBlockPos.method_10103(blockX, 0, blockZ);
                class_6580 stateProvider = new class_6580(worldGenLevel.method_8412(), (class_5216.class_5487)((class_2378)worldGenLevel.method_30349().method_46759(class_7924.field_41244).orElseThrow()).method_46747(class_6731.field_35490).comp_349(), 0.5f, List.of(class_2246.field_10255.method_9564(), class_2246.field_37576.method_9564(), class_2246.field_10460.method_9564()));
                int worldSurfaceY = worldGenLevel.method_8624(class_2902.class_2903.field_13195, blockX, blockZ);
                double radiusFrequency = 0.05;
                double noise = noiseSampler.method_33658((double)blockX * radiusFrequency, 0.0, (double)blockZ * radiusFrequency) + 1.0;
                double localRadius = (int)class_3532.method_15390((double)((double)this.radius * 0.5), (double)this.radius, (double)(noise * 0.5));
                int blendWidth = 43;
                int rimSize = (int)(localRadius * 0.05);
                int fluidDepth = 1;
                class_2680[] topBlocks = LargeLakePiece.getSurfaceBlocks(mutableBlockPos, blockX, blockZ, worldSurfaceY, chunk);
                this.blendTerrainChecked(mutableBlockPos, localRadius, blendWidth, worldSurfaceY, blockX, blockZ, chunk, topBlocks, unsafeBoundingBox);
                placedWater[x + z * 16] = this.buildLakeChecked(worldGenLevel, random, mutableBlockPos, localRadius, blendWidth, rimSize, noiseSampler, fluidDepth, blockX, blockZ, chunk, (class_4651)stateProvider, topBlocks, unsafeBoundingBox);
            }
        }
        if (unsafeBoundingBox.valid()) {
            this.field_15315 = unsafeBoundingBox.toBoundingBox();
        }
        class_4076 sectionPos = class_4076.method_18681((class_1923)chunkPos, (int)worldGenLevel.method_32891());
        class_2338 blockPos = sectionPos.method_19767();
        Predicate<class_2338> test = blockPos1 -> {
            int localX = blockPos1.method_10263() & 0xF;
            int localZ = blockPos1.method_10260() & 0xF;
            return placedWater[localX + localZ * 16];
        };
        for (class_6880 lakeFeature : this.lakeFeatures) {
            this.placeWithContext(new class_5444(worldGenLevel, generator, Optional.empty()), random, blockPos, (class_6796)lakeFeature.comp_349(), test);
        }
    }

    private boolean placeWithContext(class_5444 context, class_5819 source, class_2338 pos, class_6796 feature, Predicate<class_2338> placingPos) {
        Stream<Object> stream = Stream.of(pos);
        for (class_6797 placementModifier : feature.comp_335()) {
            stream = stream.flatMap(blockPos -> placementModifier.method_14452(context, source, blockPos));
        }
        class_2975 configuredFeature = (class_2975)feature.comp_334().comp_349();
        MutableBoolean mutableBoolean = new MutableBoolean();
        stream.forEach(blockPos -> {
            if (placingPos.test((class_2338)blockPos) && configuredFeature.method_12862(context.method_34383(), context.method_39653(), source, blockPos)) {
                mutableBoolean.setTrue();
            }
        });
        return mutableBoolean.isTrue();
    }

    private boolean buildLakeChecked(class_5281 worldGenLevel, class_5819 random, class_2338.class_2339 mutableBlockPos, double localRadius, int blendWidth, int rimSize, class_3756 noiseSampler, int waterLevel, int blockX, int blockZ, class_2791 chunk, class_4651 stateProvider, class_2680[] topBlocks, UnsafeBoundingBox unsafeBoundingBox) {
        if (mutableBlockPos.method_33098(this.origin.method_10264()).method_19771((class_2382)this.origin, localRadius - (double)blendWidth - (double)rimSize)) {
            return this.buildLake(worldGenLevel, random, localRadius, blendWidth, rimSize, mutableBlockPos, noiseSampler, waterLevel, blockX, blockZ, chunk, stateProvider, topBlocks, unsafeBoundingBox);
        }
        return false;
    }

    private boolean buildLake(class_5281 worldGenLevel, class_5819 random, double localRadius, int blendWidth, int rimSize, class_2338.class_2339 mutableBlockPos, class_3756 noiseSampler, int fluidLevel, int blockX, int blockZ, class_2791 chunk, class_4651 stateProvider, class_2680[] topBlocks, UnsafeBoundingBox unsafeBoundingBox) {
        boolean placedWater = false;
        double offset = localRadius - (double)blendWidth - (double)rimSize;
        double delta = (mutableBlockPos.method_33098(this.origin.method_10264()).method_10262((class_2382)this.origin) - class_3532.method_33723((double)offset)) / class_3532.method_33723((double)(localRadius - offset));
        float frequency = 0.05f;
        double depthNoise = (noiseSampler.method_33658((double)((float)(mutableBlockPos.method_10263() + 100000) * frequency), 0.0, (double)((float)(mutableBlockPos.method_10260() + 100000) * frequency)) + 1.0) * 0.5;
        double depthOffset = class_3532.method_15390((double)0.0, (double)10.0, (double)depthNoise);
        int minGenY = this.origin.method_10264() - this.lakeDepth;
        int waterGenY = this.origin.method_10264() - fluidLevel;
        int depth = (int)class_3532.method_15390((double)this.origin.method_10264(), (double)((double)minGenY - depthOffset), (double)(-delta));
        for (int y = this.origin.method_10264(); y >= depth - 1; --y) {
            mutableBlockPos.method_10103(blockX, y, blockZ);
            if (y == depth - 1) {
                chunk.method_66480((class_2338)mutableBlockPos, class_2246.field_10340.method_9564());
            } else if (y <= depth + 3) {
                if (y < waterGenY) {
                    chunk.method_66480((class_2338)mutableBlockPos, stateProvider.method_23455(random, (class_2338)mutableBlockPos));
                } else {
                    chunk.method_66480((class_2338)mutableBlockPos, topBlocks[Math.min(this.origin.method_10264() - y, topBlocks.length - 1)]);
                    ((RandomTickScheduler)chunk).scheduleRandomTick(mutableBlockPos.method_10062());
                    chunk.method_12039((class_2338)mutableBlockPos);
                }
            } else if (y > waterGenY) {
                chunk.method_66480((class_2338)mutableBlockPos, class_2246.field_10124.method_9564());
            } else {
                placedWater = true;
                chunk.method_66480((class_2338)mutableBlockPos, class_2246.field_10382.method_9564());
                worldGenLevel.method_64312(mutableBlockPos.method_10062(), (class_3611)class_3612.field_15910, 0);
            }
            unsafeBoundingBox.encapsulate((class_2382)mutableBlockPos);
        }
        return placedWater;
    }

    private void blendTerrainChecked(class_2338.class_2339 mutableBlockPos, double localRadius, int blendWidth, int worldSurfaceY, int blockX, int blockZ, class_2791 chunk, class_2680[] topBlocks, UnsafeBoundingBox unsafeBoundingBox) {
        if (mutableBlockPos.method_33098(this.origin.method_10264()).method_19771((class_2382)this.origin, localRadius)) {
            this.blendTerrain(localRadius, blendWidth, mutableBlockPos, worldSurfaceY, blockX, blockZ, chunk, topBlocks, unsafeBoundingBox);
        }
    }

    private void blendTerrain(double localRadius, int blendWidth, class_2338.class_2339 mutableBlockPos, int worldSurfaceY, int blockX, int blockZ, class_2791 chunk, class_2680[] topBlocks, UnsafeBoundingBox unsafeBoundingBox) {
        int y;
        double offset = localRadius - (double)blendWidth;
        double delta = (mutableBlockPos.method_33098(this.origin.method_10264()).method_10262((class_2382)this.origin) - class_3532.method_33723((double)offset)) / class_3532.method_33723((double)(localRadius - offset));
        int height = (int)class_3532.method_15390((double)this.origin.method_10264(), (double)worldSurfaceY, (double)delta);
        if (this.origin.method_10264() >= worldSurfaceY) {
            for (y = worldSurfaceY; y <= height; ++y) {
                mutableBlockPos.method_10103(blockX, y, blockZ);
                chunk.method_66480((class_2338)mutableBlockPos, topBlocks[topBlocks.length - 1]);
                unsafeBoundingBox.encapsulate((class_2382)mutableBlockPos);
            }
        } else {
            for (y = worldSurfaceY; y > height; --y) {
                mutableBlockPos.method_10103(blockX, y, blockZ);
                chunk.method_66480((class_2338)mutableBlockPos, class_2246.field_10124.method_9564());
                unsafeBoundingBox.encapsulate((class_2382)mutableBlockPos);
            }
        }
        for (y = 0; y < topBlocks.length; ++y) {
            mutableBlockPos.method_10103(blockX, height - y, blockZ);
            chunk.method_66480((class_2338)mutableBlockPos, topBlocks[y]);
            ((RandomTickScheduler)chunk).scheduleRandomTick(mutableBlockPos.method_10062());
            chunk.method_12039((class_2338)mutableBlockPos);
        }
    }

    private static class_2680 @NotNull [] getSurfaceBlocks(class_2338.class_2339 mutableBlockPos, int blockX, int blockZ, int worldSurfaceY, class_2791 chunk) {
        class_2680[] topBlocks = new class_2680[]{class_2246.field_10219.method_9564(), class_2246.field_10566.method_9564(), class_2246.field_10566.method_9564(), class_2246.field_10340.method_9564(), class_2246.field_10340.method_9564()};
        for (int y = 0; y < topBlocks.length; ++y) {
            mutableBlockPos.method_10103(blockX, worldSurfaceY - y, blockZ);
            class_2680 blockState = chunk.method_8320((class_2338)mutableBlockPos);
            if (blockState.method_26215() || !blockState.method_26227().method_15769()) continue;
            topBlocks[y] = blockState;
        }
        return topBlocks;
    }
}

