/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.sharpenedrock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3756;
import net.minecraft.class_5819;
import net.minecraft.class_6677;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructureTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.sharpenedrock.SharpenedRockConfig;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.sharpenedrock.SharpenedRockPiece;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Vector3d;

public class SharpenedRockStructure
extends class_3195 {
    public static final class_3756 NOISE = new class_3756((class_5819)new class_6677(100L));
    public static final MapCodec<SharpenedRockStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SharpenedRockStructure.method_42697((RecordCodecBuilder.Instance)builder), (App)SharpenedRockConfig.CODEC.fieldOf("config").forGetter(sharpenedRockStructure -> sharpenedRockStructure.config)).apply((Applicative)builder, SharpenedRockStructure::new));
    private final SharpenedRockConfig config;

    public SharpenedRockStructure(class_3195.class_7302 structureSettings, SharpenedRockConfig config) {
        super(structureSettings);
        this.config = config;
    }

    @NotNull
    protected Optional<class_3195.class_7150> method_38676(@NotNull class_3195.class_7149 context) {
        return SharpenedRockStructure.method_41612((class_3195.class_7149)context, (class_2902.class_2903)class_2902.class_2903.field_13195, piecesBuilder -> {
            class_2919 random = context.comp_566();
            class_7138 randomState = context.comp_564();
            class_2794 chunkGenerator = context.comp_562();
            int radius = this.config.radius().method_35008((class_5819)random);
            class_1923 chunkPos = context.comp_568();
            int blockX = chunkPos.method_33939(random.method_43048(16));
            int blockZ = chunkPos.method_33941(random.method_43048(16));
            class_2338 origin = new class_2338(blockX, chunkGenerator.method_16397(blockX, blockZ, class_2902.class_2903.field_13195, context.comp_569(), randomState) - (int)((double)radius * 0.7), blockZ);
            class_5819 randomSource = class_5819.method_43049((long)(context.comp_567() + origin.method_10063()));
            class_5819 angleRandom = class_5819.method_43049((long)(context.comp_567() + (long)(origin.method_10263() << 2) + (long)(origin.method_10260() << 2)));
            float pitch = this.config.pitch().method_33920((class_5819)random);
            float yaw = this.config.yaw().method_33920(angleRandom);
            Long2ObjectOpenHashMap chunks = new Long2ObjectOpenHashMap();
            Quaterniond quaternion = new Quaterniond();
            quaternion.rotateY(Math.toRadians(yaw));
            quaternion.rotateX(Math.toRadians(pitch));
            int[] heightCache = SharpenedRockStructure.createHeightCache(radius, origin);
            SharpenedRockStructure.generateFromCache(radius, heightCache, origin, quaternion, false, (rotatedPos, unRotatedPos) -> {
                Pair entry = (Pair)chunks.computeIfAbsent(class_1923.method_37232((class_2338)rotatedPos), aLong -> Pair.of((Object)Pair.of((Object)new MutableBoolean(true), (Object)new MutableBoolean(false)), (Object)new class_3341(rotatedPos)));
                ((class_3341)entry.right()).method_34389(rotatedPos);
                ((MutableBoolean)((Pair)entry.left()).left()).setTrue();
                return true;
            });
            SharpenedRockStructure.generateFromCache(radius, heightCache, origin, quaternion, true, (rotatedPos, unRotatedPos) -> {
                Pair entry = (Pair)chunks.computeIfAbsent(class_1923.method_37232((class_2338)rotatedPos), aLong -> Pair.of((Object)Pair.of((Object)new MutableBoolean(false), (Object)new MutableBoolean(true)), (Object)new class_3341(rotatedPos)));
                ((class_3341)entry.right()).method_34389(rotatedPos);
                ((MutableBoolean)((Pair)entry.left()).right()).setTrue();
                return true;
            });
            chunks.long2ObjectEntrySet().fastForEach(boundingBoxEntry -> piecesBuilder.method_35462((class_3443)new SharpenedRockPiece(origin, radius, ((MutableBoolean)((Pair)((Pair)boundingBoxEntry.getValue()).left()).right()).isTrue(), ((MutableBoolean)((Pair)((Pair)boundingBoxEntry.getValue()).left()).left()).isTrue(), pitch, yaw, heightCache, 0, (class_3341)((Pair)boundingBoxEntry.getValue()).right())));
        });
    }

    public static int[] createHeightCache(int radius, class_2338 origin) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int diameter = radius * 2;
        int[] heightCache = new int[diameter * diameter];
        for (double x = (double)(-radius); x <= (double)radius; x += 0.5) {
            for (double z = (double)(-radius); z <= (double)radius; z += 0.5) {
                mutableBlockPos.method_25504((class_2382)origin, (int)x, 0, (int)z);
                int idx = (int)x + radius + ((int)z + radius) * radius;
                if (!mutableBlockPos.method_19771((class_2382)origin, (double)radius)) continue;
                double height = SharpenedRockStructure.getHeight(radius, origin, mutableBlockPos);
                heightCache[idx] = (int)height;
            }
        }
        return heightCache;
    }

    public static void generateFromCache(int radius, int[] heights, class_2338 origin, Quaterniond quaternion, boolean reverse, BiPredicate<class_2338, class_2338> action) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        if (reverse) {
            quaternion.rotateX(Math.toRadians(180.0));
            quaternion.rotateY(Math.toRadians(180.0));
        }
        Vector3d vector3d = new Vector3d(0.0, 0.0, 0.0);
        for (double x = (double)(-radius); x <= (double)radius; x += 0.5) {
            block1: for (double z = (double)(-radius); z <= (double)radius; z += 0.5) {
                class_2338.class_2339 mutable1 = new class_2338.class_2339();
                int height = heights[(int)x + radius + ((int)z + radius) * radius];
                for (int y = 0; y < height; ++y) {
                    mutableBlockPos.method_25504((class_2382)origin, (int)x, 0, (int)z);
                    if (!mutableBlockPos.method_19771((class_2382)origin, (double)radius)) continue;
                    vector3d.set(x, (double)y, z);
                    Vector3d transformed = quaternion.transform(vector3d);
                    mutable1.method_25504((class_2382)origin, (int)Math.round(transformed.x()), (int)Math.round(transformed.y()), (int)Math.round(transformed.z()));
                    if (!action.test((class_2338)mutable1, (class_2338)mutableBlockPos.method_33098(y))) continue block1;
                }
            }
        }
        if (reverse) {
            quaternion.rotateY(Math.toRadians(180.0));
            quaternion.rotateX(Math.toRadians(180.0));
        }
    }

    private static double getHeight(int radius, class_2338 origin, class_2338.class_2339 mutableBlockPos) {
        double noise = NOISE.method_33658((double)mutableBlockPos.method_10263() * 0.1, 0.0, (double)mutableBlockPos.method_10260() * 0.1);
        double factor = origin.method_10262((class_2382)mutableBlockPos) / (double)class_3532.method_34954((int)radius);
        double amplifier = BlendingFunction.EaseInCirc.INSTANCE.apply(1.0 - factor, 15.0, 100.0);
        double noiseAmp = noise * (amplifier * 2.0);
        return amplifier + noiseAmp;
    }

    @NotNull
    public class_7151<?> method_41618() {
        return BWGStructureTypes.SHARPENED_ROCK.get();
    }
}

