/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.fabric;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FlattenableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.fabricmc.fabric.api.registry.TillableBlockRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2893;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.potionstudios.biomeswevegone.config.configs.BWGTradesConfig;
import net.potionstudios.biomeswevegone.config.configs.BWGWorldGenConfig;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGVillagerTrades;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGVillagerTypes;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import net.potionstudios.biomeswevegone.world.item.tools.ToolInteractions;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.BlockFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.modifiers.BWGBiomeModifiers;
import org.apache.logging.log4j.util.TriConsumer;

public class VanillaCompatFabric {
    public static void init() {
        ToolInteractions.registerStrippableBlocks(StrippableBlockRegistry::register);
        BlockFeatures.registerFlammable((TriConsumer<class_2248, Integer, Integer>)((TriConsumer)(arg_0, arg_1, arg_2) -> ((FlammableBlockRegistry)FlammableBlockRegistry.getDefaultInstance()).add(arg_0, arg_1, arg_2)));
        BlockFeatures.registerFurnaceFuels((arg_0, arg_1) -> ((FuelRegistry)FuelRegistry.INSTANCE).add(arg_0, arg_1));
        BlockFeatures.registerCompostables((arg_0, arg_1) -> ((CompostingChanceRegistry)CompostingChanceRegistry.INSTANCE).add(arg_0, arg_1));
        ToolInteractions.registerFlattenables(FlattenableBlockRegistry::register);
        ToolInteractions.registerTillables((block, pair) -> TillableBlockRegistry.register((class_2248)block, (Predicate)((Predicate)pair.getFirst()), (Consumer)((Consumer)pair.getSecond())));
        VanillaCompatFabric.registerBiomeModifiers();
        VanillaCompatFabric.registerLootModifiers();
        if (!BWGTradesConfig.INSTANCE.trades.disableTrades.value().booleanValue()) {
            VanillaCompatFabric.registerTrades();
            if (BWGTradesConfig.INSTANCE.wanderingTraderTrades.enableBWGItemsTrades.value().booleanValue()) {
                VanillaCompatFabric.registerWanderingTrades();
            }
        }
        UseEntityCallback.EVENT.register((player, level, interactionHand, entity, entityHitResult) -> PumpkinWarden.villagerToPumpkinWarden((class_1297)player, player.method_5998(interactionHand), level) ? class_1269.field_5812 : class_1269.field_5811);
        BWGVillagerTypes.setVillagerBiomes(class_3854.field_17078::put);
    }

    private static void registerBiomeModifiers() {
        if (BWGWorldGenConfig.INSTANCE.get().vanillaAdditions()) {
            BWGBiomeModifiers.init();
            BWGBiomeModifiers.BIOME_MODIFIERS_FACTORIES.values().stream().filter(BWGBiomeModifiers.BWGBiomeModifier::enabled).forEach(modifier -> BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey(modifier.biomes()), (class_2893.class_2895)modifier.step(), modifier.feature()));
        }
    }

    private static void registerLootModifiers() {
        LootTableEvents.MODIFY.register((resourceManager, lootDataManager, resourceLocation, builder, source) -> {
            if (resourceLocation.equals((Object)class_39.field_44748)) {
                builder.method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).with(class_77.method_411((class_1935)BWGBlocks.BLACK_ROSE.getBlock()).method_419()).with(class_77.method_411((class_1935)BWGBlocks.PROTEA_FLOWER.getBlock()).method_419()).with(class_77.method_411((class_1935)BWGBlocks.SILVER_VASE_FLOWER.getBlock()).method_419()));
            }
        });
    }

    private static void registerTrades() {
        BWGVillagerTrades.makeTrades();
        if (BWGVillagerTrades.TRADES.isEmpty()) {
            return;
        }
        BWGVillagerTrades.TRADES.forEach((villagerProfession, offersMap) -> offersMap.forEach((level, offers) -> TradeOfferHelper.registerVillagerOffers((class_3852)villagerProfession, (int)level, factory -> factory.addAll(offers))));
    }

    private static void registerWanderingTrades() {
        if (!BWGTradesConfig.INSTANCE.wanderingTraderTrades.enableBWGItemsTrades.value().booleanValue()) {
            return;
        }
        BWGVillagerTrades.makeWanderingTrades();
        BWGVillagerTrades.WANDERING_TRADER_TRADES.forEach((level, offers) -> TradeOfferHelper.registerWanderingTraderOffers((int)level, factory -> factory.addAll(offers)));
    }
}

