/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.neoforge;

import com.google.auto.service.AutoService;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.luckperms.api.LuckPermsProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.neoforge.world.level.block.BWGNeoForgeFarmLandBlock;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.custom.BWGFarmLandBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import org.jetbrains.annotations.NotNull;

@AutoService(value={PlatformHandler.class})
public final class NeoForgePlatformHandler
implements PlatformHandler {
    private static final boolean luckPerms = ModList.get().isLoaded("luckperms");
    private static final Map<ResourceKey<?>, DeferredRegister> CACHED = new Reference2ObjectOpenHashMap();

    @Override
    public PlatformHandler.Platform getPlatform() {
        return PlatformHandler.Platform.NEOFORGE;
    }

    @Override
    public Path configPath() {
        return FMLPaths.CONFIGDIR.get().resolve("biomeswevegone");
    }

    @Override
    public boolean hasPermission(@NotNull CommandSourceStack sourceStack, @NotNull String permission) {
        return PlatformHandler.super.hasPermission(sourceStack, permission) || luckPerms && LuckPermsProvider.get().getUserManager().getUser(sourceStack.getPlayer().getUUID()).getCachedData().getPermissionData().checkPermission(permission).asBoolean();
    }

    @Override
    public FlowerPotBlock createPottedBlock(Supplier<? extends Block> block, BlockBehaviour.Properties properties) {
        return new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, block, properties);
    }

    @Override
    public BWGFarmLandBlock bwgFarmLandBlock(BlockBehaviour.Properties properties, Supplier<Block> dirt) {
        return new BWGNeoForgeFarmLandBlock(properties, dirt);
    }

    @Override
    public WoodType createWoodType(String id, @NotNull BlockSetType setType) {
        return WoodType.register((WoodType)new WoodType("biomeswevegone:" + id, setType));
    }

    @Override
    public Supplier<SimpleParticleType> registerCreateParticle(String name) {
        return this.register(BuiltInRegistries.PARTICLE_TYPE, name, () -> new SimpleParticleType(false));
    }

    @Override
    @SafeVarargs
    public final Supplier<CreativeModeTab> createCreativeTab(String name, Supplier<ItemStack> icon, ArrayList<Supplier<? extends Item>> ... items) {
        return this.register(BuiltInRegistries.CREATIVE_MODE_TAB, name, () -> CreativeModeTab.builder().title((Component)Component.translatable((String)("itemGroup.biomeswevegone." + name))).icon(icon).displayItems((context, entries) -> {
            for (ArrayList item : items) {
                item.forEach(item1 -> entries.accept((ItemLike)item1.get()));
            }
        }).withSearchBar().build());
    }

    @Override
    public <T> Supplier<T> register(Registry<? super T> registry, String name, Supplier<T> value) {
        return CACHED.computeIfAbsent(registry.key(), key -> DeferredRegister.create((ResourceLocation)registry.key().location(), (String)"biomeswevegone")).register(name, value);
    }

    @Override
    public <T> Supplier<Holder.Reference<T>> registerForHolder(Registry<T> registry, String name, Supplier<T> value) {
        DeferredHolder registryObject = CACHED.computeIfAbsent(registry.key(), key -> DeferredRegister.create((ResourceLocation)registry.key().location(), (String)"biomeswevegone")).register(name, value);
        return () -> (Holder.Reference)registryObject.getDelegate();
    }

    public static void registerPottedPlants() {
        BWGBlocks.BLOCKS.forEach((Consumer<Supplier<? extends Block>>)((Consumer<Supplier>)entry -> {
            if (entry.get() instanceof FlowerPotBlock) {
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)((FlowerPotBlock)entry.get()).getPotted())), entry);
            }
        }));
        BWGWood.WOOD.forEach((Consumer<Supplier<? extends Block>>)((Consumer<Supplier>)entry -> {
            if (entry.get() instanceof FlowerPotBlock) {
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)((FlowerPotBlock)entry.get()).getPotted())), entry);
            }
        }));
    }

    public static void register(IEventBus bus) {
        CACHED.values().forEach(deferredRegister -> deferredRegister.register(bus));
    }
}

