/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.decoration;

import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.item.custom.WreathItem;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Wreath
extends HangingEntity
implements VariantHolder<Type> {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.defineId(Wreath.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Wreath(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
        this.setVariant(Type.DEFAULT);
    }

    public Wreath(Level level, BlockPos pos, Direction facingDirection, Type type) {
        this(BWGEntityType.WREATH.get(), level, pos, facingDirection, type);
    }

    public Wreath(EntityType<? extends HangingEntity> entityType, Level level, BlockPos pos, Direction facingDirection, Type type) {
        super(entityType, level, pos);
        this.setVariant(type);
        this.setDirection(facingDirection);
    }

    protected void setDirection(@NotNull Direction facingDirection) {
        Validate.notNull((Object)facingDirection);
        this.direction = facingDirection;
        if (facingDirection.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot(this.direction.get2DDataValue() * 90);
        } else {
            this.setXRot(-90 * facingDirection.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    @NotNull
    protected AABB calculateBoundingBox(@NotNull BlockPos pos, @NotNull Direction direction) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos).relative(direction, -0.46875);
        Direction.Axis axis = direction.getAxis();
        double d = axis == Direction.Axis.X ? 0.0625 : 0.75;
        double e = axis == Direction.Axis.Y ? 0.0625 : 0.75;
        double g = axis == Direction.Axis.Z ? 0.0625 : 0.75;
        return AABB.ofSize((Vec3)vec3, (double)d, (double)e, (double)g);
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.AZALEA_LEAVES_PLACE);
    }

    public void dropItem(@NotNull ServerLevel level, @Nullable Entity entity) {
        if (level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Player player;
            this.playSound(SoundEvents.AZALEA_LEAVES_BREAK);
            if (!(entity instanceof Player) || !(player = (Player)entity).hasInfiniteMaterials()) {
                this.spawnAtLocation(level, (ItemLike)this.getVariant().getItem());
            }
            this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, entity);
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        builder.define(DATA_ID_TYPE, (Object)Type.DEFAULT.ordinal());
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("Type", this.getVariant().getSerializedName());
        tag.putByte("Facing", (byte)this.direction.get3DDataValue());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Type", 8)) {
            this.setVariant(Type.byName(tag.getString("Type")));
        }
        this.setDirection(Direction.from3DDataValue((int)tag.getByte("Facing")));
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(@NotNull ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, this.direction.get3DDataValue(), this.getPos());
    }

    public void recreateFromPacket(@NotNull ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.setDirection(Direction.from3DDataValue((int)packet.getData()));
    }

    @Nullable
    public ItemStack getPickResult() {
        return this.getVariant().getItem().getDefaultInstance();
    }

    @NotNull
    protected Component getTypeName() {
        return Component.translatable((String)this.getVariant().getItem().getDescriptionId());
    }

    public void setVariant(@NotNull Type variant) {
        this.entityData.set(DATA_ID_TYPE, (Object)variant.ordinal());
    }

    @NotNull
    public Type getVariant() {
        return Type.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    public static enum Type implements StringRepresentable
    {
        HOLLY("holly", () -> BWGItems.HOLLY_WREATH),
        MUSHROOM("mushroom", () -> BWGItems.MUSHROOM_WREATH),
        ODDION("oddion", () -> BWGItems.ODDION_WREATH),
        PETAL("petal", () -> BWGItems.PETAL_WREATH),
        ROSY("rosy", () -> BWGItems.ROSY_WREATH),
        WINTER_ROSY("winter_rosy", () -> BWGItems.WINTER_ROSY_WREATH),
        DEFAULT("default", () -> BWGItems.WREATH);

        private final String name;
        private final Supplier<Supplier<WreathItem>> item;
        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;

        private Type(String name, Supplier<Supplier<WreathItem>> item) {
            this.name = name;
            this.item = item;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public WreathItem getItem() {
            return this.item.get().get();
        }

        public static Type byId(int id) {
            return BY_ID.apply(id);
        }

        public static Type byName(String name) {
            return (Type)CODEC.byName(name, (Enum)DEFAULT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

