/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.flower;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BWGFlowerBlock
extends FlowerBlock {
    private final TagKey<Block> validGround;
    private final VoxelShape SHAPE;

    public BWGFlowerBlock(BlockBehaviour.Properties properties, TagKey<Block> validGround, VoxelShape shape) {
        super(MobEffects.SATURATION, 7.0f, properties);
        this.validGround = validGround;
        this.SHAPE = shape;
    }

    public BWGFlowerBlock(BlockBehaviour.Properties properties) {
        this(properties, (TagKey<Block>)BlockTags.DIRT, Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0));
    }

    protected boolean mayPlaceOn(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return state.is(this.validGround);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Vec3 vec3 = state.getOffset(pos);
        return this.SHAPE.move(vec3.x, vec3.y, vec3.z);
    }
}

