/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.plateau;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructureTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.plateau.GourPlateauPiece;
import org.jetbrains.annotations.NotNull;

public class GourPlateauStructure
extends Structure {
    public static final MapCodec<GourPlateauStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)GourPlateauStructure.settingsCodec((RecordCodecBuilder.Instance)builder)).apply((Applicative)builder, GourPlateauStructure::new));

    public GourPlateauStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    @NotNull
    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        WorldgenRandom random = context.random();
        int blockX = chunkPos.getBlockX(random.nextInt(16));
        int blockZ = chunkPos.getBlockZ(random.nextInt(16));
        float twoPi = (float)Math.PI * 2;
        int slices = 20;
        double sliceSize = twoPi / (float)slices;
        int plateauRadius = random.nextIntBetweenInclusive(48, 96);
        int sampleY = QuartPos.fromBlock((int)context.chunkGenerator().getSeaLevel());
        int minPlateauRadius = 16;
        boolean shouldCancel = true;
        for (int modifiedPlateauRadius = plateauRadius; modifiedPlateauRadius >= minPlateauRadius; modifiedPlateauRadius -= 4) {
            boolean success = true;
            for (int i = 0; i <= slices; ++i) {
                double angle = (double)i * sliceSize;
                int offsetX = (int)Math.round(Math.sin(angle) * (double)modifiedPlateauRadius);
                int offsetZ = (int)Math.round(Math.cos(angle) * (double)modifiedPlateauRadius);
                if (context.validBiome().test(context.biomeSource().getNoiseBiome(QuartPos.fromBlock((int)(blockX + offsetX)), sampleY, QuartPos.fromBlock((int)(blockZ + offsetZ)), context.randomState().sampler()))) continue;
                success = false;
                break;
            }
            if (!success) continue;
            plateauRadius = modifiedPlateauRadius - 4;
            shouldCancel = false;
            break;
        }
        if (shouldCancel) {
            return Optional.empty();
        }
        int finalPlateauRadius = plateauRadius;
        return GourPlateauStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, piecesBuilder -> {
            RandomState randomState = context.randomState();
            ChunkGenerator chunkGenerator = context.chunkGenerator();
            WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(context.seed()));
            ImprovedNoise noiseSampler = new ImprovedNoise((RandomSource)worldgenRandom);
            LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
            BlockPos plateauOrigin = new BlockPos(blockX, chunkGenerator.getBaseHeight(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, levelHeightAccessor, randomState) - 10, blockZ);
            double noise = noiseSampler.noise((double)plateauOrigin.getX() * 5.0E-4, 0.0, (double)plateauOrigin.getZ() * 5.0E-4) + 1.0;
            double height = (int)((noise *= 0.5) * 100.0);
            GourPlateauStructure.createArenaFloor(context, piecesBuilder, finalPlateauRadius, plateauOrigin, (int)height + chunkGenerator.getSeaLevel(), levelHeightAccessor);
        });
    }

    private static void createArenaFloor(Structure.GenerationContext context, StructurePiecesBuilder piecesBuilder, int arenaFloorRadius, BlockPos arenaOrigin, int topY, LevelHeightAccessor levelHeightAccessor) {
        for (int chunkX = -(SectionPos.blockToSectionCoord((int)arenaFloorRadius) + 1); chunkX <= SectionPos.blockToSectionCoord((int)arenaFloorRadius) + 1; ++chunkX) {
            for (int chunkZ = -(SectionPos.blockToSectionCoord((int)arenaFloorRadius) + 1); chunkZ <= SectionPos.blockToSectionCoord((int)arenaFloorRadius) + 1; ++chunkZ) {
                BlockPos chunkWorldPos = new BlockPos(SectionPos.sectionToBlockCoord((int)(context.chunkPos().x + chunkX)), arenaOrigin.getY(), SectionPos.sectionToBlockCoord((int)(context.chunkPos().z + chunkZ)));
                BoundingBox boundingBox = new BoundingBox(chunkWorldPos.getX(), levelHeightAccessor.getMinY(), chunkWorldPos.getZ(), chunkWorldPos.getX() + 15, levelHeightAccessor.getMaxY(), chunkWorldPos.getZ() + 15);
                piecesBuilder.addPiece((StructurePiece)new GourPlateauPiece(arenaOrigin, arenaFloorRadius, topY, boundingBox));
            }
        }
    }

    @NotNull
    public StructureType<?> type() {
        return BWGStructureTypes.OVERHANG_PLATEAU.get();
    }
}

