/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.npc;

import java.util.function.BiConsumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;

public class BWGVillagerTypes {
    public static final ResourceKey<VillagerType> RED_ROCK = BWGVillagerTypes.register("red_rock");
    public static final ResourceKey<VillagerType> SALEM = BWGVillagerTypes.register("salem");
    public static final ResourceKey<VillagerType> SKYRIS = BWGVillagerTypes.register("skyris");

    public static void setVillagerBiomes(BiConsumer<ResourceKey<Biome>, ResourceKey<VillagerType>> consumer) {
        consumer.accept(BWGBiomes.MOJAVE_DESERT, (ResourceKey<VillagerType>)VillagerType.DESERT);
        consumer.accept(BWGBiomes.WINDSWEPT_DESERT, (ResourceKey<VillagerType>)VillagerType.DESERT);
        consumer.accept(BWGBiomes.TROPICAL_RAINFOREST, (ResourceKey<VillagerType>)VillagerType.JUNGLE);
        consumer.accept(BWGBiomes.WHITE_MANGROVE_MARSHES, (ResourceKey<VillagerType>)VillagerType.SWAMP);
        consumer.accept(BWGBiomes.BAYOU, (ResourceKey<VillagerType>)VillagerType.SWAMP);
        consumer.accept(BWGBiomes.CYPRESS_SWAMPLANDS, (ResourceKey<VillagerType>)VillagerType.SWAMP);
        consumer.accept(BWGBiomes.CYPRESS_WETLANDS, (ResourceKey<VillagerType>)VillagerType.SWAMP);
        consumer.accept(BWGBiomes.BAYOU, (ResourceKey<VillagerType>)VillagerType.SWAMP);
        consumer.accept(BWGBiomes.PALE_BOG, (ResourceKey<VillagerType>)VillagerType.SWAMP);
        consumer.accept(BWGBiomes.RED_ROCK_VALLEY, RED_ROCK);
        consumer.accept(BWGBiomes.RED_ROCK_PEAKS, RED_ROCK);
        consumer.accept(BWGBiomes.SKYRIS_VALE, SKYRIS);
        consumer.accept(BWGBiomes.WEEPING_WITCH_FOREST, SALEM);
    }

    private static ResourceKey<VillagerType> register(String key) {
        PlatformHandler.PLATFORM_HANDLER.register(BuiltInRegistries.VILLAGER_TYPE, key, VillagerType::new);
        return BiomesWeveGone.key(Registries.VILLAGER_TYPE, key);
    }

    public static void villagerTypes() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biomes We've Gone villager types");
    }
}

