/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.biome;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.potionstudios.biomeswevegone.client.particle.BWGParticles;
import net.potionstudios.biomeswevegone.sounds.BWGSounds;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.features.BWGOverworldDefaultFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGOverworldTreePlacedFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGOverworldVegationPlacedFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGPlacedFeatures;

class BWGOverworldBiomes {
    BWGOverworldBiomes() {
    }

    private static void addDefaultOverworldGeneration(BiomeGenerationSettings.Builder generationSettings) {
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generationSettings);
    }

    private static BiomeGenerationSettings.Builder setupDefaultOverworldGeneration(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addDefaultOverworldGeneration(generationSettings);
        return generationSettings;
    }

    private static BiomeGenerationSettings.Builder setupDefaultOverworldGenerationWithoutLava(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        generationSettings.addCarver(Carvers.CAVE);
        generationSettings.addCarver(Carvers.CAVE_EXTRA_UNDERGROUND);
        generationSettings.addCarver(Carvers.CANYON);
        generationSettings.addFeature(GenerationStep.Decoration.LAKES, MiscOverworldPlacements.LAKE_LAVA_UNDERGROUND);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generationSettings);
        return generationSettings;
    }

    private static void addSpawn(MobSpawnSettings.Builder builder, EntityType<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        builder.addSpawn(entityType.getCategory(), weight, new MobSpawnSettings.SpawnerData(entityType, minGroupSize, maxGroupSize));
    }

    protected static Biome alliumShrubland(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ALLIUM_SHRUBLAND_FLOWERS);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.GIANT_ALLIUMS);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, BWGEntityType.ODDION.get(), 18, 2, 8);
        BiomeDefaultFeatures.plainsSpawns((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.4f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome amaranthGrassland(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.AMARANTH_GRASSLAND_FLOWERS);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addJacarandaBushes(generationSettings);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldDefaultFeatures.addSparseJacarandaTrees(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.plainsSpawns((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.4f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome araucariaSavanna(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaTrees((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addWarmFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.SPARSE_ARAUCARIA_TREES);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.plainsSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.LLAMA, 1, 3, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ARMADILLO, 10, 2, 3);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(temperature).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(10860373).foliageColorOverride(10860373).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome aspenBoreal(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addForestGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addLeafLitterPatch((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.ASPEN_TREES);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldDefaultFeatures.addLeafPile(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ORANGE_DAISY);
        BWGOverworldDefaultFeatures.addRose(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        float temperature = 0.5f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.6f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(11909994).foliageColorOverride(14194987).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome pumpkinValley(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addLeafLitterPatch((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldDefaultFeatures.addLeafPileAbundant(generationSettings);
        BWGOverworldDefaultFeatures.addMeadowShrubs(generationSettings);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.LARGE_PUMPKIN);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.MEDIUM_PUMPKIN);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.SMALL_PUMPKIN);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.35f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(11513689).foliageColorOverride(11957015).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome baobabSavanna(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaTrees((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addWarmFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BAOBAB_TREES);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.HORSE, 1, 2, 6);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.DONKEY, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.LLAMA, 1, 3, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ARMADILLO, 10, 2, 3);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(temperature).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(10860373).foliageColorOverride(10860373).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome basaltBarrera(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.LARGE_BASALT_COLUMN);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.SMALL_BASALT_COLUMN);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.BASALT_DELTA);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.85f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.75f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome bayou(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSwampDelta(generationSettings);
        BiomeDefaultFeatures.addSwampClayDisk((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addJungleGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSwampExtraVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_SWAMP);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BAYOU_TREES);
        BWGOverworldDefaultFeatures.addBWGSwampVegetation(generationSettings);
        BWGOverworldDefaultFeatures.addCattails(generationSettings);
        BWGOverworldDefaultFeatures.addLeatherFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addMudDisks(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SLIME, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FROG, 10, 2, 5);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.TROPICAL_FISH, 25, 8, 8);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_SWAMP);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4815438).waterFogColor(6717479).grassColorOverride(7375928).foliageColorOverride(6337104).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome blackForest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addMossyStoneBlock((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addGiantTaigaVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BiomeDefaultFeatures.addRareBerryBushes((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BLACK_FOREST_TREES);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addSages(generationSettings);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        BWGOverworldDefaultFeatures.addWinterSucculent(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.BLACK_ROSE);
        BWGOverworldDefaultFeatures.addMossyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)100, (int)25, (int)100, (boolean)false);
        float temperature = 0.45f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.65f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(5011004).foliageColorOverride(0x228B22).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome canadianShield(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addMossyStoneBlock((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addGiantTaigaVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.CANADIAN_SHIELD_TREES);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldDefaultFeatures.addSparseAspenTreesShrubs(generationSettings);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.HYDRANGEAS);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome crimsonTundra(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addGiantTaigaVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldDefaultFeatures.addSparseRedOrangeSpruceTrees(generationSettings);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addRose(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 10, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.STRAY, 85, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.POLAR_BEAR, 1, 1, 2);
        float temperature = 0.75f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.1f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(6200521).waterFogColor(6200521).grassColorOverride(13388072).foliageColorOverride(13388072).fogColor(12638463).skyColor(0xC1CCCC).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.01428f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome sakuraGrove(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addCherryGroveVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.WHITE_SAKURA_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.YELLOW_SAKURA_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.JAPANESE_ORCHID);
        BWGOverworldDefaultFeatures.addLeafPile(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.SAKURA_PETALS);
        BWGOverworldDefaultFeatures.addFlowerPatches(generationSettings);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 5, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        float temperature = 0.7f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(10999916).foliageColorOverride(10999916).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome cikaWoods(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addForestGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addLeafLitterPatch((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BiomeDefaultFeatures.addRareBerryBushes((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.CIKA_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BROWN_BIRCH_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.LARGE_PUMPKIN);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.MEDIUM_PUMPKIN);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addIris(generationSettings);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        BWGOverworldDefaultFeatures.addWinterSucculent(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        float temperature = 0.35f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(13414235).foliageColorOverride(13414235).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome coniferousForest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean snowy) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addMossyStoneBlock((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addGiantTaigaVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BiomeDefaultFeatures.addRareBerryBushes((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.CONIFER_TREES);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addIris(generationSettings);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        BWGOverworldDefaultFeatures.addWinterSucculent(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SPIDER, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, snowy ? EntityType.HUSK : EntityType.ZOMBIE, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SKELETON, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ZOMBIE_VILLAGER, 25, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.CREEPER, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SLIME, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ENDERMAN, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WITCH, 5, 1, 1);
        float temperature = snowy ? -0.5f : 0.25f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(5011004).foliageColorOverride(0x228B22).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome cragGardens(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.CRAG_LAKE);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGPlacedFeatures.VINE_PROCESSOR);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGPlacedFeatures.LUSH_BLOCKS_PROCESSOR);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.CRAG_BAMBOO);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.CRAG_BUSHES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.CRAG_LAKE_VEGETATION);
        BiomeDefaultFeatures.addJungleGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.GUIANA_SHIELD_TREES);
        BWGOverworldDefaultFeatures.addBWGTropicFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_NORMAL);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.baseJungleSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.PARROT, 40, 1, 2);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.OCELOT, 2, 1, 1);
        float temperature = 0.95f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().backgroundMusic(Musics.createGameMusic((Holder)((Holder)BWGSounds.MUSIC_BIOME_CRAG_GARDENS.get()))).waterColor(9230578).waterFogColor(2835532).grassColorOverride(10145074).foliageColorOverride(10145074).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome cypressSwamplands(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSwampDelta(generationSettings);
        BiomeDefaultFeatures.addSwampClayDisk((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSwampExtraVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_SWAMP);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.CYPRESS_TREES);
        BWGOverworldDefaultFeatures.addBWGSwampVegetation(generationSettings);
        BWGOverworldDefaultFeatures.addCattails(generationSettings);
        BWGOverworldDefaultFeatures.addLeatherFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addMudDisks(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SLIME, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FROG, 10, 2, 5);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.TROPICAL_FISH, 25, 8, 8);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_SWAMP);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(6337104).foliageColorOverride(6337104).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome cypressWetlands(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSwampDelta(generationSettings);
        BiomeDefaultFeatures.addSwampClayDisk((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSwampExtraVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_SWAMP);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.SPARSE_CYPRESS_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.MANGROVE_SWAMP_WATER_VEGETATION);
        BWGOverworldDefaultFeatures.addBWGSwampVegetation(generationSettings);
        BWGOverworldDefaultFeatures.addExtraCattails(generationSettings);
        BWGOverworldDefaultFeatures.addSparseFluorscentCattails(generationSettings);
        BWGOverworldDefaultFeatures.addShrub(generationSettings);
        BWGOverworldDefaultFeatures.addLeatherFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addMudDisks(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SLIME, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FROG, 10, 2, 5);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.TROPICAL_FISH, 25, 8, 8);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_SWAMP);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(5878398).waterFogColor(2047788).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.SWAMP).foliageColorOverride(6975545).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome lushStacks(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = OverworldBiomes.baseOceanGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.LUSH_ROUNDED_ROCK);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.WARM_OCEAN_VEGETATION);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_WARM);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.SEA_PICKLE);
        BiomeDefaultFeatures.addLushCavesVegetationFeatures((BiomeGenerationSettings.Builder)generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, BWGEntityType.MAN_O_WAR.get(), 180, 20, 50);
        BiomeDefaultFeatures.warmOceanSpawns((MobSpawnSettings.Builder)spawnSettings, (int)10, (int)4);
        float temperature = 1.0f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4445678).waterFogColor(270131).grassColorOverride(10275901).foliageColorOverride(10275901).waterFogColor(2835532).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome daciteRidges(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addGiantTaigaVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BiomeDefaultFeatures.addMossyStoneBlock((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.BOULDER);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.DACITE_RIDGE_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.HOLLY_TREES);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addIris(generationSettings);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        BWGOverworldDefaultFeatures.addWinterSucculent(generationSettings);
        BWGOverworldDefaultFeatures.addMossyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SHEEP, 12, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(9230578).waterFogColor(2835532).grassColorOverride(5011004).foliageColorOverride(0x228B22).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome daciteShore(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SHEEP, 12, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(9230578).waterFogColor(2835532).grassColorOverride(5011004).foliageColorOverride(0x228B22).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome atacamaOutback(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addDefaultOverworldGeneration(generationSettings);
        BiomeDefaultFeatures.addDesertVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDesertExtraVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDesertExtraDecoration((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addPaloVerdeTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ATACAMA_OUTBACK_VEGETATION);
        BWGOverworldDefaultFeatures.addShrub(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addSages(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.desertSpawns((MobSpawnSettings.Builder)spawnSettings);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(6200521).waterFogColor(6200521).fogColor(12815488).skyColor(12815488).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome windsweptDesert(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addDefaultOverworldGeneration(generationSettings);
        BiomeDefaultFeatures.addDesertVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.WINDSWEPT_BOULDER);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.WINDSWEPT_DESERT_VEGETATION);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.desertSpawns((MobSpawnSettings.Builder)spawnSettings);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(6200521).waterFogColor(6200521).fogColor(12815488).skyColor(12815488).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome ebonyWoods(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addHugeMushrooms(generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addForestGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.EBONY_TREES);
        BWGOverworldDefaultFeatures.addLeafPile(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addHorseWeed(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(5406551).foliageColorOverride(6589494).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome enchantedTangle(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addHugeMushrooms(generationSettings);
        BiomeDefaultFeatures.addLightBambooVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSparseJungleTrees((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addJungleGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BiomeDefaultFeatures.addSparseJungleMelons((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.ENCHANTED_TREES);
        BWGOverworldDefaultFeatures.addFlowerPatches(generationSettings);
        BWGOverworldDefaultFeatures.addBWGTropicFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addFairySlipper(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.CYAN_ROSE);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SHEEP, 10, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.PIG, 15, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.CHICKEN, 12, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.COW, 10, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ENDERMAN, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.OCELOT, 10, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.PARROT, 40, 1, 2);
        BiomeDefaultFeatures.baseJungleSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.PARROT, 40, 1, 2);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.OCELOT, 2, 1, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.PANDA, 1, 1, 2);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(10003745).foliageColorOverride(11898572).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientParticle(new AmbientParticleSettings((ParticleOptions)BWGParticles.BOREALIS_GLINT.get(), 0.0015f)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome frostedTaiga(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addTaigaGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BiomeDefaultFeatures.addRareBerryBushes((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BLUE_SPRUCE_TREES);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addIris(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        float temperature = -0.5f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome temperateGrove(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_SUNFLOWER);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.TEMPERATE_GROVE_TREES);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addSages(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.BISTORT);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ANGELICA);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        float temperature = 0.75f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(11190111).foliageColorOverride(11190111).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome jacarandaJungle(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addHugeMushrooms(generationSettings);
        BiomeDefaultFeatures.addLightBambooVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSparseJungleTrees((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldDefaultFeatures.addLeafPile(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.JACARANDA_TREES);
        BWGOverworldDefaultFeatures.addJacarandaBushes(generationSettings);
        BWGOverworldDefaultFeatures.addBWGTropicFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 5, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        float temperature = 0.95f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(10145074).foliageColorOverride(14180771).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome whiteMangroveMarshes(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSwampDelta(generationSettings);
        BiomeDefaultFeatures.addSwampClayDisk((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.OAK_TREES_SWAMP);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.FLOWER_SWAMP);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_GRASS_NORMAL);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_DEAD_BUSH);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_WATERLILY);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.BROWN_MUSHROOM_SWAMP);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.RED_MUSHROOM_SWAMP);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSwampExtraVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_SWAMP);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.MANGROVE_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.MANGROVE_SWAMP_WATER_VEGETATION);
        BWGOverworldDefaultFeatures.addCattails(generationSettings);
        BWGOverworldDefaultFeatures.addLeatherFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addMudDisks(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SLIME, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FROG, 10, 2, 5);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.TROPICAL_FISH, 25, 8, 8);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_SWAMP);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(5878398).waterFogColor(2047788).grassColorOverride(5737549).foliageColorOverride(5737549).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome mapleTaiga(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addTaigaGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.MAPLE_TAIGA_TREES);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldDefaultFeatures.addSparseAspenTreesShrubs(generationSettings);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addSages(generationSettings);
        BWGOverworldDefaultFeatures.addRose(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(6586199).foliageColorOverride(14206262).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome coconinoMeadow(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_SUNFLOWER);
        BiomeDefaultFeatures.addShatteredSavannaGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.SPARSE_MEADOW_TREES);
        BWGOverworldDefaultFeatures.addMeadowShrubs(generationSettings);
        BWGOverworldDefaultFeatures.addCloverFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addTulips(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ALPINE_BELLFLOWER);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ANGELICA);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.PINK_DAFFODIL);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(6530407).foliageColorOverride(5999709).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome deadSea(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.DRIPSTONE_ROUNDED_ROCK);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_NORMAL);
        BiomeDefaultFeatures.addDripstone((BiomeGenerationSettings.Builder)generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)true);
        float temperature = 2.0f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(9230578).waterFogColor(2835532).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome mojaveDesert(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addDefaultOverworldGeneration(generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDesertVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDesertExtraVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDesertExtraDecoration((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addBeachGrass(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.YUCCA_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.MOJAVE_DESERT_VEGETATION);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)109, (int)1, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.HUSK, 80, 4, 4);
        float temperature = 2.0f;
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(temperature).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome orchard(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.ORCHARD_TREES);
        BWGOverworldDefaultFeatures.addCloverFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.LOLLIPOP_FLOWERS);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.YELLOW_DAFFODIL);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.WHITE_ALLIUMS);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.plainsSpawns((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(10210365).foliageColorOverride(10210365).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome paleBog(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSwampDelta(generationSettings);
        BWGOverworldDefaultFeatures.addPaleGardenVegetation(generationSettings);
        BiomeDefaultFeatures.addSwampClayDisk((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addPaleEyeBlossomFlowers(generationSettings);
        BiomeDefaultFeatures.addJungleGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSwampExtraVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_SWAMP);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.SPIRIT_TREES);
        BWGOverworldDefaultFeatures.addBWGSwampVegetation(generationSettings);
        BWGOverworldDefaultFeatures.addFluorscentCattails(generationSettings);
        BWGOverworldDefaultFeatures.addCattails(generationSettings);
        BWGOverworldDefaultFeatures.addSages(generationSettings);
        BWGOverworldDefaultFeatures.addMudDisks(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.DROWNED, 85, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SPIDER, 85, 3, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BOGGED, 85, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SLIME, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FROG, 10, 2, 5);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().backgroundMusic(Musics.createGameMusic((Holder)((Holder)BWGSounds.MUSIC_BIOME_PALE_BOG.get()))).ambientParticle(new AmbientParticleSettings((ParticleOptions)BWGParticles.SPIRIT.get(), 5.0E-5f)).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_MOOD, 6000, 8, 2.0)).ambientAdditionsSound(new AmbientAdditionsSettings((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_ADDITIONS, 0.0111)).waterColor(9230578).waterFogColor(2835532).grassColorOverride(11056293).foliageColorOverride(11056293).fogColor(11056293).skyColor(11056293).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome prairie(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.PRAIRIE_SHRUBS);
        BWGOverworldDefaultFeatures.addSparseOakTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.PRAIRIE_GRASS);
        BWGOverworldDefaultFeatures.addCaliforniaPoppy(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.plainsSpawns((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.2f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(10003745).foliageColorOverride(10003745).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome rainbowBeach(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addBeachGrass(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.85f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.75f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4566514).waterFogColor(267827).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome overgrowthWoodlands(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addLeafLitterPatch((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.OVERGROWTH_WOODLANDS_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BWG_OAK_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BWG_BIRCH_TREES);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addRose(generationSettings);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        BWGOverworldDefaultFeatures.addFairySlipper(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ANGELICA);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.PINK_DAFFODIL);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.HORSEWEED);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().foliageColorOverride(7110705).grassColorOverride(7110705).waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(9358480).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.SPORE_BLOSSOM_AIR, 5.0E-4f)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome redRockValley(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addDefaultOverworldGeneration(generationSettings);
        BiomeDefaultFeatures.addWarmFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDesertVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.RED_ROCK_VALLEY_TREES);
        BWGOverworldDefaultFeatures.addPaloVerdeTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.RUGGED_BADLANDS_VEGETATION);
        BWGOverworldDefaultFeatures.addOrangeTerracottaBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addShrub(generationSettings);
        BWGOverworldDefaultFeatures.addFirecrackerBush(generationSettings);
        BWGOverworldDefaultFeatures.addHorseWeed(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ARMADILLO, 10, 2, 3);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.1f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(0xA5A56A).foliageColorOverride(0xA5A56A).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome redRockPeaks(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addDefaultOverworldGeneration(generationSettings);
        BiomeDefaultFeatures.addWarmFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDesertVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.RED_ROCK_VALLEY_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.RUGGED_BADLANDS_VEGETATION);
        BWGOverworldDefaultFeatures.addOrangeTerracottaBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addShrub(generationSettings);
        BWGOverworldDefaultFeatures.addFirecrackerBush(generationSettings);
        BWGOverworldDefaultFeatures.addHorseWeed(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ARMADILLO, 10, 2, 3);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.1f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(0xA5A56A).foliageColorOverride(0xA5A56A).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome redwoodThicket(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.BOULDER);
        BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addForestGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addLeafLitterPatch((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.SPRUCE_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.REDWOOD_TREES);
        BWGOverworldDefaultFeatures.addLeafPile(generationSettings);
        BWGOverworldDefaultFeatures.addMossyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        float temperature = 0.9f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(8896351).foliageColorOverride(8896351).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome roseFields(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addRoseFieldSpruceTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ROSE_FIELD_FLOWERS);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.plainsSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.4f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(8231780).foliageColorOverride(8231780).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome shatteredGlacier(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addTaigaGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.WINTER_ROSE);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.STRAY, 80, 4, 4);
        float temperature = -0.5f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(1.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(6200521).waterFogColor(6200521).grassColorOverride(15834405).foliageColorOverride(15834405).fogColor(12638463).skyColor(0xC1CCCC).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.01428f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome firecrackerChaparral(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDesertVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSparseOakTrees(generationSettings);
        BWGOverworldDefaultFeatures.addShrub(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.FIRECRACKER_SHRUBS);
        BWGOverworldDefaultFeatures.addFirecrackerBush(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.HORSE, 5, 2, 6);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.DONKEY, 1, 1, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        float temperature = 2.0f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.4f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(9874031).foliageColorOverride(7048739).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome sierraBadlands(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.BOULDER);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addExtraGold((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBadlandGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBadlandExtraVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldDefaultFeatures.addPaloVerdeTrees(generationSettings);
        BWGOverworldDefaultFeatures.addOrangeTerracottaBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addFirecrackerBush(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SPIDER, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.HUSK, 95, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ZOMBIE_VILLAGER, 5, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SKELETON, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.CREEPER, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SLIME, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ENDERMAN, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WITCH, 5, 1, 1);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.1f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(0xA5A56A).foliageColorOverride(0xA5A56A).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome ruggedBadlands(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDesertVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDesertExtraVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDesertExtraDecoration((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addPatchBeachGrassNoise(generationSettings);
        BWGOverworldDefaultFeatures.addPaloVerdeTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.RUGGED_BADLANDS_VEGETATION);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SPIDER, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.HUSK, 95, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ZOMBIE_VILLAGER, 5, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SKELETON, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.CREEPER, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SLIME, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ENDERMAN, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WITCH, 5, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RAVAGER, 1, 1, 2);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.1f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(0xA5A56A).foliageColorOverride(0xA5A56A).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome ironwoodGour(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaTrees((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addWarmFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.IRONWOOD_PLATEAU_PATCH_GRASS_WORLD_SURFACE);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldDefaultFeatures.addSages(generationSettings);
        BWGOverworldDefaultFeatures.addCaliforniaPoppy(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.IRONWOOD_PLATEAU_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.IRONWOOD_GROUND_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.IRONWOOD_PLATEAU_GLOW_LICHEN);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ARMADILLO, 10, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SPIDER, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.HUSK, 95, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ZOMBIE_VILLAGER, 5, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SKELETON, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.CREEPER, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SLIME, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ENDERMAN, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WITCH, 5, 1, 1);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.1f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(0xA5A56A).foliageColorOverride(0xA5A56A).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome erodedBorealis(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.BOREALIS_ICE_SHARPENED_SPIKE);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addTaigaGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BiomeDefaultFeatures.addRareBerryBushes((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BLUE_SPRUCE_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.HOLLY_TREES);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addWinterSucculent(generationSettings);
        BWGOverworldDefaultFeatures.addWinterCyclamen(generationSettings);
        BWGOverworldDefaultFeatures.addSnowdrops(generationSettings);
        BWGOverworldDefaultFeatures.addWinterScilla(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ALLAY, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 10, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 3, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.STRAY, 85, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.POLAR_BEAR, 1, 1, 2);
        float temperature = -0.5f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.3f).specialEffects(new BiomeSpecialEffects.Builder().backgroundMusic(Musics.createGameMusic((Holder)((Holder)BWGSounds.MUSIC_BIOME_ERODED_BOREALIS.get()))).waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientParticle(new AmbientParticleSettings((ParticleOptions)BWGParticles.BOREALIS_GLINT.get(), 0.002f)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome skyrisVale(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.SKYRIS_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.SPARSE_BLUE_SPRUCE_TREES);
        BWGOverworldDefaultFeatures.addMossyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.FOXGLOVES);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addFairySlipper(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SPIDER, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SKELETON, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.SLIME, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ENDERMAN, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WITCH, 5, 1, 1);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(6409356).foliageColorOverride(7135854).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome howlingPeaks(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addGiantTaigaVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.BOULDER);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.ORANGE_BIRCH_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.YELLOW_BIRCH_TREES);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addWinterCyclamen(generationSettings);
        BWGOverworldDefaultFeatures.addSnowdrops(generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 10, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.STRAY, 80, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.GOAT, 5, 1, 3);
        float temperature = -0.5f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(1.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(6200521).waterFogColor(6200521).grassColorOverride(15834405).foliageColorOverride(15834405).fogColor(12638463).skyColor(0xC1CCCC).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.01428f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome fragmentJungle(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addLightBambooVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSparseJungleTrees((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addJungleGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BiomeDefaultFeatures.addSparseJungleMelons((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.STONE_PILLAR);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGOverworldVegationPlacedFeatures.PATCH_GRASS_JUNGLE_WORLD_SURFACE);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.FRAGMENT_JUNGLE_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.RAINFOREST_TREES);
        BWGOverworldDefaultFeatures.addBWGTropicFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addProteaFlowers(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.JUNGLE_FLOWERS_PILLAR);
        BWGOverworldDefaultFeatures.addMossyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.DELPHINIUM);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.DELPHINIUM_PILLAR);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.PARROT, 40, 1, 2);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.CHICKEN, 10, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.OCELOT, 2, 1, 1);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(10145074).foliageColorOverride(10145074).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome tropicalRainforest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addHugeMushrooms(generationSettings);
        BiomeDefaultFeatures.addLightBambooVegetation((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSparseJungleTrees((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addWarmFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addJungleGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BiomeDefaultFeatures.addSparseJungleMelons((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.RAINFOREST_TREES);
        BWGOverworldDefaultFeatures.addBWGTropicFlowers(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.DELPHINIUM);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.baseJungleSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.PARROT, 40, 1, 2);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.OCELOT, 2, 1, 1);
        float temperature = 0.95f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(10145074).foliageColorOverride(10145074).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome weepingWitchForest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addHugeMushrooms(generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addForestGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addLeafLitterPatch((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldDefaultFeatures.addSparseAspenTreesShrubs(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.HAZEL_TREES);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ALLAY, 1, 1, 2);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WITCH, 6, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.CAVE_SPIDER, 50, 2, 4);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(12435265).foliageColorOverride(12435265).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome forgottenForest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addHugeMushrooms(generationSettings);
        BiomeDefaultFeatures.addJungleGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addLeafLitterPatch((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.FORGOTTEN_FOREST_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.FLORUS_TREES);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addRose(generationSettings);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        BWGOverworldDefaultFeatures.addFairySlipper(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ANGELICA);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.PINK_DAFFODIL);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.HORSEWEED);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.ALLAY, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.RABBIT, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.FOX, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.CAVE_SPIDER, 90, 2, 3);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().backgroundMusic(Musics.createGameMusic((Holder)((Holder)BWGSounds.MUSIC_BIOME_FORGOTTEN_FOREST.get()))).waterColor(4159204).waterFogColor(329011).grassColorOverride(8034667).foliageColorOverride(6530362).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientParticle(new AmbientParticleSettings((ParticleOptions)BWGParticles.FIREFLY.get(), 0.0019f)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static Biome zelkovaForest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addBushes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addTaigaGrass((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generationSettings, (boolean)true);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.ZELKOVA_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BROWN_ZELKOVA_TREES);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.KOVAN_FLOWER);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.WOLF, 5, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.BAT, 10, 8, 8);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(temperature).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).grassColorOverride(5416309).foliageColorOverride(5416309).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor((float)temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    private static void addVegetal(BiomeGenerationSettings.Builder builder, ResourceKey<PlacedFeature> feature) {
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, feature);
    }

    private static void addRawGeneration(BiomeGenerationSettings.Builder builder, ResourceKey<PlacedFeature> feature) {
        builder.addFeature(GenerationStep.Decoration.RAW_GENERATION, feature);
    }
}

