/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.sharpenedrock;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.potionstudios.biomeswevegone.util.BWGUtil;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructurePieceTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.sharpenedrock.SharpenedRockStructure;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;

public class SharpenedRockPiece
extends StructurePiece {
    private final BlockPos origin;
    private final int radius;
    private final boolean hasFoundation;
    private final boolean hasSpike;
    private final double pitch;
    private final double yaw;
    private final int[] cache;

    public SharpenedRockPiece(BlockPos origin, int radius, boolean hasFoundation, boolean hasSpike, double pitch, double yaw, int[] cache, int genDepth, BoundingBox box) {
        super(BWGStructurePieceTypes.SHARPENED_ROCK_PIECE.get(), genDepth, box);
        this.origin = origin;
        this.radius = radius;
        this.hasFoundation = hasFoundation;
        this.hasSpike = hasSpike;
        this.pitch = pitch;
        this.yaw = yaw;
        this.cache = cache;
    }

    public SharpenedRockPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(BWGStructurePieceTypes.SHARPENED_ROCK_PIECE.get(), tag);
        this.origin = BWGUtil.readBlockPos(tag, "origin").orElseThrow();
        this.radius = tag.getIntOr("radius", 0);
        this.hasFoundation = tag.getBooleanOr("foundation", false);
        this.hasSpike = tag.getBooleanOr("spike", false);
        this.pitch = tag.getDoubleOr("pitch", 0.0);
        this.yaw = tag.getDoubleOr("yaw", 0.0);
        this.cache = (int[])tag.getIntArray("height_cache").orElseThrow();
    }

    protected void addAdditionalSaveData(@NotNull StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        compoundTag.put("origin", BWGUtil.writeBlockPos(this.origin));
        compoundTag.putInt("radius", this.radius);
        compoundTag.putBoolean("foundation", this.hasFoundation);
        compoundTag.putBoolean("spike", this.hasSpike);
        compoundTag.putDouble("pitch", this.pitch);
        compoundTag.putDouble("yaw", this.yaw);
        compoundTag.putIntArray("height_cache", this.cache);
    }

    public void postProcess(WorldGenLevel worldGenLevel, @NotNull StructureManager structureManager, @NotNull ChunkGenerator chunkGenerator, @NotNull RandomSource r, @NotNull BoundingBox boundingBox, @NotNull ChunkPos chunkPos, @NotNull BlockPos blockPos) {
        RandomSource randomSource = RandomSource.create((long)(worldGenLevel.getLevel().getServer().getWorldData().worldGenOptions().seed() + this.origin.asLong()));
        WeightedStateProvider blocks = new WeightedStateProvider(WeightedList.builder().add((Object)Blocks.WHITE_TERRACOTTA.defaultBlockState(), 10).add((Object)Blocks.LIGHT_GRAY_TERRACOTTA.defaultBlockState(), 1).build());
        LongOpenHashSet placed = new LongOpenHashSet();
        Quaterniond quaternion = new Quaterniond();
        quaternion.rotateY(Math.toRadians(this.yaw));
        quaternion.rotateX(Math.toRadians(this.pitch));
        BlockState[] bandStates = new BlockState[]{Blocks.WHITE_TERRACOTTA.defaultBlockState(), Blocks.LIGHT_GRAY_TERRACOTTA.defaultBlockState(), Blocks.WHITE_TERRACOTTA.defaultBlockState(), Blocks.LIGHT_GRAY_TERRACOTTA.defaultBlockState(), Blocks.WHITE_TERRACOTTA.defaultBlockState()};
        BlockState[] bands = new BlockState[25];
        int i = 0;
        while (i < bands.length) {
            BlockState selectedState = bandStates[randomSource.nextInt(bandStates.length)];
            int fillerSize = randomSource.nextInt(1, 5);
            for (int filler = 0; filler < fillerSize && i < bands.length; ++i, ++filler) {
                bands[i] = selectedState;
            }
        }
        if (this.hasSpike) {
            SharpenedRockStructure.generateFromCache(this.radius, this.cache, this.origin, quaternion, false, (arg_0, arg_1) -> this.lambda$postProcess$0((LongSet)placed, bands, worldGenLevel, arg_0, arg_1));
        }
        if (this.hasFoundation) {
            SharpenedRockStructure.generateFromCache(this.radius, this.cache, this.origin, quaternion, true, (arg_0, arg_1) -> this.lambda$postProcess$1((LongSet)placed, bands, worldGenLevel, arg_0, arg_1));
        }
    }

    private /* synthetic */ boolean lambda$postProcess$1(LongSet placed, BlockState[] bands, WorldGenLevel worldGenLevel, BlockPos rotatedPos, BlockPos unRotatedPos) {
        if (this.boundingBox.isInside((Vec3i)rotatedPos) && placed.add(rotatedPos.asLong())) {
            BlockState state = bands[unRotatedPos.getY() % (bands.length - 1)];
            worldGenLevel.setBlock(rotatedPos, state, 2);
            return true;
        }
        return true;
    }

    private /* synthetic */ boolean lambda$postProcess$0(LongSet placed, BlockState[] bands, WorldGenLevel worldGenLevel, BlockPos rotatedPos, BlockPos unRotatedPos) {
        if (this.boundingBox.isInside((Vec3i)rotatedPos) && placed.add(rotatedPos.asLong())) {
            BlockState state = bands[unRotatedPos.getY() % (bands.length - 1)];
            worldGenLevel.setBlock(rotatedPos, state, 2);
        }
        return true;
    }
}

