/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.tree.leaves;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.fruit.BWGFruitBlock;
import org.jetbrains.annotations.NotNull;

public class BWGFruitLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    private final Supplier<BWGFruitBlock> fruitBlock;
    private final float tickSpawnChance;

    public BWGFruitLeavesBlock(BlockBehaviour.Properties properties, Supplier<BWGFruitBlock> fruitBlock, float tickSpawnChance) {
        super(properties);
        this.fruitBlock = fruitBlock;
        this.tickSpawnChance = tickSpawnChance;
    }

    protected boolean isRandomlyTicking(@NotNull BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.randomTick(state, level, pos, random);
        BlockPos fruitPos = pos.below();
        if (this.decaying(state)) {
            BlockState below = level.getBlockState(fruitPos);
            if (below.is((Block)this.fruitBlock.get())) {
                level.destroyBlock(fruitPos, (Integer)below.getValue((Property)BWGFruitBlock.AGE) == 3 || random.nextBoolean());
            }
        } else if (level.getBlockState(fruitPos).isAir() && random.nextFloat() <= this.tickSpawnChance) {
            this.placeFruit((Level)level, fruitPos);
        }
    }

    private void placeFruit(@NotNull Level level, @NotNull BlockPos pos) {
        level.setBlock(pos, (BlockState)this.fruitBlock.get().defaultBlockState().setValue((Property)BWGFruitBlock.AGE, (Comparable)Integer.valueOf(0)), 2);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (player.isCreative() && !level.isClientSide() && stack.getItem().getDefaultInstance().is(this.fruitBlock.get().getFruit()) && level.getBlockState(pos.below()).isAir()) {
            this.placeFruit(level, pos.below());
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) == false && level.getBlockState(pos.below()).isAir();
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return random.nextBoolean();
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, BlockPos pos, @NotNull BlockState state) {
        this.placeFruit((Level)level, pos.below());
    }
}

