/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_10401;
import net.minecraft.class_1163;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_2230;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2362;
import net.minecraft.class_2373;
import net.minecraft.class_2397;
import net.minecraft.class_2400;
import net.minecraft.class_2504;
import net.minecraft.class_2513;
import net.minecraft.class_2533;
import net.minecraft.class_2541;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_3749;
import net.minecraft.class_3756;
import net.minecraft.class_4002;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5614;
import net.minecraft.class_5617;
import net.minecraft.class_5809;
import net.minecraft.class_5819;
import net.minecraft.class_6677;
import net.minecraft.class_707;
import net.minecraft.class_7116;
import net.minecraft.class_7761;
import net.minecraft.class_837;
import net.minecraft.class_881;
import net.minecraft.class_9848;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.client.color.item.BorealisIceColorSource;
import net.potionstudios.biomeswevegone.client.color.item.FoliageColorSource;
import net.potionstudios.biomeswevegone.client.particle.BWGParticles;
import net.potionstudios.biomeswevegone.client.particle.particles.FallingLeafParticle;
import net.potionstudios.biomeswevegone.client.particle.particles.FireFlyParticle;
import net.potionstudios.biomeswevegone.client.renderer.entity.manowar.ManOWarRenderer;
import net.potionstudios.biomeswevegone.client.renderer.entity.oddion.OddionRenderer;
import net.potionstudios.biomeswevegone.client.renderer.entity.pumpkinwarden.PumpkinWardenRenderer;
import net.potionstudios.biomeswevegone.client.renderer.entity.wreath.WreathRenderer;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.entity.decoration.Wreath;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.custom.BWGSpreadableBlock;
import net.potionstudios.biomeswevegone.world.level.block.entities.BWGBlockEntityType;
import net.potionstudios.biomeswevegone.world.level.block.plants.cactus.BWGCactusBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.fruit.BWGFruitBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.GlowCaneBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.cattail.CattailSproutBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWoodSet;
import org.jetbrains.annotations.Nullable;

public class BiomesWeveGoneClient {
    private static final class_3756 NOISE = new class_3756((class_5819)new class_6677(1L));

    public static void onInitialize() {
        BWGWoodSet.woodsets().forEach(set -> BiomesWeveGoneClient.registerWoodTypes(set.woodType()));
    }

    private static void registerWoodTypes(class_4719 woodType) {
        class_4722.field_21712.put(woodType, class_4722.method_24064((class_4719)woodType));
        class_4722.field_40515.put(woodType, class_4722.method_45782((class_4719)woodType));
    }

    public static void registerEntityRenderers(BiConsumer<class_1299<? extends class_1297>, class_5617> consumer) {
        consumer.accept(BWGEntityType.MAN_O_WAR.get(), ManOWarRenderer::new);
        consumer.accept(BWGEntityType.PUMPKIN_WARDEN.get(), PumpkinWardenRenderer::new);
        consumer.accept(BWGEntityType.ODDION.get(), OddionRenderer::new);
        consumer.accept(BWGEntityType.WREATH.get(), WreathRenderer::new);
        BWGWoodSet.woodsets().forEach(set -> {
            consumer.accept(set.boat().get(), context -> new class_881(context, set.boatModelLayer()));
            consumer.accept(set.chestBoat().get(), context -> new class_881(context, set.chestBoatModelLayer()));
        });
    }

    public static void registerBlockEntityRenderers(BiConsumer<class_2591<? extends class_2586>, class_5614> consumer) {
        consumer.accept(BWGBlockEntityType.SIGNS.get(), class_837::new);
        consumer.accept(BWGBlockEntityType.HANGING_SIGNS.get(), class_7761::new);
    }

    public static void registerLayerDefinitions(BiConsumer<class_5601, Supplier<class_5607>> consumer) {
        BWGWoodSet.woodsets().forEach(set -> {
            consumer.accept(set.boatModelLayer(), class_554::method_31985);
            consumer.accept(set.chestBoatModelLayer(), class_554::method_62066);
        });
    }

    public static void registerAdditionalModels(Consumer<String> consumer) {
        Arrays.stream(Wreath.Type.values()).forEach(type -> consumer.accept(type.method_15434() + "_wreath"));
    }

    public static void registerParticles(BiConsumer<class_2400, Function<class_4002, class_707<class_2400>>> consumer) {
        consumer.accept(BWGParticles.FIREFLY.get(), FireFlyParticle.Provider::new);
        consumer.accept(BWGParticles.BOREALIS_GLINT.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.WITCH_HAZEL_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.WHITE_SAKURA_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.YELLOW_SAKURA_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.RED_MAPLE_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.SILVER_MAPLE_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.IRONWOOD_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.SPIRIT.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.SPIRIT_LEAVES.get(), FallingLeafParticle.Provider::new);
    }

    public static void registerBlockRenderTypes(BiConsumer<class_2248, class_1921> consumer) {
        BWGWood.WOOD.forEach((Consumer<Supplier<? extends class_2248>>)((Consumer<Supplier>)entry -> {
            class_1921 type = BiomesWeveGoneClient.renderTypeBlock((class_2248)entry.get());
            if (type != null) {
                consumer.accept((class_2248)entry.get(), type);
            }
        }));
        BWGBlocks.BLOCKS.forEach((Consumer<Supplier<? extends class_2248>>)((Consumer<Supplier>)entry -> {
            class_1921 type = BiomesWeveGoneClient.renderTypeBlock((class_2248)entry.get());
            if (type != null) {
                consumer.accept((class_2248)entry.get(), type);
            }
        }));
        consumer.accept((class_2248)BWGWood.MAPLE.door(), class_1921.method_23583());
        consumer.accept((class_2248)BWGWood.MAPLE.trapdoor(), class_1921.method_23583());
    }

    @Nullable
    private static class_1921 renderTypeBlock(class_2248 block) {
        if (block instanceof BWGFruitBlock || block instanceof class_2323 || block instanceof class_2533 || block instanceof class_2261 || block instanceof GlowCaneBlock || block instanceof class_3749) {
            return class_1921.method_23581();
        }
        if (block instanceof class_2397 || block instanceof class_2541 || block instanceof class_7116 || block instanceof class_2362 || block instanceof BWGCactusBlock || block instanceof CattailSproutBlock || block instanceof BWGSpreadableBlock || block instanceof class_5809 || block instanceof class_2230) {
            return class_1921.method_23579();
        }
        if (block instanceof class_2504 || block instanceof class_2373) {
            return class_1921.method_23583();
        }
        return null;
    }

    public static void registerBlockColors(BiConsumer<class_322, class_2248[]> consumer) {
        consumer.accept((state, view, pos, tintIndex) -> view != null && pos != null ? class_1163.method_4962((class_1920)view, (class_2338)pos) : class_1933.method_49724(), new class_2248[]{(class_2248)BWGBlocks.FLOWER_PATCH.get(), (class_2248)BWGBlocks.TINY_LILY_PADS.get(), (class_2248)BWGBlocks.FLOWERING_TINY_LILY_PADS.get(), (class_2248)BWGBlocks.OVERGROWN_DACITE.get(), (class_2248)BWGBlocks.WHITE_OVERGROWN_DACITE.get(), (class_2248)BWGBlocks.OVERGROWN_STONE.get(), (class_2248)BWGBlocks.LUSH_GRASS_BLOCK.get(), (class_2248)BWGBlocks.WHITE_SAKURA_PETALS.get(), (class_2248)BWGBlocks.YELLOW_SAKURA_PETALS.get()});
        consumer.accept((state, view, pos, tintIndex) -> view != null && pos != null ? class_1163.method_4966((class_1920)view, (class_2338)pos) : class_1926.method_8344((double)0.5, (double)1.0), new class_2248[]{(class_2248)BWGBlocks.CLOVER_PATCH.get(), (class_2248)BWGBlocks.LEAF_PILE.get(), (class_2248)BWGBlocks.POISON_IVY.get(), BWGWood.MAHOGANY.leaves(), BWGWood.WILLOW.leaves(), BWGWood.MAPLE.leaves(), (class_2248)BWGWood.YUCCA_LEAVES.get(), (class_2248)BWGWood.FLOWERING_YUCCA_LEAVES.get(), (class_2248)BWGWood.RIPE_YUCCA_LEAVES.get(), BWGWood.CYPRESS.leaves()});
        consumer.accept((state, view, pos, tintIndex) -> BiomesWeveGoneClient.getBorealisIceColor(Objects.requireNonNullElse(pos, class_2338.field_10980)), new class_2248[]{(class_2248)BWGBlocks.BOREALIS_ICE.get(), (class_2248)BWGBlocks.PACKED_BOREALIS_ICE.get()});
        consumer.accept((state, view, pos, tintIndex) -> view != null && pos != null ? class_1163.method_4961((class_1920)view, (class_2338)pos) : -1, new class_2248[]{BWGBlocks.CARVED_BARREL_CACTUS.get()});
        consumer.accept((state, view, pos, tintIndex) -> {
            int age = (Integer)state.method_11654((class_2769)class_2513.field_11584);
            return class_9848.method_61323((int)(age * 32), (int)(255 - age), (int)(age * 4));
        }, new class_2248[]{(class_2248)BWGBlocks.PALE_PUMPKIN_STEM.get()});
        consumer.accept((state, view, pos, tintIndex) -> -2046180, new class_2248[]{(class_2248)BWGBlocks.ATTACHED_PALE_PUMPKIN_STEM.get()});
    }

    public static int getBorealisIceColor(class_2338 pos) {
        float factor = (float)((NOISE.method_33658((double)((float)pos.method_10263() * 0.01f), (double)((float)pos.method_10264() * 0.01f), (double)((float)pos.method_10260() * 0.01f)) + 1.0) * 0.5);
        float hue = 320.0f - 200.0f * factor;
        return BiomesWeveGoneClient.HSBtoRGB(hue / 360.0f, 0.6f, 1.0f);
    }

    private static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public static void registerItemTintSources(BiConsumer<class_2960, MapCodec<? extends class_10401>> consumer) {
        consumer.accept(BiomesWeveGone.id("borealis_ice"), BorealisIceColorSource.MAP_CODEC);
        consumer.accept(BiomesWeveGone.id("foliage"), FoliageColorSource.MAP_CODEC);
    }
}

