/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature.configured;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.PlacedFeaturesUtil;

public class ConfiguredFeaturesUtil {
    public static final Map<ResourceKey<ConfiguredFeature<?, ?>>, ConfiguredFeatureFactory> CONFIGURED_FEATURES_FACTORIES = new Reference2ObjectOpenHashMap();

    @SafeVarargs
    public static RandomFeatureConfiguration createRandomWeightedConfiguredFeature(HolderGetter<ConfiguredFeature<?, ?>> lookup, ResourceKey<ConfiguredFeature<?, ?>> ... configuredFeatures) {
        int count = configuredFeatures.length;
        float weight = 1.0f / (float)count;
        ArrayList<WeightedPlacedFeature> wightedPlacedFeatureList = new ArrayList<WeightedPlacedFeature>();
        for (int i = 0; i < count - 1; ++i) {
            wightedPlacedFeatureList.add(new WeightedPlacedFeature(PlacedFeaturesUtil.createPlacedFeatureDirect(lookup.getOrThrow(configuredFeatures[i]), new PlacementModifier[0]), weight));
        }
        return new RandomFeatureConfiguration(wightedPlacedFeatureList, PlacedFeaturesUtil.createPlacedFeatureDirect(lookup.getOrThrow(configuredFeatures[count - 1]), new PlacementModifier[0]));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> ResourceKey<ConfiguredFeature<?, ?>> createConfiguredFeature(String id, F feature, Function<BootstrapContext<ConfiguredFeature<?, ?>>, ? extends FC> config) {
        ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureResourceKey = ConfiguredFeaturesUtil.registerKey(id);
        CONFIGURED_FEATURES_FACTORIES.put(configuredFeatureResourceKey, configuredFeatureHolderGetter -> new ConfiguredFeature(feature, (FeatureConfiguration)config.apply(configuredFeatureHolderGetter)));
        return configuredFeatureResourceKey;
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> ResourceKey<ConfiguredFeature<?, ?>> createConfiguredFeature(String id, Supplier<? extends F> feature, Supplier<? extends FC> config) {
        ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureResourceKey = ConfiguredFeaturesUtil.registerKey(id);
        CONFIGURED_FEATURES_FACTORIES.put(configuredFeatureResourceKey, configuredFeatureHolderGetter -> new ConfiguredFeature((Feature)feature.get(), (FeatureConfiguration)config.get()));
        return configuredFeatureResourceKey;
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> ResourceKey<ConfiguredFeature<?, ?>> createConfiguredFeature(String id, F feature, Supplier<? extends FC> config) {
        ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureResourceKey = ConfiguredFeaturesUtil.registerKey(id);
        CONFIGURED_FEATURES_FACTORIES.put(configuredFeatureResourceKey, configuredFeatureHolderGetter -> new ConfiguredFeature(feature, (FeatureConfiguration)config.get()));
        return configuredFeatureResourceKey;
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<?, ?>> createConfiguredFeature(F feature, Supplier<? extends FC> config) {
        return Holder.direct((Object)new ConfiguredFeature(feature, (FeatureConfiguration)config.get()));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<?, ?>> createConfiguredFeature(F feature, FC config) {
        return Holder.direct((Object)new ConfiguredFeature(feature, config));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<?, ?>> createConfiguredFeature(Supplier<F> feature, Supplier<FC> config) {
        return Holder.direct((Object)new ConfiguredFeature((Feature)feature.get(), (FeatureConfiguration)config.get()));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> ResourceKey<ConfiguredFeature<?, ?>> createFlowerConfiguredFeature(String id, Supplier<? extends Block> flowerBlock) {
        return ConfiguredFeaturesUtil.createConfiguredFeature(id, Feature.FLOWER, (BootstrapContext<ConfiguredFeature<?, ?>> configuredFeatureBootstrapContext) -> VegetationFeatures.grassPatch((BlockStateProvider)SimpleStateProvider.simple((BlockState)((Block)flowerBlock.get()).defaultBlockState()), (int)15));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> ResourceKey<ConfiguredFeature<?, ?>> createPatchConfiguredFeatureWithBlock(String id, Supplier<? extends Block> block, int tries) {
        return ConfiguredFeaturesUtil.createPatchConfiguredFeatureWithState(id, () -> ((Block)block.get()).defaultBlockState(), tries);
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createPatchConfiguredFeatureWithState(String id, Supplier<BlockState> state, int tries) {
        return ConfiguredFeaturesUtil.createConfiguredFeature(id, Feature.RANDOM_PATCH, (BootstrapContext<ConfiguredFeature<?, ?>> configuredFeatureBootstrapContext) -> FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)state.get()))), List.of(), (int)tries));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<?, ?>> createPatchConfiguredFeatureWithState(Block block, int tries) {
        return Holder.direct((Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)block)), List.of(), (int)tries)));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createSimpleBlockConfiguredFeatureWithBlock(String id, Supplier<Block> block) {
        return ConfiguredFeaturesUtil.createSimpleBlockConfiguredFeatureWithState(id, () -> ((Block)block.get()).defaultBlockState());
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createSimpleBlockConfiguredFeatureWithState(String id, Supplier<BlockState> state) {
        return ConfiguredFeaturesUtil.createConfiguredFeature(id, Feature.SIMPLE_BLOCK, (BootstrapContext<ConfiguredFeature<?, ?>> configuredFeatureBootstrapContext) -> new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)state.get()))));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return BiomesWeveGone.key(Registries.CONFIGURED_FEATURE, name);
    }

    @FunctionalInterface
    public static interface ConfiguredFeatureFactory {
        public ConfiguredFeature<?, ?> generate(BootstrapContext<ConfiguredFeature<?, ?>> var1);
    }
}

