/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.pumpkinwarden;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1409;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7477;
import net.minecraft.class_7988;
import net.minecraft.class_7995;
import net.minecraft.class_8111;
import net.minecraft.server.MinecraftServer;
import net.potionstudios.biomeswevegone.tags.BWGItemTags;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.entity.ai.behavior.PumpkinWardenGoalPackages;
import net.potionstudios.biomeswevegone.world.entity.ai.memory.BWGMemoryModuleType;
import net.potionstudios.biomeswevegone.world.entity.ai.sensing.BWGSensorType;
import net.potionstudios.biomeswevegone.world.entity.ai.village.poi.BWGPoiTypes;
import net.potionstudios.biomeswevegone.world.entity.schedule.BWGSchedule;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.entities.PumpkinBurrowBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PumpkinWarden
extends class_1314
implements GeoEntity,
class_7988<Variant> {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private class_2338 jukebox;
    private boolean party;
    private static final class_2940<Boolean> HIDING = class_2945.method_12791(PumpkinWarden.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_VARIANT = class_2945.method_12791(PumpkinWarden.class, (class_2941)class_2943.field_13327);
    private static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18438, (Object)class_4140.field_18440, (Object)class_4140.field_18441, (Object)class_4140.field_18442, BWGMemoryModuleType.VISIBLE_PUMPKIN_WARDENS.get(), (Object)class_4140.field_19006, (Object)class_4140.field_22332, (Object)class_4140.field_38397, (Object)class_4140.field_18445, (Object)class_4140.field_18446, (Object)class_4140.field_18447, (Object)class_4140.field_18449, (Object[])new class_4140[]{class_4140.field_26389, class_4140.field_18451, class_4140.field_18452, class_4140.field_18453, class_4140.field_19009, class_4140.field_19293, BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get()});
    private static final ImmutableList<class_4149<? extends class_4148<? super PumpkinWarden>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_22358, (Object)class_4149.field_18470, BWGSensorType.NEAREST_PUMPKIN_WARDENS.get(), (Object)class_4149.field_19011, (Object)class_4149.field_18469);
    public static final Map<class_4140<class_4208>, BiPredicate<PumpkinWarden, class_6880<class_4158>>> POI_MEMORIES = ImmutableMap.of((Object)class_4140.field_18438, (pumpkinWarden, holder) -> holder.method_40225(BWGPoiTypes.PUMPKIN_BURROW), (Object)class_4140.field_18440, (pumpkinWarden, holder) -> holder.method_40225(class_7477.field_39292));
    private static final RawAnimation HIDE_START = RawAnimation.begin().then("animation.pumpkinwarden.hidestart", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation HIDE = RawAnimation.begin().thenLoop("animation.pumpkinwarden.hide");
    private static final RawAnimation HIDE_END = RawAnimation.begin().then("animation.pumpkinwarden.hideend", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation HOLDING_WALKING = RawAnimation.begin().thenPlay("animation.pumpkinwarden.holding_walking");
    private static final RawAnimation HOLDING_IDLE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.holding_idle");
    private static final RawAnimation WALKING = RawAnimation.begin().thenPlay("animation.pumpkinwarden.walking");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.idle");
    private static final RawAnimation WAVE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.wave");

    public PumpkinWarden(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5941(class_7.field_9, 16.0f);
        this.method_5941(class_7.field_3, -1.0f);
        ((class_1409)this.method_5942()).method_6363(true);
        this.method_5942().method_6354(true);
    }

    @NotNull
    public class_4095<PumpkinWarden> method_18868() {
        return super.method_18868();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_4095.class_5303<?> method_28306() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    protected class_4095<?> method_18867(@NotNull Dynamic<?> dynamic) {
        class_4095 brain = super.method_18867(dynamic);
        this.registerBrainGoals((class_4095<PumpkinWarden>)brain);
        return brain;
    }

    private void refreshBrain(class_3218 serverLevel) {
        class_4095<PumpkinWarden> brain = this.method_18868();
        brain.method_18900(serverLevel, (class_1309)this);
        this.field_18321 = brain.method_18911();
        this.registerBrainGoals(this.method_18868());
    }

    private void registerBrainGoals(class_4095<PumpkinWarden> brain) {
        brain.method_18884(BWGSchedule.PUMPKIN_WARDEN.get());
        brain.method_18881(class_4168.field_18594, PumpkinWardenGoalPackages.getCorePackage());
        brain.method_18881(class_4168.field_18885, PumpkinWardenGoalPackages.getPlayPackage());
        brain.method_18881(class_4168.field_18595, PumpkinWardenGoalPackages.getIdlePackage());
        brain.method_18881(class_4168.field_18596, PumpkinWardenGoalPackages.getWorkPackage());
        brain.method_18881(class_4168.field_18597, PumpkinWardenGoalPackages.getRestPackage());
        brain.method_18881(class_4168.field_18599, PumpkinWardenGoalPackages.getPanicPackage());
        brain.method_18881(class_4168.field_19043, PumpkinWardenGoalPackages.getHidePackage());
        brain.method_24529(class_4168.field_18598, PumpkinWardenGoalPackages.getMeetPackage(), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_18440, (Object)class_4141.field_18456)));
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18885);
        if (this.isHiding()) {
            brain.method_24526(class_4168.field_19043);
        } else {
            brain.method_24526(class_4168.field_18885);
        }
        brain.method_18871(this.method_37908().method_8532(), this.method_37908().method_8510());
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HIDING, (Object)false);
        builder.method_56912(DATA_VARIANT, (Object)0);
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Variant", this.getVariant().getId());
        compound.method_10556("Hiding", this.isHiding());
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.setVariant(Variant.byId(compound.method_10550("Variant")));
        this.setHiding(compound.method_10577("Hiding"));
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.refreshBrain(serverLevel);
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.4).method_26868(class_5134.field_23717, 48.0);
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    public void method_5982() {
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (this.isHiding()) {
            return class_1269.field_5814;
        }
        class_1799 itemInHand = player.method_5998(hand);
        if (itemInHand.method_31574(BWGBlocks.ROSE.getBlock().method_8389())) {
            if (player.method_37908().method_8608()) {
                this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 1.0, 1.0, 1.0);
                this.method_37908().method_8396(player, player.method_24515(), class_3417.field_15175, class_3419.field_15254, 1.0f, this.method_6017());
            }
            itemInHand.method_7934(1);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate).triggerableAnim("hide_start", HIDE_START).triggerableAnim("hide_end", HIDE_END));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private <E extends GeoAnimatable> PlayState predicate(@NotNull AnimationState<E> event) {
        event.getController().transitionLength(0);
        if (this.isHiding()) {
            if (event.getController().hasAnimationFinished()) {
                return event.setAndContinue(HIDE);
            }
            return PlayState.CONTINUE;
        }
        if (!this.method_5998(class_1268.field_5808).method_7960()) {
            if (event.isMoving()) {
                return event.setAndContinue(HOLDING_WALKING);
            }
            return event.setAndContinue(HOLDING_IDLE);
        }
        if (event.isMoving()) {
            return event.setAndContinue(WALKING);
        }
        if (this.party) {
            return event.setAndContinue(WAVE);
        }
        return event.setAndContinue(IDLE);
    }

    public void method_6006(@NotNull class_2338 blockPos, boolean partying) {
        this.jukebox = blockPos;
        this.party = partying;
    }

    public void method_6007() {
        if (this.jukebox == null || !this.jukebox.method_19769((class_2374)this.method_19538(), 10.0) || !this.method_37908().method_8320(this.jukebox).method_27852(class_2246.field_10223)) {
            this.party = false;
            this.jukebox = null;
        }
        super.method_6007();
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("pumpkinwardenBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    protected void method_20417() {
        this.field_6201.method_6276(class_1352.class_4134.field_18405, this.canMove());
        this.field_6201.method_6276(class_1352.class_4134.field_18407, this.canMove());
        this.field_6201.method_6276(class_1352.class_4134.field_18406, !this.isHiding());
        this.field_6201.method_6276(class_1352.class_4134.field_18408, !this.isHiding());
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        this.setVariant(Variant.getSpawnVariant(level.method_8409()));
        return super.method_5943(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean method_5939(@NotNull class_1799 stack) {
        return this.method_5998(class_1268.field_5808).method_7960() && stack.method_31573(BWGItemTags.PUMPKIN_WARDEN_PICKS_UP);
    }

    public boolean method_5936() {
        return this.method_5998(class_1268.field_5808).method_7960() && !this.isHiding();
    }

    public boolean method_18397(@NotNull class_1799 stack) {
        return stack.method_31573(BWGItemTags.PUMPKIN_WARDEN_PICKS_UP) && this.method_5936();
    }

    protected void method_5949(@NotNull class_1542 itemEntity) {
        class_1799 itemStack = itemEntity.method_6983();
        this.method_6122(class_1268.field_5808, itemStack.method_7972());
        this.method_29499(itemEntity);
        this.method_6103((class_1297)itemEntity, itemStack.method_7947());
        itemStack.method_7934(itemStack.method_7947());
        if (itemStack.method_7960()) {
            itemEntity.method_31472();
        }
    }

    public boolean method_5931() {
        return true;
    }

    @Nullable
    protected class_3414 method_5994() {
        return class_3417.field_15175;
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return class_3417.field_15139;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15225;
    }

    public float method_6017() {
        return (this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.2f + 1.5f;
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        if (this.isHiding() && source.method_49708(class_8111.field_42323)) {
            amount /= 2.0f;
        }
        return super.method_5643(source, amount);
    }

    protected float method_6031(float yRot, float animStep) {
        if (this.isHiding()) {
            return 0.0f;
        }
        return super.method_6031(yRot, animStep);
    }

    public void method_6091(@NotNull class_243 travelVector) {
        if (!this.canMove()) {
            travelVector = class_243.field_1353;
        }
        super.method_6091(travelVector);
    }

    public boolean canMove() {
        return !this.isHiding() && !this.party;
    }

    public boolean isHiding() {
        return (Boolean)this.field_6011.method_12789(HIDING);
    }

    public void hide() {
        if (!this.isHiding()) {
            this.triggerAnim("controller", "hide_start");
            this.setHiding(true);
        }
    }

    public void unhide() {
        if (this.isHiding()) {
            this.triggerAnim("controller", "hide_end");
            this.setHiding(false);
        }
    }

    private void setHiding(boolean flag) {
        this.field_6011.method_12778(HIDING, (Object)flag);
    }

    public void setVariant(@NotNull Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT, (Object)variant.getId());
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT));
    }

    @NotNull
    public class_4048 method_18377(@NotNull class_4050 pose) {
        if (this.isHiding()) {
            return this.method_5864().method_18386().method_19539(1.0f, 0.5f);
        }
        return super.method_18377(pose);
    }

    public void method_5674(@NotNull class_2940<?> dataAccessor) {
        super.method_5674(dataAccessor);
        if (HIDING.equals(dataAccessor)) {
            this.method_18382();
        }
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public void method_6078(@NotNull class_1282 damageSource) {
        this.releaseAllPois();
        super.method_6078(damageSource);
    }

    public boolean method_33190() {
        return !this.isHiding() && super.method_33190();
    }

    public void method_18403(@NotNull class_2338 pos) {
        PumpkinBurrowBlockEntity pumpkinBurrow;
        class_2586 class_25862;
        if (this.method_5765()) {
            this.method_5848();
        }
        if ((class_25862 = this.method_37908().method_8321(pos)) instanceof PumpkinBurrowBlockEntity && (pumpkinBurrow = (PumpkinBurrowBlockEntity)class_25862).isEmpty()) {
            pumpkinBurrow.addOccupant((class_1309)this);
            this.method_18402(pos);
        }
    }

    public void method_18400() {
        this.method_18380(class_4050.field_18076);
        this.method_18399();
    }

    public void method_5711(byte id) {
        super.method_5711(id);
        if (id == 13) {
            this.addParticlesAroundSelf((class_2394)class_2398.field_11231);
        } else if (id == 14) {
            this.addParticlesAroundSelf((class_2394)class_2398.field_11211);
        }
    }

    protected void addParticlesAroundSelf(class_2394 particleOption) {
        for (int i = 0; i < 5; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406(particleOption, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
        }
    }

    private void releaseAllPois() {
        this.releasePoi((class_4140<class_4208>)class_4140.field_18438);
        this.releasePoi((class_4140<class_4208>)class_4140.field_18440);
    }

    public void releasePoi(class_4140<class_4208> moduleType) {
        if (this.method_37908() instanceof class_3218) {
            MinecraftServer minecraftServer = ((class_3218)this.method_37908()).method_8503();
            this.field_18321.method_18904(moduleType).ifPresent(globalPos -> {
                class_3218 serverLevel = minecraftServer.method_3847(globalPos.comp_2207());
                if (serverLevel != null) {
                    class_4153 poiManager = serverLevel.method_19494();
                    Optional optional = poiManager.method_19132(globalPos.comp_2208());
                    BiPredicate<PumpkinWarden, class_6880<class_4158>> biPredicate = POI_MEMORIES.get(moduleType);
                    if (optional.isPresent() && biPredicate.test(this, (class_6880<class_4158>)((class_6880)optional.get()))) {
                        poiManager.method_19129(globalPos.comp_2208());
                        class_4209.method_19778((class_3218)serverLevel, (class_2338)globalPos.comp_2208());
                    }
                }
            });
        }
    }

    public static boolean villagerToPumpkinWarden(class_1297 entity, class_1799 stack, class_1937 level) {
        class_1646 villager;
        if (entity instanceof class_1646 && (villager = (class_1646)entity).method_6109() && villager.method_6059(class_1294.field_5911) && stack.method_31573(BWGItemTags.CARVED_PUMPKINS) && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            PumpkinWarden warden = (PumpkinWarden)BWGEntityType.PUMPKIN_WARDEN.get().method_5883((class_1937)serverLevel);
            warden.method_33574(villager.method_19538());
            if (stack.method_31574(BWGBlocks.CARVED_PALE_PUMPKIN.get().method_8389())) {
                warden.setVariant(Variant.PALE);
            }
            serverLevel.method_8649((class_1297)warden);
            serverLevel.method_8396(null, villager.method_24515(), class_3417.field_14905, class_3419.field_15254, 1.0f, 1.0f);
            villager.method_5650(class_1297.class_5529.field_26999);
            stack.method_7934(1);
            return true;
        }
        return false;
    }

    public static enum Variant implements class_3542
    {
        DEFAULT(0, "default"),
        PALE(1, "pale"),
        CHEERY(2, "cheery"),
        FROWNY(3, "frowny"),
        SILLY(4, "silly");

        private static final IntFunction<Variant> BY_ID;
        public static final Codec<Variant> CODEC;
        private final String name;
        private final int id;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private static Variant getSpawnVariant(@NotNull class_5819 random) {
            int i = random.method_43048(100);
            if (i < 25) {
                return DEFAULT;
            }
            if (i < 50) {
                return CHEERY;
            }
            if (i < 75) {
                return SILLY;
            }
            if (i < 95) {
                return FROWNY;
            }
            return PALE;
        }

        static {
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            CODEC = class_3542.method_28140(Variant::values);
        }
    }
}

