/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.world.level.levelgen.CheckedBlockPlacement;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch.ArchStructure;

public record ArchConfig(IntProvider length, IntProvider height, CheckedBlockPlacement checkedBlockPlacement, ArchGeneratorConfig archGeneratorConfig) {
    public static final Codec<ArchConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.POSITIVE_CODEC.fieldOf("length").forGetter(ArchConfig::length), (App)IntProvider.POSITIVE_CODEC.fieldOf("height").forGetter(ArchConfig::height), (App)CheckedBlockPlacement.CODEC.fieldOf("block_placement").forGetter(ArchConfig::checkedBlockPlacement), (App)ArchGeneratorConfig.CODEC.fieldOf("arch_generator").forGetter(ArchConfig::archGeneratorConfig)).apply((Applicative)instance, ArchConfig::new));

    public record ArchGeneratorConfig(int xzStepDistance, int xyzStepDistance, WeightedList<GenerationConfig> generationConfigs, WeightedList<BlendingFunction> blendFunction) {
        public static final Codec<ArchGeneratorConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("xz_step_distance").forGetter(ArchGeneratorConfig::xzStepDistance), (App)Codec.INT.fieldOf("xyz_step_distance").forGetter(ArchGeneratorConfig::xyzStepDistance), (App)WeightedList.codec(GenerationConfig.CODEC).fieldOf("generation_configs").forGetter(ArchGeneratorConfig::generationConfigs), (App)WeightedList.codec((Codec)BlendingFunction.CODEC).fieldOf("blending_function_picker").forGetter(ArchGeneratorConfig::blendFunction)).apply((Applicative)instance, ArchGeneratorConfig::new));

        public void generate(long seed, int height, Vec3 start, Vec3 origin, Vec3 end, BoundingBox box, Consumer<BlockPos> action) {
            XoroshiroRandomSource xoroshiroRandomSource = new XoroshiroRandomSource(seed);
            ArchStructure.between(origin, start, this.xzStepDistance, height, this.xyzStepDistance, (BlendingFunction)this.blendFunction.getRandomOrThrow((RandomSource)xoroshiroRandomSource), stepOrigin -> ((GenerationConfig)this.generationConfigs.getRandomOrThrow((RandomSource)xoroshiroRandomSource)).generate(seed, (BlockPos)stepOrigin, box, action));
            ArchStructure.between(origin, end, this.xzStepDistance, height, this.xyzStepDistance, (BlendingFunction)this.blendFunction.getRandomOrThrow((RandomSource)xoroshiroRandomSource), stepOrigin -> ((GenerationConfig)this.generationConfigs.getRandomOrThrow((RandomSource)xoroshiroRandomSource)).generate(seed, (BlockPos)stepOrigin, box, action));
        }
    }

    public record GenerationConfig(IntProvider thickness, FloatProvider noiseFreq) {
        public static final Codec<GenerationConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.POSITIVE_CODEC.fieldOf("thickness").forGetter(GenerationConfig::thickness), (App)FloatProvider.CODEC.fieldOf("noise_frequency").forGetter(GenerationConfig::noiseFreq)).apply((Applicative)instance, GenerationConfig::new));

        public void generate(long seed, BlockPos stepOrigin, BoundingBox box, Consumer<BlockPos> action) {
            XoroshiroRandomSource randomSource = new XoroshiroRandomSource(seed + stepOrigin.asLong());
            ArchStructure.generate(seed, this.thickness.sample((RandomSource)randomSource), this.noiseFreq.sample((RandomSource)randomSource), stepOrigin, box, action);
        }
    }
}

