/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.util.BWGUtil;
import net.potionstudios.biomeswevegone.world.level.levelgen.CheckedBlockPlacement;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructurePieceTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch.ArchConfig;
import org.jetbrains.annotations.NotNull;

public class ArchPiece
extends StructurePiece {
    private final BlockPos origin;
    private final BlockPos first;
    private final BlockPos second;
    private final int yOffset;
    private final ArchConfig.ArchGeneratorConfig generatorConfig;
    private final CheckedBlockPlacement blockPlacement;

    protected ArchPiece(BoundingBox boundingBox, BlockPos origin, BlockPos first, BlockPos second, int yOffset, ArchConfig.ArchGeneratorConfig generatorConfig, CheckedBlockPlacement blockPlacement) {
        super(BWGStructurePieceTypes.ARCH_PIECE.get(), 0, boundingBox);
        this.origin = origin;
        this.first = first;
        this.second = second;
        this.yOffset = yOffset;
        this.generatorConfig = generatorConfig;
        this.blockPlacement = blockPlacement;
    }

    public ArchPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(BWGStructurePieceTypes.ARCH_PIECE.get(), tag);
        this.origin = BWGUtil.readBlockPos(tag, "origin").orElseThrow();
        this.first = BWGUtil.readBlockPos(tag, "first").orElseThrow();
        this.second = BWGUtil.readBlockPos(tag, "second").orElseThrow();
        this.yOffset = tag.getIntOr("yOffset", 0);
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)context.registryAccess());
        this.generatorConfig = (ArchConfig.ArchGeneratorConfig)((Pair)ArchConfig.ArchGeneratorConfig.CODEC.decode((DynamicOps)ops, (Object)((Tag)tag.getCompound("generatorConfig").orElseThrow())).result().orElseThrow()).getFirst();
        this.blockPlacement = (CheckedBlockPlacement)((Pair)CheckedBlockPlacement.CODEC.decode((DynamicOps)ops, (Object)tag.get("blockPlacements")).result().orElseThrow()).getFirst();
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.put("origin", BWGUtil.writeBlockPos(this.origin));
        tag.put("first", BWGUtil.writeBlockPos(this.first));
        tag.put("second", BWGUtil.writeBlockPos(this.second));
        tag.putInt("yOffset", this.yOffset);
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)context.registryAccess());
        tag.put("generatorConfig", (Tag)ArchConfig.ArchGeneratorConfig.CODEC.encodeStart((DynamicOps)ops, (Object)this.generatorConfig).result().orElseThrow());
        tag.put("blockPlacements", (Tag)CheckedBlockPlacement.CODEC.encodeStart((DynamicOps)ops, (Object)this.blockPlacement).result().orElseThrow());
    }

    public void postProcess(WorldGenLevel level, @NotNull StructureManager structureManager, @NotNull ChunkGenerator generator, @NotNull RandomSource random, @NotNull BoundingBox box, ChunkPos chunkPos, @NotNull BlockPos pos) {
        ChunkAccess chunk = level.getChunk(chunkPos.x, chunkPos.z);
        LongOpenHashSet cache = new LongOpenHashSet();
        Consumer<BlockPos> blockPosConsumer = arg_0 -> this.lambda$postProcess$0((LongSet)cache, arg_0);
        this.generatorConfig.generate(this.origin.asLong() + level.getSeed(), this.yOffset, Vec3.atCenterOf((Vec3i)this.first), Vec3.atCenterOf((Vec3i)this.origin), Vec3.atCenterOf((Vec3i)this.second), this.boundingBox, blockPosConsumer);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Pair<BlockPredicate, BlockStateProvider> blockPlacement : this.blockPlacement.blockPlacement()) {
            cache.forEach(packedPos -> {
                mutableBlockPos.set(packedPos);
                if (((BlockPredicate)blockPlacement.getFirst()).test((Object)level, (Object)mutableBlockPos)) {
                    chunk.setBlockState((BlockPos)mutableBlockPos, ((BlockStateProvider)blockPlacement.getSecond()).getState(random, (BlockPos)mutableBlockPos), 0);
                }
            });
        }
    }

    private /* synthetic */ void lambda$postProcess$0(LongSet cache, BlockPos blockPos) {
        if (this.boundingBox.isInside((Vec3i)blockPos)) {
            cache.add(blockPos.asLong());
        }
    }
}

