/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructureTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake.LargeLakeConfig;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake.LargeLakePiece;
import org.jetbrains.annotations.NotNull;

public class LargeLakeStructure
extends Structure {
    public static final MapCodec<LargeLakeStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)LargeLakeStructure.settingsCodec((RecordCodecBuilder.Instance)builder), (App)LargeLakeConfig.CODEC.fieldOf("config").forGetter(largeLakeStructure -> largeLakeStructure.largeLakeConfig)).apply((Applicative)builder, LargeLakeStructure::new));
    private final LargeLakeConfig largeLakeConfig;

    public LargeLakeStructure(Structure.StructureSettings settings, LargeLakeConfig largeLakeConfig) {
        super(settings);
        this.largeLakeConfig = largeLakeConfig;
    }

    @NotNull
    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        LevelHeightAccessor levelHeightAccessor;
        ChunkPos chunkPos = context.chunkPos();
        WorldgenRandom random = context.random();
        int blockX = chunkPos.getBlockX(random.nextInt(16));
        int blockZ = chunkPos.getBlockZ(random.nextInt(16));
        int lakeRadius = random.nextIntBetweenInclusive(96, 128);
        RandomState randomState = context.randomState();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        int baseHeight = chunkGenerator.getBaseHeight(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, levelHeightAccessor = context.heightAccessor(), randomState);
        if (baseHeight <= chunkGenerator.getSeaLevel() || baseHeight < chunkGenerator.getBaseHeight(blockX, blockZ, Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        return LargeLakeStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, piecesBuilder -> {
            BlockPos lakeOrigin = new BlockPos(blockX, baseHeight, blockZ);
            this.createLakePieces(context, (StructurePiecesBuilder)piecesBuilder, lakeRadius, lakeOrigin, this.largeLakeConfig.depth().sample((RandomSource)random), levelHeightAccessor);
        });
    }

    private void createLakePieces(Structure.GenerationContext context, StructurePiecesBuilder piecesBuilder, int arenaFloorRadius, BlockPos arenaOrigin, int lakeDepth, LevelHeightAccessor levelHeightAccessor) {
        for (int chunkX = -(SectionPos.blockToSectionCoord((int)arenaFloorRadius) + 1); chunkX <= SectionPos.blockToSectionCoord((int)arenaFloorRadius) + 1; ++chunkX) {
            for (int chunkZ = -(SectionPos.blockToSectionCoord((int)arenaFloorRadius) + 1); chunkZ <= SectionPos.blockToSectionCoord((int)arenaFloorRadius) + 1; ++chunkZ) {
                BlockPos chunkWorldPos = new BlockPos(SectionPos.sectionToBlockCoord((int)(context.chunkPos().x + chunkX)), arenaOrigin.getY(), SectionPos.sectionToBlockCoord((int)(context.chunkPos().z + chunkZ)));
                BoundingBox boundingBox = new BoundingBox(chunkWorldPos.getX(), levelHeightAccessor.getMinY(), chunkWorldPos.getZ(), chunkWorldPos.getX() + 15, levelHeightAccessor.getMaxY(), chunkWorldPos.getZ() + 15);
                piecesBuilder.addPiece((StructurePiece)new LargeLakePiece(arenaOrigin, arenaFloorRadius, 20, boundingBox, this.largeLakeConfig.features()));
            }
        }
    }

    @NotNull
    public StructureType<?> type() {
        return BWGStructureTypes.LARGE_LAKE.get();
    }
}

