/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.level.block.custom.BWGFarmLandBlock;
import org.jetbrains.annotations.NotNull;

public interface PlatformHandler {
    public static final PlatformHandler PLATFORM_HANDLER = PlatformHandler.load(PlatformHandler.class);

    public Platform getPlatform();

    public Path configPath();

    default public boolean hasPermission(@NotNull CommandSourceStack sourceStack, @NotNull String permission) {
        return sourceStack.hasPermission(4);
    }

    default public Supplier<PoiType> registerPOIType(String id, Supplier<? extends Block> block, int maxTickets, int validRange) {
        return this.register(BuiltInRegistries.POINT_OF_INTEREST_TYPE, id, () -> new PoiType(PoiTypes.getBlockStates((Block)((Block)block.get())), maxTickets, validRange));
    }

    default public FlowerPotBlock createPottedBlock(Supplier<? extends Block> block, BlockBehaviour.Properties properties) {
        return new FlowerPotBlock(block.get(), properties);
    }

    default public Supplier<MobBucketItem> createMobBucket(Supplier<EntityType<? extends Mob>> entity, Supplier<Fluid> fluid, Supplier<SoundEvent> sound) {
        return () -> new MobBucketItem((EntityType)entity.get(), (Fluid)fluid.get(), (SoundEvent)sound.get(), new Item.Properties().stacksTo(1).component(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY).setId(BiomesWeveGone.key(Registries.ITEM, ((EntityType)entity.get()).toShortString() + "_bucket")));
    }

    default public BWGFarmLandBlock bwgFarmLandBlock(BlockBehaviour.Properties properties, Supplier<Block> dirt) {
        return new BWGFarmLandBlock(properties, dirt);
    }

    public WoodType createWoodType(String var1, @NotNull BlockSetType var2);

    public Supplier<SimpleParticleType> registerCreateParticle(String var1);

    public Supplier<CreativeModeTab> createCreativeTab(String var1, Supplier<ItemStack> var2, ArrayList<Supplier<? extends Item>> ... var3);

    private static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        BiomesWeveGone.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public <T> Supplier<T> register(Registry<? super T> var1, String var2, Supplier<T> var3);

    public <T> Supplier<Holder.Reference<T>> registerForHolder(Registry<T> var1, String var2, Supplier<T> var3);

    public static enum Platform {
        FORGE,
        FABRIC,
        NEOFORGE;

    }
}

