/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.potionstudios.biomeswevegone.world.entity.ai.memory.BWGMemoryModuleType;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import org.jetbrains.annotations.NotNull;

public class PlaceInContainer
extends Behavior<PumpkinWarden> {
    private BlockPos targetPos;
    protected int tryTicks;

    public PlaceInContainer() {
        super((Map)ImmutableMap.of(BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get(), (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected void tick(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        if (this.targetPos == null) {
            return;
        }
        if (!this.targetPos.closerToCenterThan((Position)pumpkinWarden.position(), 2.0)) {
            ++this.tryTicks;
            if (this.tryTicks > 200) {
                this.stop(level, pumpkinWarden, gameTime);
            }
        } else if (!pumpkinWarden.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            BlockEntity blockEntity = level.getBlockEntity(this.targetPos);
            if (blockEntity instanceof HopperBlockEntity) {
                HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)blockEntity;
                HopperBlockEntity.addItem(null, (Container)hopperBlockEntity, (ItemStack)pumpkinWarden.getItemInHand(InteractionHand.MAIN_HAND), (Direction)pumpkinWarden.getDirection());
            } else if (blockEntity instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrelBlockEntity = (BarrelBlockEntity)blockEntity;
                ItemStack itemStack = pumpkinWarden.getItemInHand(InteractionHand.MAIN_HAND);
                for (int i = 0; i < barrelBlockEntity.getContainerSize(); ++i) {
                    ItemStack slotStack = barrelBlockEntity.getItem(i);
                    if (slotStack.isEmpty()) {
                        barrelBlockEntity.setItem(i, itemStack);
                        barrelBlockEntity.setChanged();
                    } else {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemStack) || slotStack.getCount() >= slotStack.getMaxStackSize()) continue;
                        slotStack.grow(1);
                        barrelBlockEntity.setChanged();
                    }
                    break;
                }
            } else {
                return;
            }
            pumpkinWarden.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            pumpkinWarden.getBrain().setMemory(BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get(), (Object)this.targetPos);
            this.stop(level, pumpkinWarden, gameTime);
        } else {
            this.stop(level, pumpkinWarden, gameTime);
        }
    }

    protected void start(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        Optional<BlockPos> optionalBlockPos;
        if (pumpkinWarden.getBrain().hasMemoryValue(BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get()) && pumpkinWarden.getBrain().getMemory(BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get()).isPresent()) {
            this.targetPos = (BlockPos)pumpkinWarden.getBrain().getMemory(BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get()).get();
            Block block = level.getBlockState(this.targetPos).getBlock();
            if (block instanceof HopperBlock || block instanceof BarrelBlock) {
                pumpkinWarden.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.targetPos));
                pumpkinWarden.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.targetPos, 1.0f, 0));
                return;
            }
        }
        if ((optionalBlockPos = this.findHopperOrBarrel(level, pumpkinWarden.blockPosition(), 20.0)).isPresent()) {
            this.targetPos = optionalBlockPos.get();
            pumpkinWarden.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.targetPos));
            pumpkinWarden.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.targetPos, 1.0f, 0));
        } else {
            if (level.getRandom().nextBoolean()) {
                level.broadcastEntityEvent((Entity)pumpkinWarden, (byte)13);
            }
            this.stop(level, pumpkinWarden, gameTime);
        }
    }

    private Optional<BlockPos> findHopperOrBarrel(@NotNull ServerLevel level, BlockPos blockPos, double distance) {
        Optional<BlockPos> nearestBarrel = Optional.empty();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int i = 0;
        while ((double)i <= distance) {
            int j = 0;
            while ((double)j < distance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        mutableBlockPos.setWithOffset((Vec3i)blockPos, k, i - 1, l);
                        if (blockPos.closerThan((Vec3i)mutableBlockPos, distance) && level.getBlockState((BlockPos)mutableBlockPos).getBlock() instanceof HopperBlock) {
                            return Optional.of(mutableBlockPos.immutable());
                        }
                        if (nearestBarrel.isEmpty() && level.getBlockState((BlockPos)mutableBlockPos).getBlock() instanceof BarrelBlock) {
                            nearestBarrel = Optional.of(mutableBlockPos.immutable());
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return nearestBarrel;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden) {
        return pumpkinWarden.canMove() && !pumpkinWarden.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && level.isBrightOutside();
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        return this.checkExtraStartConditions(level, pumpkinWarden);
    }

    protected void stop(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        pumpkinWarden.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        pumpkinWarden.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }
}

