/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.oddion;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.potionstudios.biomeswevegone.config.configs.BWGMobSpawnConfig;
import net.potionstudios.biomeswevegone.sounds.BWGSounds;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animatable.processing.AnimationTest;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Oddion
extends PathfinderMob
implements GeoEntity {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation WALKING = RawAnimation.begin().thenPlay("walking");
    private static final RawAnimation POP_UP = RawAnimation.begin().thenPlay("pop_up");
    private static final RawAnimation DANCE = RawAnimation.begin().thenPlay("dance");
    private static final RawAnimation GROUND = RawAnimation.begin().thenPlay("ground");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final RawAnimation PET = RawAnimation.begin().thenLoop("pet");
    private static final EntityDataAccessor<Integer> RISING_TIMER = SynchedEntityData.defineId(Oddion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> GROUNDING_TIMER = SynchedEntityData.defineId(Oddion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> PET_TIMER = SynchedEntityData.defineId(Oddion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(Oddion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> PARTYING = SynchedEntityData.defineId(Oddion.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GROUNDED = SynchedEntityData.defineId(Oddion.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int onionTime = 6000;
    public Goal movementGoal = new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0);
    @Nullable
    private BlockPos jukebox;

    public Oddion(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public Oddion(Level level) {
        this(BWGEntityType.ODDION.get(), level);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PARTYING, (Object)false);
        builder.define(GROUNDED, (Object)true);
        builder.define(RISING_TIMER, (Object)0);
        builder.define(GROUNDING_TIMER, (Object)0);
        builder.define(DATA_VARIANT, (Object)0);
        builder.define(PET_TIMER, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 2.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike)Items.BONE_MEAL), false));
    }

    protected void addAdditionalSaveData(@NotNull ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putInt("Variant", this.getVariant().getId());
    }

    protected void readAdditionalSaveData(@NotNull ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setVariant(Variant.byId(valueInput.getIntOr("Variant", 0)));
    }

    public static boolean checkOddionSpawnRules(EntityType<? extends Oddion> entity, LevelAccessor world, EntitySpawnReason spawnType, BlockPos pos, RandomSource rand) {
        return BWGMobSpawnConfig.INSTANCE.oddion && world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        this.setVariant(Variant.getSpawnVariant(level.getRandom()));
        return super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 0, this::predicate));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.TEMPT_RANGE, 16.0);
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return BWGSounds.ODDION_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return BWGSounds.ODDION_DEATH.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return BWGSounds.ODDION_AMBIENT.get();
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> dataAccessor) {
        super.onSyncedDataUpdated(dataAccessor);
        if (GROUNDED.equals(dataAccessor)) {
            this.refreshDimensions();
        }
    }

    public void aiStep() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (--this.onionTime <= 0) {
                this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.spawnAtLocation(serverLevel, (ItemLike)BWGItems.ODDION_BULB.get());
                this.gameEvent((Holder)GameEvent.ENTITY_PLACE);
                this.onionTime = 6000;
            }
            if (!this.isGrounded()) {
                if (this.jukebox == null || !this.jukebox.closerToCenterThan((Position)this.position(), 3.46) || !serverLevel.getBlockState(this.jukebox).is(Blocks.JUKEBOX)) {
                    this.setPartying(false);
                    this.jukebox = null;
                }
                this.checkGoals();
                if (this.getRisingTime() > 0) {
                    this.setRisingTimer(this.getRisingTime() - 1);
                }
                if (serverLevel.getEntitiesOfClass(Player.class, new AABB(this.blockPosition()).inflate(8.0)).isEmpty()) {
                    this.setGroundingTimer(this.getGroundingTime() + 1);
                }
            } else if (!serverLevel.getEntitiesOfClass(Player.class, new AABB(this.blockPosition()).inflate(3.0)).isEmpty()) {
                this.setGrounded(false);
                this.setRisingTimer(20);
            }
            if (this.getGroundingTime() > 600) {
                this.setGrounded(true);
                this.goalSelector.removeGoal(this.movementGoal);
                this.setGroundingTimer(0);
            }
            if (this.isBeingPet()) {
                this.goalSelector.removeGoal(this.movementGoal);
                this.setPetTime(this.getPetTime() - 1);
            }
        }
        super.aiStep();
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.isGrounded()) {
            this.petOddion();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void petOddion() {
        if (!this.level().isClientSide) {
            this.setPetTime(20);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BWGSounds.ODDION_HAPPY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        float expansion = 0.5f;
        for (int heartCount = 0; heartCount < this.level().random.nextInt(5, 10); ++heartCount) {
            double xSize = this.getBoundingBox().getXsize();
            double ySize = this.getBoundingBox().getYsize();
            double zSize = this.getBoundingBox().getZsize();
            float randX = Mth.randomBetween((RandomSource)this.level().random, (float)((float)(-xSize) - expansion), (float)((float)xSize + expansion)) / 2.0f;
            float randY = Mth.randomBetween((RandomSource)this.level().random, (float)0.0f, (float)((float)ySize + expansion));
            float randZ = Mth.randomBetween((RandomSource)this.level().random, (float)((float)(-zSize) - expansion), (float)((float)zSize + expansion)) / 2.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getX() + (double)randX, this.getY() + (double)randY, this.getZ() + (double)randZ, 0.05, 0.1, 0.05);
        }
    }

    public void checkGoals() {
        if (this.goalSelector.getAvailableGoals().stream().noneMatch(goal -> goal.getGoal().getClass() == WaterAvoidingRandomStrollGoal.class)) {
            this.goalSelector.addGoal(1, this.movementGoal);
        }
    }

    private PlayState predicate(AnimationTest<Oddion> event) {
        if (this.isGrounded()) {
            return event.setAndContinue(GROUND);
        }
        if (this.isRising()) {
            return event.setAndContinue(POP_UP);
        }
        if (this.isBeingPet()) {
            return event.setAndContinue(PET);
        }
        if (this.isPartying()) {
            return event.setAndContinue(DANCE);
        }
        if (event.isMoving()) {
            return event.setAndContinue(WALKING);
        }
        return event.setAndContinue(IDLE);
    }

    private boolean isRising() {
        return this.getRisingTime() > 0;
    }

    public void setRecordPlayingNearby(@NotNull BlockPos jukebox, boolean partying) {
        this.jukebox = jukebox;
        this.setPartying(partying);
        this.goalSelector.removeGoal(this.movementGoal);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public boolean isPartying() {
        return (Boolean)this.entityData.get(PARTYING);
    }

    public void setPartying(boolean flag) {
        this.entityData.set(PARTYING, (Object)flag);
    }

    public boolean isGrounded() {
        return (Boolean)this.entityData.get(GROUNDED);
    }

    public void setGrounded(boolean flag) {
        this.entityData.set(GROUNDED, (Object)flag);
    }

    public int getRisingTime() {
        return (Integer)this.entityData.get(RISING_TIMER);
    }

    public void setRisingTimer(int flag) {
        this.entityData.set(RISING_TIMER, (Object)flag);
    }

    public int getGroundingTime() {
        return (Integer)this.entityData.get(GROUNDING_TIMER);
    }

    public void setGroundingTimer(int flag) {
        this.entityData.set(GROUNDING_TIMER, (Object)flag);
    }

    public int getPetTime() {
        return (Integer)this.entityData.get(PET_TIMER);
    }

    public void setPetTime(int time) {
        this.entityData.set(PET_TIMER, (Object)time);
    }

    public boolean isBeingPet() {
        return this.getPetTime() > 0;
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pose) {
        if (this.isGrounded()) {
            return this.getType().getDimensions().scale(1.0f, 0.25f);
        }
        return super.getDimensions(pose);
    }

    public void setVariant(@NotNull Variant variant) {
        this.entityData.set(DATA_VARIANT, (Object)variant.getId());
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT));
    }

    public static enum Variant implements StringRepresentable
    {
        STANDARD(0, "standard"),
        PINK(1, "pink"),
        ALBINO(2, "albino");

        private static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        private final String name;
        private final int id;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private static Variant getSpawnVariant(@NotNull RandomSource random) {
            int i = random.nextInt(100);
            return i < 47 ? STANDARD : (i < 94 ? PINK : ALBINO);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

