/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.item;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.entity.decoration.Wreath;
import net.potionstudios.biomeswevegone.world.item.custom.CampfireExplodingBlockItem;
import net.potionstudios.biomeswevegone.world.item.custom.PowderItem;
import net.potionstudios.biomeswevegone.world.item.custom.WreathItem;
import net.potionstudios.biomeswevegone.world.item.jukebox.BWGJukeBoxSongs;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.cattail.ColorProperty;

public class BWGItems {
    public static final ArrayList<Supplier<? extends Item>> ITEMS = new ArrayList();
    public static final ArrayList<Supplier<? extends Item>> NO_LANG_ITEMS = new ArrayList();
    public static final ArrayList<Supplier<? extends Item>> SIMPLE_ITEMS = new ArrayList();
    public static final Supplier<Item> BWG_LOGO = BWGItems.register("bwg_logo", Item::new, new Item.Properties());
    public static final Supplier<SpawnEggItem> MAN_O_WAR_SPAWN_EGG = BWGItems.registerSimpleItem("man_o_war_spawn_egg", properties -> new SpawnEggItem(BWGEntityType.MAN_O_WAR.get(), properties), new Item.Properties());
    public static final Supplier<SpawnEggItem> PUMPKIN_WARDEN_SPAWN_EGG = BWGItems.registerSimpleItem("pumpkin_warden_spawn_egg", properties -> new SpawnEggItem(BWGEntityType.PUMPKIN_WARDEN.get(), properties), new Item.Properties());
    public static final Supplier<SpawnEggItem> ODDION_SPAWN_EGG = BWGItems.registerSimpleItem("oddion_spawn_egg", properties -> new SpawnEggItem(BWGEntityType.ODDION.get(), properties), new Item.Properties());
    public static final Supplier<MobBucketItem> MAN_O_WAR_BUCKET = BWGItems.registerMobBucket("man_o_war_bucket", BWGEntityType.MAN_O_WAR::get, () -> Fluids.WATER, () -> SoundEvents.BUCKET_EMPTY_FISH);
    public static final Supplier<Item> CATTAIL_SPROUT = BWGItems.registerItemNoLang("cattail_sprout", properties -> new CampfireExplodingBlockItem((Supplier<? extends Block>)BWGBlocks.CATTAIL_SPROUT, (Item.Properties)properties), new Item.Properties().useBlockDescriptionPrefix());
    public static final Supplier<Item> FLUORESCENT_CATTAIL_SPROUT = BWGItems.registerItemNoLang("fluorescent_cattail_sprout", properties -> new CampfireExplodingBlockItem((Supplier<? extends Block>)BWGBlocks.FLUORESCENT_CATTAIL_SPROUT, (Item.Properties)properties), new Item.Properties().useBlockDescriptionPrefix());
    public static final Supplier<Item> PUMPKIN_BURROW = BWGItems.registerItemNoLang("pumpkin_burrow", properties -> new BlockItem((Block)BWGBlocks.PUMPKIN_BURROW.get(), properties), new Item.Properties().useBlockDescriptionPrefix());
    public static final Supplier<Item> BLUE_GLOWCANE_SHOOT = BWGItems.registerSimpleItem("blue_glowcane_shoot", properties -> new BlockItem((Block)BWGBlocks.BLUE_GLOWCANE.get(), properties), new Item.Properties().useItemDescriptionPrefix());
    public static final Supplier<Item> GREEN_GLOWCANE_SHOOT = BWGItems.registerSimpleItem("green_glowcane_shoot", properties -> new BlockItem((Block)BWGBlocks.GREEN_GLOWCANE.get(), properties), new Item.Properties().useItemDescriptionPrefix());
    public static final Supplier<Item> RED_GLOWCANE_SHOOT = BWGItems.registerSimpleItem("red_glowcane_shoot", properties -> new BlockItem((Block)BWGBlocks.RED_GLOWCANE.get(), properties), new Item.Properties().useItemDescriptionPrefix());
    public static final Supplier<Item> YELLOW_GLOWCANE_SHOOT = BWGItems.registerSimpleItem("yellow_glowcane_shoot", properties -> new BlockItem((Block)BWGBlocks.YELLOW_GLOWCANE.get(), properties), new Item.Properties().useItemDescriptionPrefix());
    public static final Supplier<Item> BLUE_GLOWCANE_POWDER = BWGItems.registerSimpleItem("blue_glowcane_powder", properties -> new PowderItem((Item.Properties)properties, ColorProperty.BLUE), new Item.Properties());
    public static final Supplier<Item> GREEN_GLOWCANE_POWDER = BWGItems.registerSimpleItem("green_glowcane_powder", properties -> new PowderItem((Item.Properties)properties, ColorProperty.GREEN), new Item.Properties());
    public static final Supplier<Item> RED_GLOWCANE_POWDER = BWGItems.registerSimpleItem("red_glowcane_powder", properties -> new PowderItem((Item.Properties)properties, ColorProperty.RED), new Item.Properties());
    public static final Supplier<Item> YELLOW_GLOWCANE_POWDER = BWGItems.registerSimpleItem("yellow_glowcane_powder", properties -> new PowderItem((Item.Properties)properties, ColorProperty.YELLOW), new Item.Properties());
    public static final Supplier<Item> PALE_PUMPKIN_SEEDS = BWGItems.registerSimpleItem("pale_pumpkin_seeds", properties -> new BlockItem((Block)BWGBlocks.PALE_PUMPKIN_STEM.get(), properties), new Item.Properties().useItemDescriptionPrefix());
    public static final Supplier<Item> BAOBAB_FRUIT = BWGItems.registerSimpleItem("baobab_fruit", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.35f).build()));
    public static final Supplier<Item> SOUL_FRUIT = BWGItems.registerSimpleItem("soul_fruit", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(4).saturationModifier(0.35f).build()).component(DataComponents.CONSUMABLE, (Object)Consumable.builder().onConsume((ConsumeEffect)new ApplyStatusEffectsConsumeEffect(new MobEffectInstance(MobEffects.BLINDNESS, 40))).build()));
    public static final Supplier<Item> YUCCA_FRUIT = BWGItems.registerSimpleItem("yucca_fruit", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.35f).build()));
    public static final Supplier<Item> COOKED_YUCCA_FRUIT = BWGItems.registerSimpleItem("cooked_yucca_fruit", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(5).saturationModifier(0.4f).build()));
    public static final Supplier<Item> GREEN_APPLE = BWGItems.registerSimpleItem("green_apple", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(4).saturationModifier(0.35f).build()));
    public static final Supplier<Item> GREEN_APPLE_PIE = BWGItems.registerSimpleItem("green_apple_pie", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(6).saturationModifier(0.4f).build()).component(DataComponents.CONSUMABLE, (Object)Consumable.builder().onConsume((ConsumeEffect)new ApplyStatusEffectsConsumeEffect(new MobEffectInstance(MobEffects.HASTE, 200, 0))).build()));
    public static final Supplier<Item> BLUEBERRIES = BWGItems.registerSimpleItem("blueberries", properties -> new BlockItem((Block)BWGBlocks.BLUEBERRY_BUSH.get(), properties), new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.1f).build()).useItemDescriptionPrefix());
    public static final Supplier<Item> BLUEBERRY_PIE = BWGItems.registerSimpleItem("blueberry_pie", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(6).saturationModifier(0.3f).build()).component(DataComponents.CONSUMABLE, (Object)Consumable.builder().onConsume((ConsumeEffect)new ApplyStatusEffectsConsumeEffect(new MobEffectInstance(MobEffects.SPEED, 200, 0))).build()));
    public static final Supplier<Item> ODDION_BULB = BWGItems.registerSimpleItem("oddion_bulb", properties -> new BlockItem((Block)BWGBlocks.ODDION_CROP.get(), properties), new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.35f).build()).useItemDescriptionPrefix());
    public static final Supplier<Item> COOKED_ODDION_BULB = BWGItems.registerSimpleItem("cooked_oddion_bulb", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(5).saturationModifier(0.5f).build()));
    public static final Supplier<Item> ALLIUM_ODDION_SOUP = BWGItems.registerSimpleItem("allium_oddion_soup", Item::new, new Item.Properties().stacksTo(1).usingConvertsTo(Items.BOWL).food(new FoodProperties.Builder().nutrition(8).saturationModifier(1.0f).build()));
    public static final Supplier<Item> BLOOMING_ODDION = BWGItems.registerSimpleItem("blooming_oddion", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(9).saturationModifier(1.2f).build()));
    public static final Supplier<Item> WHITE_PUFFBALL_SPORES = BWGItems.registerSimpleItem("white_puffball_spores", properties -> new BlockItem(BWGBlocks.WHITE_PUFFBALL.getBlock(), properties), new Item.Properties().useItemDescriptionPrefix());
    public static final Supplier<Item> WHITE_PUFFBALL_CAP = BWGItems.registerSimpleItem("white_puffball_cap", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.2f).build()));
    public static final Supplier<Item> COOKED_WHITE_PUFFBALL_CAP = BWGItems.registerSimpleItem("cooked_white_puffball_cap", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(3).saturationModifier(0.6f).build()));
    public static final Supplier<Item> WHITE_PUFFBALL_STEW = BWGItems.registerSimpleItem("white_puffball_stew", Item::new, new Item.Properties().stacksTo(1).usingConvertsTo(Items.BOWL).food(new FoodProperties.Builder().nutrition(9).saturationModifier(1.0f).build()));
    public static final Supplier<Item> ALOE_VERA_JUICE = BWGItems.registerSimpleItem("aloe_vera_juice", Item::new, new Item.Properties().craftRemainder(Items.GLASS_BOTTLE).usingConvertsTo(Items.GLASS_BOTTLE).stacksTo(16).food(new FoodProperties.Builder().nutrition(3).saturationModifier(1.0f).build()));
    public static final Supplier<PlaceOnWaterBlockItem> TINY_LILY_PADS = BWGItems.registerItemNoLang("tiny_lily_pads", properties -> new PlaceOnWaterBlockItem((Block)BWGBlocks.TINY_LILY_PADS.get(), properties), new Item.Properties().useBlockDescriptionPrefix());
    public static final Supplier<PlaceOnWaterBlockItem> FLOWERING_TINY_LILY_PADS = BWGItems.registerItemNoLang("flowering_tiny_lily_pads", properties -> new PlaceOnWaterBlockItem((Block)BWGBlocks.FLOWERING_TINY_LILY_PADS.get(), properties), new Item.Properties().useBlockDescriptionPrefix());
    public static final Supplier<PlaceOnWaterBlockItem> WATER_SILK = BWGItems.registerItemNoLang("water_silk", properties -> new PlaceOnWaterBlockItem(BWGBlocks.WATER_SILK.get(), properties), new Item.Properties().useBlockDescriptionPrefix());
    public static final Supplier<Item> MUSIC_DISC_PIXIE_CLUB = BWGItems.registerItemNoLang("music_disc_pixie_club", Item::new, new Item.Properties().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(BWGJukeBoxSongs.PIXIE_CLUB));
    public static final Supplier<Item> MUSIC_DISC_BETTER_DAYS = BWGItems.registerItemNoLang("music_disc_better_days", Item::new, new Item.Properties().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(BWGJukeBoxSongs.BETTER_DAYS));
    public static final Supplier<WreathItem> WREATH = BWGItems.registerItem("wreath", properties -> new WreathItem((Item.Properties)properties, Wreath.Type.DEFAULT), new Item.Properties());
    public static final Supplier<WreathItem> HOLLY_WREATH = BWGItems.registerItem("holly_wreath", properties -> new WreathItem((Item.Properties)properties, Wreath.Type.HOLLY), new Item.Properties());
    public static final Supplier<WreathItem> MUSHROOM_WREATH = BWGItems.registerItem("mushroom_wreath", properties -> new WreathItem((Item.Properties)properties, Wreath.Type.MUSHROOM), new Item.Properties());
    public static final Supplier<WreathItem> ODDION_WREATH = BWGItems.registerItem("oddion_wreath", properties -> new WreathItem((Item.Properties)properties, Wreath.Type.ODDION), new Item.Properties());
    public static final Supplier<WreathItem> PETAL_WREATH = BWGItems.registerItem("petal_wreath", properties -> new WreathItem((Item.Properties)properties, Wreath.Type.PETAL), new Item.Properties());
    public static final Supplier<WreathItem> ROSY_WREATH = BWGItems.registerItem("rosy_wreath", properties -> new WreathItem((Item.Properties)properties, Wreath.Type.ROSY), new Item.Properties());
    public static final Supplier<WreathItem> WINTER_ROSY_WREATH = BWGItems.registerItem("winter_rosy_wreath", properties -> new WreathItem((Item.Properties)properties, Wreath.Type.WINTER_ROSY), new Item.Properties());

    private static Supplier<MobBucketItem> registerMobBucket(String id, Supplier<EntityType<? extends Mob>> entity, Supplier<Fluid> fluid, Supplier<SoundEvent> sound) {
        Supplier<MobBucketItem> supplier = PlatformHandler.PLATFORM_HANDLER.createMobBucket(entity, fluid, sound);
        supplier = PlatformHandler.PLATFORM_HANDLER.register(BuiltInRegistries.ITEM, id, supplier);
        SIMPLE_ITEMS.add(supplier);
        ITEMS.add(supplier);
        return supplier;
    }

    public static <I extends Item> Supplier<I> registerSimpleItem(String id, Function<Item.Properties, I> item, Item.Properties properties) {
        Supplier<I> supplier = BWGItems.registerItem(id, item, properties);
        SIMPLE_ITEMS.add(supplier);
        return supplier;
    }

    public static <I extends Item> Supplier<I> registerItem(String id, Function<Item.Properties, I> item, Item.Properties properties) {
        Supplier<I> supplier = BWGItems.register(id, item, properties);
        ITEMS.add(supplier);
        return supplier;
    }

    public static <I extends Item> Supplier<I> registerItemNoLang(String id, Function<Item.Properties, I> item, Item.Properties properties) {
        Supplier<I> supplier = BWGItems.register(id, item, properties);
        NO_LANG_ITEMS.add(supplier);
        return supplier;
    }

    public static <I extends Item> Supplier<I> register(String id, Function<Item.Properties, I> item, Item.Properties properties) {
        return PlatformHandler.PLATFORM_HANDLER.register(BuiltInRegistries.ITEM, id, () -> (Item)item.apply(properties.setId(BWGItems.key(id))));
    }

    private static ResourceKey<Item> key(String id) {
        return BiomesWeveGone.key(Registries.ITEM, id);
    }

    public static void items() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biomes We've Gone items");
    }
}

