/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;

public class CragLakeFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public CragLakeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        ImprovedNoise noiseSampler = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(context.level().getLevel().getSeed()));
        ImprovedNoise lakeDepthSampler = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(context.level().getLevel().getSeed() + 2439854945L));
        WorldGenLevel level = context.level();
        ChunkAccess chunk = level.getChunk(context.origin());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        ChunkPos pos = chunk.getPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int offsetHeight;
                double noiseWaterThreshold;
                int worldX = pos.getBlockX(x);
                int worldZ = pos.getBlockZ(z);
                int heightmap = chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
                double noise = CragLakeFeature.getNoise(noiseSampler, worldX, worldZ);
                if (!(noise < (noiseWaterThreshold = 0.35))) continue;
                mutable.set(worldX, heightmap, worldZ);
                if (!chunk.getBlockState((BlockPos)mutable).canOcclude()) continue;
                boolean mayPlace = true;
                for (Direction direction : DIRECTIONS) {
                    mutable.set(worldX, heightmap, worldZ).move(direction);
                    BlockState offsetState = level.getBlockState((BlockPos)mutable);
                    if (offsetState.canOcclude() || offsetState.getFluidState().is((Fluid)Fluids.WATER)) continue;
                    mayPlace = false;
                    break;
                }
                boolean hasWaterfall = false;
                if (!mayPlace) {
                    for (Direction direction : DIRECTIONS) {
                        double offsetNoise;
                        mutable.set(worldX, heightmap, worldZ).move(direction);
                        offsetHeight = level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, mutable.getX(), mutable.getZ());
                        if (offsetHeight >= heightmap || !((offsetNoise = CragLakeFeature.getNoise(noiseSampler, mutable.getX(), mutable.getZ())) < noiseWaterThreshold)) continue;
                        mayPlace = true;
                        hasWaterfall = true;
                    }
                }
                for (Direction direction : DIRECTIONS) {
                    mutable.set(worldX, 0, worldZ).move(direction);
                    offsetHeight = level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, mutable.getX(), mutable.getZ());
                    mutable.setY(offsetHeight);
                    if (level.getBiome((BlockPos)mutable).is(BWGBiomes.CRAG_GARDENS)) continue;
                    mayPlace = false;
                    break;
                }
                if (!mayPlace) continue;
                if (!hasWaterfall) {
                    double depthDelta = noise / (noiseWaterThreshold * 0.5);
                    double clampedDelta = Mth.clamp((double)depthDelta, (double)0.0, (double)1.0);
                    double normalizedLakeDepth = (lakeDepthSampler.noise((double)mutable.getX() * 0.3, 0.0, (double)mutable.getZ() * 0.3) + 1.0) * 0.5;
                    double lakeDepth = BlendingFunction.EaseInOutCirc.INSTANCE.apply(clampedDelta, 1.0, normalizedLakeDepth * 5.0);
                    mutable.set(worldX, heightmap, worldZ);
                    chunk.setBlockState((BlockPos)mutable, Blocks.WATER.defaultBlockState());
                    level.scheduleTick(mutable.immutable(), (Fluid)Fluids.WATER, 0);
                    chunk.markPosForPostprocessing((BlockPos)mutable.move(Direction.UP));
                    chunk.markPosForPostprocessing((BlockPos)mutable.move(Direction.UP));
                    int lakeY = 1;
                    while ((double)lakeY < lakeDepth) {
                        mutable.set(worldX, heightmap - lakeY, worldZ);
                        chunk.setBlockState((BlockPos)mutable, Blocks.WATER.defaultBlockState());
                        level.scheduleTick(mutable.immutable(), (Fluid)Fluids.WATER, 0);
                        ++lakeY;
                    }
                    continue;
                }
                mutable.set(worldX, heightmap, worldZ);
                chunk.setBlockState((BlockPos)mutable, Blocks.WATER.defaultBlockState());
                level.scheduleTick(mutable.immutable(), (Fluid)Fluids.WATER, 0);
                chunk.markPosForPostprocessing((BlockPos)mutable.move(Direction.UP));
                chunk.markPosForPostprocessing((BlockPos)mutable.move(Direction.UP));
            }
        }
        return true;
    }

    private static double getNoise(ImprovedNoise noiseSampler, int worldX, int worldZ) {
        double freq = 0.05;
        return (noiseSampler.noise((double)worldX * freq, 0.0, (double)worldZ * freq) + 1.0) * 0.5;
    }
}

