/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.potionstudios.biomeswevegone.world.entity.ai.memory.BWGMemoryModuleType;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import org.jetbrains.annotations.NotNull;

public class PlaceInContainer
extends Behavior<PumpkinWarden> {
    private BlockPos targetPos;
    protected int tryTicks;

    public PlaceInContainer() {
        super((Map)ImmutableMap.of(BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get(), (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected void tick(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        if (this.targetPos == null) {
            return;
        }
        if (!this.targetPos.m_203195_((Position)pumpkinWarden.m_20182_(), 2.0)) {
            ++this.tryTicks;
            if (this.tryTicks > 200) {
                this.stop(level, pumpkinWarden, gameTime);
            }
        } else if (!pumpkinWarden.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            BlockEntity blockEntity = level.m_7702_(this.targetPos);
            if (blockEntity instanceof HopperBlockEntity) {
                HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)blockEntity;
                HopperBlockEntity.m_59326_(null, (Container)hopperBlockEntity, (ItemStack)pumpkinWarden.m_21120_(InteractionHand.MAIN_HAND), (Direction)pumpkinWarden.m_6350_());
            } else if (blockEntity instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrelBlockEntity = (BarrelBlockEntity)blockEntity;
                ItemStack itemStack = pumpkinWarden.m_21120_(InteractionHand.MAIN_HAND);
                for (int i = 0; i < barrelBlockEntity.m_6643_(); ++i) {
                    ItemStack slotStack = barrelBlockEntity.m_8020_(i);
                    if (slotStack.m_41619_()) {
                        barrelBlockEntity.m_6836_(i, itemStack);
                        barrelBlockEntity.m_6596_();
                    } else {
                        if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)itemStack) || slotStack.m_41613_() >= slotStack.m_41741_()) continue;
                        slotStack.m_41769_(1);
                        barrelBlockEntity.m_6596_();
                    }
                    break;
                }
            } else {
                return;
            }
            pumpkinWarden.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            pumpkinWarden.m_6274_().m_21879_(BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get(), (Object)this.targetPos);
            this.stop(level, pumpkinWarden, gameTime);
        } else {
            this.stop(level, pumpkinWarden, gameTime);
        }
    }

    protected void start(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        Optional<BlockPos> optionalBlockPos;
        if (pumpkinWarden.m_6274_().m_21874_(BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get()) && pumpkinWarden.m_6274_().m_21952_(BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get()).isPresent()) {
            this.targetPos = (BlockPos)pumpkinWarden.m_6274_().m_21952_(BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get()).get();
            Block block = level.m_8055_(this.targetPos).m_60734_();
            if (block instanceof HopperBlock || block instanceof BarrelBlock) {
                pumpkinWarden.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.targetPos));
                pumpkinWarden.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(this.targetPos, 1.0f, 0));
                return;
            }
        }
        if ((optionalBlockPos = this.findHopperOrBarrel(level, pumpkinWarden.m_20183_(), 20.0)).isPresent()) {
            this.targetPos = optionalBlockPos.get();
            pumpkinWarden.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.targetPos));
            pumpkinWarden.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(this.targetPos, 1.0f, 0));
        } else {
            if (level.m_213780_().m_188499_()) {
                level.m_7605_((Entity)pumpkinWarden, (byte)13);
            }
            this.stop(level, pumpkinWarden, gameTime);
        }
    }

    private Optional<BlockPos> findHopperOrBarrel(@NotNull ServerLevel level, BlockPos blockPos, double distance) {
        Optional<BlockPos> nearestBarrel = Optional.empty();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int i = 0;
        while ((double)i <= distance) {
            int j = 0;
            while ((double)j < distance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        mutableBlockPos.m_122154_((Vec3i)blockPos, k, i - 1, l);
                        if (blockPos.m_123314_((Vec3i)mutableBlockPos, distance) && level.m_8055_((BlockPos)mutableBlockPos).m_60734_() instanceof HopperBlock) {
                            return Optional.of(mutableBlockPos.m_7949_());
                        }
                        if (nearestBarrel.isEmpty() && level.m_8055_((BlockPos)mutableBlockPos).m_60734_() instanceof BarrelBlock) {
                            nearestBarrel = Optional.of(mutableBlockPos.m_7949_());
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return nearestBarrel;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden) {
        return pumpkinWarden.canMove() && !pumpkinWarden.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && level.m_46461_();
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        return this.checkExtraStartConditions(level, pumpkinWarden);
    }

    protected void stop(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        pumpkinWarden.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        pumpkinWarden.m_6274_().m_21936_(MemoryModuleType.f_26370_);
    }
}

