/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.ai.behavior;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.world.entity.ai.memory.BWGMemoryModuleType;

public class PlayTagWithVillagersAndWardens {
    public static BehaviorControl<PathfinderMob> create() {
        return BehaviorBuilder.create(instance -> instance.group((App)instance.present(BWGMemoryModuleType.VISIBLE_PUMPKIN_WARDENS.get()), (App)instance.present(MemoryModuleType.VISIBLE_VILLAGER_BABIES), (App)instance.absent(MemoryModuleType.WALK_TARGET), (App)instance.registered(MemoryModuleType.LOOK_TARGET), (App)instance.registered(MemoryModuleType.INTERACTION_TARGET)).apply((Applicative)instance, (memoryAccessor, memoryAccessor1, memoryAccessor2, memoryAccessor3, memoryAccessor4) -> (serverLevel, pathfinderMob, l) -> {
            if (serverLevel.getRandom().nextInt(10) != 0) {
                return false;
            }
            ArrayList<LivingEntity> list = new ArrayList<LivingEntity>((Collection)instance.get(memoryAccessor));
            list.addAll((Collection)instance.get(memoryAccessor1));
            Optional<LivingEntity> optional = list.stream().filter(livingEntity -> PlayTagWithVillagersAndWardens.isFriendChasingMe(pathfinderMob, livingEntity)).findAny();
            if (optional.isEmpty()) {
                Optional<LivingEntity> optional2 = PlayTagWithVillagersAndWardens.findSomeoneBeingChased(list);
                if (optional2.isPresent()) {
                    PlayTagWithVillagersAndWardens.chaseKid(memoryAccessor4, memoryAccessor3, memoryAccessor2, optional2.get());
                } else {
                    list.stream().findAny().ifPresent(livingEntity -> PlayTagWithVillagersAndWardens.chaseKid(memoryAccessor4, memoryAccessor3, memoryAccessor2, livingEntity));
                }
                return true;
            }
            for (int i = 0; i < 10; ++i) {
                Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)pathfinderMob, (int)20, (int)8);
                if (vec3 == null || !serverLevel.isVillage(BlockPos.containing((Position)vec3))) continue;
                memoryAccessor2.set((Object)new WalkTarget(vec3, 0.6f, 0));
                break;
            }
            return true;
        }));
    }

    private static void chaseKid(MemoryAccessor<?, LivingEntity> interactionTarget, MemoryAccessor<?, PositionTracker> lookTarget, MemoryAccessor<?, WalkTarget> walkTarget, LivingEntity kid) {
        interactionTarget.set((Object)kid);
        lookTarget.set((Object)new EntityTracker((Entity)kid, true));
        walkTarget.set((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)kid, false), 0.6f, 1));
    }

    private static Optional<LivingEntity> findSomeoneBeingChased(List<LivingEntity> kids) {
        Map<LivingEntity, Integer> map = PlayTagWithVillagersAndWardens.checkHowManyChasersEachFriendHas(kids);
        return map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).filter(entry -> (Integer)entry.getValue() > 0 && (Integer)entry.getValue() <= 5).map(Map.Entry::getKey).findFirst();
    }

    private static Map<LivingEntity, Integer> checkHowManyChasersEachFriendHas(List<LivingEntity> kids) {
        HashMap map = Maps.newHashMap();
        kids.stream().filter(PlayTagWithVillagersAndWardens::isChasingSomeone).forEach(livingEntity -> map.compute(PlayTagWithVillagersAndWardens.whoAreYouChasing(livingEntity), (livingEntityx, integer) -> integer == null ? 1 : integer + 1));
        return map;
    }

    private static LivingEntity whoAreYouChasing(LivingEntity kid) {
        return (LivingEntity)kid.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get();
    }

    private static boolean isChasingSomeone(LivingEntity kid) {
        return kid.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).isPresent();
    }

    private static boolean isFriendChasingMe(LivingEntity entity, LivingEntity kid) {
        return kid.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).filter(livingEntity2 -> livingEntity2 == entity).isPresent();
    }
}

