/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.manowar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.config.configs.BWGMobSpawnConfig;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ManOWar
extends Animal
implements GeoEntity,
Bucketable {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ManOWar.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(ManOWar.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float xBodyRot;
    public float xBodyRotO;
    public float zBodyRot;
    public float zBodyRotO;
    public float tentacleMovement;
    public float oldTentacleMovement;
    public float tentacleAngle;
    public float oldTentacleAngle;
    private float speed;
    private float tentacleSpeed;
    private float rotateSpeed;
    private float tx;
    private float ty;
    private float tz;
    public boolean glowLayer = false;
    private static final TagKey<Biome> DRY_BIOMES = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"is_dry"));
    private static final RawAnimation SWIM_ANIMATION = RawAnimation.begin().thenPlay("animation.man_o_war.swim");
    private static final RawAnimation BEACHED_ANIMATION = RawAnimation.begin().thenPlay("animation.man_o_war.beached");

    public ManOWar(EntityType<? extends ManOWar> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
    }

    public boolean checkSpawnObstruction(LevelReader levelReader) {
        return levelReader.isUnobstructed((Entity)this);
    }

    protected void handleAirSupply(int air) {
        if (this.isAlive() && !this.isInWaterOrBubble()) {
            this.setAirSupply(air - 1);
            if (this.getAirSupply() == -20) {
                this.setAirSupply(0);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.hurtServer(serverLevel, this.damageSources().drown(), 2.0f);
                }
            }
        } else {
            this.setAirSupply(this.getMaxAirSupply());
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.TROPICAL_FISH);
    }

    public void baseTick() {
        int air = this.getAirSupply();
        super.baseTick();
        this.handleAirSupply(air);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public static boolean checkManOWarSpawnRules(EntityType<? extends ManOWar> entity, LevelAccessor world, EntitySpawnReason spawnType, BlockPos pos, RandomSource rand) {
        return BWGMobSpawnConfig.INSTANCE.man_o_war && pos.getY() <= world.getSeaLevel() - 2 && world.getFluidState(pos.below()).is(FluidTags.WATER);
    }

    public int getMaxAirSupply() {
        int base = 6000;
        if (this.level().getBiome(this.blockPosition()).is(DRY_BIOMES)) {
            return base / this.getRandom().nextInt(1, 4);
        }
        return base;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)1.2f).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isBaby()) {
            return Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.mobInteract(player, hand));
        }
        return super.mobInteract(player, hand);
    }

    public void playerTouch(@NotNull Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).hurtServer(serverPlayer.serverLevel(), serverPlayer.damageSources().mobAttack((LivingEntity)this), 1.0f)) {
            RandomSource rand = player.getRandom();
            int i = rand.nextInt(4);
            if (i <= 2) {
                serverPlayer.addEffect(new MobEffectInstance(MobEffects.POISON, 600, 2), (Entity)this);
            } else {
                serverPlayer.addEffect(new MobEffectInstance(MobEffects.POISON, 200), (Entity)this);
            }
            if (serverPlayer.hasEffect(MobEffects.UNLUCK)) {
                serverPlayer.kill(serverPlayer.serverLevel());
            }
        }
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public void travel(@NotNull Vec3 vec3) {
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.0, 1.0));
        this.goalSelector.addGoal(2, (Goal)new ManOWarRandomMovementGoal(this));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
    }

    public void handleEntityEvent(byte b) {
        if (b == 19) {
            this.tentacleMovement = 0.0f;
        } else {
            super.handleEntityEvent(b);
        }
    }

    public void setMovementVector(float f, float g, float h) {
        this.tx = f;
        this.ty = g;
        this.tz = h;
    }

    public boolean hasMovementVector() {
        return this.tx != 0.0f || this.ty != 0.0f || this.tz != 0.0f;
    }

    @NotNull
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        if (spawnReason == EntitySpawnReason.BUCKET) {
            this.setBaby(true);
            return spawnGroupData;
        }
        this.setColor(ManOWar.getRandColor(level.getRandom()));
        return spawnGroupData;
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        ManOWar manOWar = (ManOWar)BWGEntityType.MAN_O_WAR.get().create((Level)serverLevel, EntitySpawnReason.BREEDING);
        manOWar.setColor(ManOWar.getRandColor(serverLevel.getRandom()));
        return manOWar;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)0);
        builder.define(FROM_BUCKET, (Object)false);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putInt("Color", this.getRawColor());
        compoundTag.putBoolean("FromBucket", this.fromBucket());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setColor(compoundTag.getInt("Color"));
        this.setFromBucket(compoundTag.getBoolean("FromBucket"));
    }

    public void aiStep() {
        if (!this.isInWater() && this.onGround() && this.verticalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.setOnGround(false);
            this.hasImpulse = true;
            this.playSound(SoundEvents.SALMON_FLOP, this.getSoundVolume(), this.getVoicePitch());
        }
        super.aiStep();
        this.xBodyRotO = this.xBodyRot;
        this.zBodyRotO = this.zBodyRot;
        this.oldTentacleMovement = this.tentacleMovement;
        this.oldTentacleAngle = this.tentacleAngle;
        this.tentacleMovement += this.tentacleSpeed;
        if ((double)this.tentacleMovement > Math.PI * 2) {
            if (this.level().isClientSide) {
                this.tentacleMovement = (float)Math.PI * 2;
            } else {
                this.tentacleMovement = (float)((double)this.tentacleMovement - Math.PI * 2);
                if (this.random.nextInt(10) == 0) {
                    this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)19);
            }
        }
        if (this.isInWaterOrBubble()) {
            if (this.tentacleMovement < (float)Math.PI) {
                float f = this.tentacleMovement / (float)Math.PI;
                this.tentacleAngle = Mth.sin((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.speed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.speed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.level().isClientSide) {
                this.setDeltaMovement(this.tx * this.speed, this.ty * this.speed, this.tz * this.speed);
            }
            Vec3 vec3 = this.getDeltaMovement();
            double d = vec3.horizontalDistance();
            this.yBodyRot += (-((float)Mth.atan2((double)vec3.x, (double)vec3.z)) * 57.295776f - this.yBodyRot) * 0.1f;
            this.setYRot(this.yBodyRot);
            this.zBodyRot = (float)((double)this.zBodyRot + Math.PI * (double)this.rotateSpeed * 1.5);
            this.xBodyRot += (-((float)Mth.atan2((double)d, (double)vec3.y)) * 57.295776f - this.xBodyRot) * 0.1f;
        } else {
            this.tentacleAngle = Mth.abs((float)Mth.sin((float)this.tentacleMovement)) * (float)Math.PI * 0.25f;
            if (!this.level().isClientSide) {
                double e = this.getDeltaMovement().y;
                if (this.hasEffect(MobEffects.LEVITATION)) {
                    e = 0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1);
                } else if (!this.isNoGravity()) {
                    e -= 0.08;
                }
                this.setDeltaMovement(0.0, e * (double)0.98f, 0.0);
            }
            this.xBodyRot = (float)((double)this.xBodyRot + (double)(-90.0f - this.xBodyRot) * 0.02);
        }
    }

    public void setColor(Colors color) {
        this.setColor((color.ordinal() & 0x7F) << 16);
    }

    public int getRawColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public Colors getColor() {
        return Colors.byIndex(this.getRawColor() >> 16 & 0x7F);
    }

    private static Colors getRandColor(RandomSource rand) {
        return switch (rand.nextInt(5)) {
            case 0 -> Colors.MAGENTA;
            case 1 -> Colors.PURPLE;
            case 2 -> Colors.RAINBOW;
            default -> Colors.BLUE;
        };
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        AnimationController controller = event.getController();
        controller.transitionLength(0);
        controller.setAnimation(this.isInWater() ? SWIM_ANIMATION : BEACHED_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void spawnChildFromBreeding(ServerLevel level, @NotNull Animal animal) {
        int i = level.getRandom().nextIntBetweenInclusive(1, 3);
        for (int j = 0; j < i; ++j) {
            ((ManOWar)animal).setColor(ManOWar.getRandColor(level.getRandom()));
            super.spawnChildFromBreeding(level, animal);
        }
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean pFromBucket) {
        this.entityData.set(FROM_BUCKET, (Object)pFromBucket);
    }

    public void saveToBucketTag(@NotNull ItemStack stack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, compoundTag -> {
            compoundTag.putInt("Variant", this.getRawColor());
            compoundTag.putInt("Age", this.getAge());
        });
    }

    public void loadFromBucketTag(@NotNull CompoundTag tag) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)tag);
        this.setColor(Colors.byIndex(tag.getInt("Variant")));
        if (tag.contains("Age")) {
            this.setAge(tag.getInt("Age"));
        }
    }

    @NotNull
    public ItemStack getBucketItemStack() {
        return BWGItems.MAN_O_WAR_BUCKET.get().getDefaultInstance();
    }

    @NotNull
    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_AXOLOTL;
    }

    public static <T> T makeIndex(T[] array, int index) {
        return array[index >= array.length ? 0 : index];
    }

    private static class ManOWarRandomMovementGoal
    extends Goal {
        private final ManOWar mano;

        private ManOWarRandomMovementGoal(ManOWar mano) {
            this.mano = mano;
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            int i = this.mano.getNoActionTime();
            if (i > 100) {
                this.mano.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.mano.getRandom().nextInt(50) == 0 || !this.mano.wasTouchingWater || !this.mano.hasMovementVector()) {
                float f = this.mano.getRandom().nextFloat() * ((float)Math.PI * 2);
                float g = Mth.cos((float)f) * 0.2f;
                float h = -0.1f + this.mano.getRandom().nextFloat() * 0.2f;
                float j = Mth.sin((float)f) * 0.2f;
                this.mano.setMovementVector(g, h, j);
            }
        }
    }

    public static enum Colors implements StringRepresentable
    {
        BLUE("blue"),
        PURPLE("purple"),
        MAGENTA("magenta"),
        RAINBOW("rainbow");

        private final String name;

        private Colors(String name) {
            this.name = name;
        }

        public static Colors byIndex(int index) {
            return ManOWar.makeIndex(Colors.values(), index);
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

