/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.tree.leaves;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.potionstudios.biomeswevegone.tags.BWGItemTags;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import org.jetbrains.annotations.NotNull;

public class BWGFireCrackerLeaves
extends LeavesBlock {
    public BWGFireCrackerLeaves(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected InteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        RandomSource random = level.getRandom();
        if (stack.is(BWGItemTags.SHEARS) && level.getBlockState(pos.below()).is(BlockTags.DIRT)) {
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            double d = (double)pos.getX() + random.nextDouble();
            double e = (double)pos.getY() + 1.0;
            double f = (double)pos.getZ() + random.nextDouble();
            level.setBlockAndUpdate(pos, BWGBlocks.FIRECRACKER_FLOWER_BUSH.getBlockState());
            level.neighborChanged(pos, BWGBlocks.FIRECRACKER_FLOWER_BUSH.getBlock(), null);
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, d, e, f, 0.0, 0.0, 0.0);
            level.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

