/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.village;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.BWGStructureProcessorLists;
import org.jetbrains.annotations.NotNull;

public class PlaceInVillage {
    private static void addBuildingToPool(@NotNull MinecraftServer server, ResourceLocation poolRL, ResourceKey<StructureProcessorList> processorList, ResourceLocation nbtPieceRL, StructureTemplatePool.Projection projection, int weight) {
        RegistryAccess.Frozen serverRegistry = server.registryAccess();
        Registry templatePoolRegistry = serverRegistry.lookupOrThrow(Registries.TEMPLATE_POOL);
        Registry processorListRegistry = serverRegistry.lookupOrThrow(Registries.PROCESSOR_LIST);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.getValue(poolRL);
        Holder.Reference processorList1 = processorListRegistry.getOrThrow(processorList);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.single((String)nbtPieceRL.toString(), (Holder)processorList1).apply(projection);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }

    public static void addStructuresToVillages(@NotNull MinecraftServer server) {
        PlaceInVillage.addBuildingToPool(server, PlaceInVillage.getMcRL("plains/houses"), BWGStructureProcessorLists.MOSSIFY_10_PERCENT_WHITE_PUFFBALL, BiomesWeveGone.id("minecraft/village/plains/houses/plains_forager_1"), StructureTemplatePool.Projection.RIGID, 2);
        PlaceInVillage.addBuildingToPool(server, PlaceInVillage.getMcRL("taiga/houses"), BWGStructureProcessorLists.MOSSIFY_10_PERCENT_WHITE_PUFFBALL, BiomesWeveGone.id("minecraft/village/taiga/houses/taiga_forager_1"), StructureTemplatePool.Projection.RIGID, 2);
    }

    private static ResourceLocation getMcRL(String poolName) {
        return ResourceLocation.withDefaultNamespace((String)("village/" + poolName));
    }
}

