/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client.renderer.entity.manowar;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.potionstudios.biomeswevegone.client.renderer.entity.manowar.ManOWarModel;
import net.potionstudios.biomeswevegone.world.entity.manowar.ManOWar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class ManOWarRenderer<R extends EntityRenderState>
extends GeoEntityRenderer<ManOWar, R> {
    protected static final DataTicket<Boolean> BABY = DataTicket.create((String)"baby", Boolean.class);
    protected static final DataTicket<String> COLOR = DataTicket.create((String)"color", String.class);
    protected static final DataTicket<Float> xBODY_ROT = DataTicket.create((String)"x_body_rot", Float.class);
    protected static final DataTicket<Float> zBODY_ROT = DataTicket.create((String)"z_body_rot", Float.class);
    protected static final DataTicket<Float> xBODY_ROT_O = DataTicket.create((String)"x_body_rot_o", Float.class);
    protected static final DataTicket<Float> zBODY_ROT_O = DataTicket.create((String)"z_body_rot_o", Float.class);

    public ManOWarRenderer(EntityRendererProvider.Context context) {
        super(context, new ManOWarModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
    }

    public void preRender(R renderState, PoseStack poseStack, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (((Boolean)((GeoRenderState)renderState).getGeckolibData(BABY)).booleanValue()) {
            poseStack.scale(0.5f, 0.5f, 0.5f);
        }
        super.preRender(renderState, poseStack, model, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
    }

    protected void applyRotations(R renderState, PoseStack poseStack, float nativeScale) {
        float i = Mth.lerp((float)((Float)((GeoRenderState)renderState).getGeckolibData(DataTickets.PARTIAL_TICK)).floatValue(), (float)((Float)((GeoRenderState)renderState).getGeckolibData(xBODY_ROT_O)).floatValue(), (float)((Float)((GeoRenderState)renderState).getGeckolibData(xBODY_ROT)).floatValue());
        float j = Mth.lerp((float)((Float)((GeoRenderState)renderState).getGeckolibData(DataTickets.PARTIAL_TICK)).floatValue(), (float)((Float)((GeoRenderState)renderState).getGeckolibData(zBODY_ROT_O)).floatValue(), (float)((Float)((GeoRenderState)renderState).getGeckolibData(zBODY_ROT)).floatValue());
        poseStack.translate(0.0, 0.5, 0.0);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - ((Float)((GeoRenderState)renderState).getGeckolibData(DataTickets.ENTITY_YAW)).floatValue()));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(i));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(j));
        poseStack.translate(0.0, (double)-1.2f, 0.0);
    }

    public void addRenderData(ManOWar animatable, Void relatedObject, R renderState) {
        ((GeoRenderState)renderState).addGeckolibData(BABY, (Object)animatable.isBaby());
        ((GeoRenderState)renderState).addGeckolibData(COLOR, (Object)animatable.getColor().getSerializedName());
        ((GeoRenderState)renderState).addGeckolibData(xBODY_ROT, (Object)Float.valueOf(animatable.xBodyRot));
        ((GeoRenderState)renderState).addGeckolibData(zBODY_ROT, (Object)Float.valueOf(animatable.zBodyRot));
        ((GeoRenderState)renderState).addGeckolibData(xBODY_ROT_O, (Object)Float.valueOf(animatable.xBodyRotO));
        ((GeoRenderState)renderState).addGeckolibData(zBODY_ROT_O, (Object)Float.valueOf(animatable.zBodyRotO));
    }

    protected float getShadowRadius(@NotNull R renderState) {
        return (Boolean)((GeoRenderState)renderState).getGeckolibData(BABY) != false ? 0.5f : 0.8f;
    }
}

