/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.biome;

import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.sand.BWGSandSet;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import net.potionstudios.biomeswevegone.world.level.levelgen.surfacerules.BWGRuleSources;
import net.potionstudios.biomeswevegone.world.level.levelgen.surfacerules.BandsRuleSource;
import net.potionstudios.biomeswevegone.world.level.levelgen.surfacerules.BetweenRepeatingNoiseRange;
import org.jetbrains.annotations.NotNull;

public class BWGOverworldSurfaceRules {
    private static final SurfaceRules.ConditionSource WATER_CHECK = SurfaceRules.waterBlockCheck((int)-1, (int)0);
    private static final SurfaceRules.RuleSource STONE = BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGOverworldSurfaceRules.makeStateRule(Blocks.STONE));
    private static final SurfaceRules.RuleSource GRAVEL = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGOverworldSurfaceRules.makeStateRule(Blocks.GRAVEL)), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGOverworldSurfaceRules.makeStateRule(Blocks.GRAVEL))});
    private static final SurfaceRules.RuleSource PURPLE_SAND = BWGOverworldSurfaceRules.makeSandRule(BWGBlocks.PURPLE_SAND_SET);
    private static final SurfaceRules.RuleSource BLUE_SAND = BWGOverworldSurfaceRules.makeSandRule(BWGBlocks.BLUE_SAND_SET);
    private static final SurfaceRules.RuleSource PINK_SAND = BWGOverworldSurfaceRules.makeSandRule(BWGBlocks.PINK_SAND_SET);
    private static final SurfaceRules.RuleSource BLACK_SAND = BWGOverworldSurfaceRules.makeSandRule(BWGBlocks.BLACK_SAND_SET);
    private static final SurfaceRules.RuleSource WHITE_SAND = BWGOverworldSurfaceRules.makeSandRule(BWGBlocks.WHITE_SAND_SET);
    private static final SurfaceRules.RuleSource WHITE_OVERGROWN_DACITE_DACITE_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.WHITE_OVERGROWN_DACITE.get())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.WHITE_DACITE_SET.getBase())});
    private static final SurfaceRules.RuleSource WHITE_OVERGROWN_PODZOL_DACITE_STONE_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.WHITE_PODZOL_DACITE.get())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.WHITE_DACITE_SET.getBase())});
    private static final SurfaceRules.RuleSource OVERGROWN_DACITE_DACITE_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.OVERGROWN_DACITE.get())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.DACITE_SET.getBase())});
    private static final SurfaceRules.RuleSource OVERGROWN_PODZOL_DACITE_STONE_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.PODZOL_DACITE.get())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.DACITE_SET.getBase())});
    private static final SurfaceRules.RuleSource LUSH_GRASS_LUSH_DIRT_LUSH_DIRT_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.LUSH_GRASS_BLOCK.get())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.LUSH_DIRT.get())});
    private static final SurfaceRules.RuleSource COARSE_DIRT_DIRT_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.COARSE_DIRT), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.DIRT)});
    private static final SurfaceRules.RuleSource SANDY_DIRT_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.SANDY_DIRT.get()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.SANDY_DIRT.get())});
    private static final SurfaceRules.RuleSource NOISE_COARSE_DIRT = BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), COARSE_DIRT_DIRT_SURFACE);
    private static final SurfaceRules.RuleSource PODZOL_DIRT_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.PODZOL)), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.DIRT)});
    private static final SurfaceRules.RuleSource PEAT_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.PEAT.get())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.PEAT.get())});
    private static final SurfaceRules.RuleSource OVERGROWN_STONE_STONE_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.OVERGROWN_STONE.get())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.STONE)});
    private static final SurfaceRules.RuleSource CRACKED_RED_SAND_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_CEILING, Blocks.RED_SANDSTONE), BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.CRACKED_RED_SAND.get())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.RED_SANDSTONE)});
    private static final SurfaceRules.RuleSource CRACKED_SAND_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_CEILING, Blocks.SANDSTONE), BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.CRACKED_SAND.get())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.SANDSTONE)});
    private static final SurfaceRules.RuleSource QUICKSAND_SURFACE = BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.noiseCondition((ResourceKey)Noises.POWDER_SNOW, (double)0.45, (double)0.5), BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGOverworldSurfaceRules.makeStateRule(BWGBlocks.QUICKSAND.get())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGOverworldSurfaceRules.makeStateRule(BWGBlocks.QUICKSAND.get()))})));
    private static final SurfaceRules.RuleSource CRIMSON_ROCKY_STONE_SURFACE = BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.noiseCondition((ResourceKey)Noises.POWDER_SNOW, (double)0.45, (double)0.5), BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGOverworldSurfaceRules.makeStateRule(BWGBlocks.ROCKY_STONE_SET.getBase())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGOverworldSurfaceRules.makeStateRule(BWGBlocks.ROCKY_STONE_SET.getBase()))})));
    private static final SurfaceRules.RuleSource POWDER_SNOW_SURFACE = BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.noiseCondition((ResourceKey)Noises.POWDER_SNOW, (double)0.45, (double)0.5), BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGOverworldSurfaceRules.makeStateRule(Blocks.POWDER_SNOW)), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGOverworldSurfaceRules.makeStateRule(Blocks.POWDER_SNOW))})));
    private static final SurfaceRules.RuleSource RED_QUICKSAND_SURFACE = BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.noiseCondition((ResourceKey)Noises.POWDER_SNOW, (double)0.45, (double)0.5), BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGOverworldSurfaceRules.makeStateRule(BWGBlocks.RED_QUICKSAND.get())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGOverworldSurfaceRules.makeStateRule(BWGBlocks.RED_QUICKSAND.get()))})));
    private static final SurfaceRules.RuleSource RAW_COPPER_SURFACE = BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.noiseCondition((ResourceKey)Noises.POWDER_SNOW, (double)0.45, (double)0.5), BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGOverworldSurfaceRules.makeStateRule(Blocks.RAW_COPPER_BLOCK)), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGOverworldSurfaceRules.makeStateRule(Blocks.RAW_COPPER_BLOCK))})));
    private static final SurfaceRules.RuleSource ROOTED_DIRT_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.ROOTED_DIRT)), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.ROOTED_DIRT)});
    private static final SurfaceRules.RuleSource GRASS_DIRT_DIRT_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.GRASS_BLOCK)), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.DIRT)});
    private static final SurfaceRules.RuleSource MUD_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.MUD)), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.MUD)});
    private static final SurfaceRules.RuleSource PACKED_MUD_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.PACKED_MUD)), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.PACKED_MUD)});
    private static final SurfaceRules.RuleSource SAND_SURFACE = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_CEILING, Blocks.SANDSTONE), BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.SAND)), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.SAND)});
    private static final SurfaceRules.RuleSource SEA_LEVEL_WATER_NOISE = BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)0)), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), Blocks.WATER))));
    private static final SurfaceRules.RuleSource ASPEN_BOREAL = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.ASPEN_BOREAL, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.GRASS_BLOCK), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.DIRT)})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), ROOTED_DIRT_SURFACE), PODZOL_DIRT_SURFACE}));
    private static final SurfaceRules.RuleSource ATACAMA_OUTBACK = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.ATACAMA_OUTBACK, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.RED_SAND), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.RED_SANDSTONE)})), RED_QUICKSAND_SURFACE, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), CRACKED_RED_SAND_SURFACE), CRACKED_RED_SAND_SURFACE}));
    private static final SurfaceRules.RuleSource BAOBAB_SAVANNA = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.BAOBAB_SAVANNA, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.COARSE_DIRT))}));
    private static final SurfaceRules.RuleSource BASALT_BARRERA = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.BASALT_BARRERA, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.BASALT.defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.BASALT.defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)10, (boolean)false, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.BASALT.defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)10, (boolean)false, (CaveSurface)CaveSurface.CEILING), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.BASALT.defaultBlockState()))}));
    private static final SurfaceRules.RuleSource BAYOU = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.BAYOU, SEA_LEVEL_WATER_NOISE);
    private static final SurfaceRules.RuleSource BLACK_FOREST = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.BLACK_FOREST, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{NOISE_COARSE_DIRT, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), PEAT_SURFACE)}));
    private static final SurfaceRules.RuleSource CANADIAN_SHIELD = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.CANADIAN_SHIELD, OVERGROWN_STONE_STONE_SURFACE);
    private static final SurfaceRules.RuleSource CIKA_WOODS = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.CIKA_WOODS, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{NOISE_COARSE_DIRT, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), PODZOL_DIRT_SURFACE)}));
    private static final SurfaceRules.RuleSource COCONINO_MEADOW = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.COCONINO_MEADOW, LUSH_GRASS_LUSH_DIRT_LUSH_DIRT_SURFACE);
    private static final SurfaceRules.RuleSource CONIFEROUS_FOREST = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.CONIFEROUS_FOREST, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{NOISE_COARSE_DIRT, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), PEAT_SURFACE)}));
    private static final SurfaceRules.RuleSource CRIMSON_TUNDRA = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.CRIMSON_TUNDRA, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(WATER_CHECK, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.LUSH_GRASS_BLOCK.get())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.LUSH_DIRT.get())})), CRIMSON_ROCKY_STONE_SURFACE, PEAT_SURFACE}));
    private static final SurfaceRules.RuleSource CYPRESS_MANGROVE = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{BWGBiomes.CYPRESS_SWAMPLANDS, BWGBiomes.WHITE_MANGROVE_MARSHES}), (SurfaceRules.RuleSource)BWGOverworldSurfaceRules.abovePreliminarySurface(SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SEA_LEVEL_WATER_NOISE, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.not((SurfaceRules.ConditionSource)WATER_CHECK), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), Blocks.CLAY), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), Blocks.MUD), SurfaceRules.state((BlockState)BWGBlocks.WHITE_SAND_SET.getSand().defaultBlockState())}))), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.68), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.PEAT.get()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.PEAT.get())})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.77), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.MOSS_BLOCK)), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.GRASS_BLOCK)})})));
    private static final SurfaceRules.RuleSource CYPRESS_WETLANDS = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.CYPRESS_WETLANDS, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.GRASS_BLOCK), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.DIRT)})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), PODZOL_DIRT_SURFACE), PEAT_SURFACE, MUD_SURFACE}));
    private static final SurfaceRules.RuleSource DACITE_RIDGES = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.DACITE_RIDGES, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.COARSE_DIRT), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.DACITE_SET.getBase())})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), OVERGROWN_PODZOL_DACITE_STONE_SURFACE), OVERGROWN_DACITE_DACITE_SURFACE, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.stoneDepthCheck((int)10, (boolean)false, (CaveSurface)CaveSurface.FLOOR), BWGBlocks.DACITE_SET.getBase()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.stoneDepthCheck((int)10, (boolean)false, (CaveSurface)CaveSurface.CEILING), BWGBlocks.DACITE_SET.getBase())}));
    private static final SurfaceRules.RuleSource DACITE_SHORE = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.DACITE_SHORE, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.85), BWGOverworldSurfaceRules.makeStateRule(BWGBlocks.WHITE_DACITE_COBBLESTONE_SET.getBase())), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.WHITE_SAND_SET.getSand()), BWGOverworldSurfaceRules.makeStateRule(BWGBlocks.WHITE_DACITE_SET.getBase())})), BWGOverworldSurfaceRules.makeStateRule(BWGBlocks.WHITE_DACITE_SET.getBase())}));
    private static final SurfaceRules.RuleSource DEAD_SEA = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.DEAD_SEA, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{new BetweenRepeatingNoiseRange((ResourceKey<NormalNoise.NoiseParameters>)Noises.CALCITE, 0.02f, -2.0f, 2.0f, STONE, GRAVEL), STONE}));
    private static final SurfaceRules.RuleSource EBONY_WOODS = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.EBONY_WOODS, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), COARSE_DIRT_DIRT_SURFACE));
    private static final SurfaceRules.RuleSource ENCHANTED_TANGLE = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.ENCHANTED_TANGLE, BWGRuleSources.weightedRuleSource((WeightedList<SurfaceRules.RuleSource>)WeightedList.builder().add((Object)LUSH_GRASS_LUSH_DIRT_LUSH_DIRT_SURFACE, 5).add((Object)PEAT_SURFACE, 3).add((Object)COARSE_DIRT_DIRT_SURFACE, 1).add((Object)MUD_SURFACE, 1).add((Object)PODZOL_DIRT_SURFACE, 2).add((Object)PACKED_MUD_SURFACE, 1).build()));
    private static final SurfaceRules.RuleSource ERODED_BOREALIS = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.ERODED_BOREALIS, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.GRASS_BLOCK), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.DIRT)})), POWDER_SNOW_SURFACE, PEAT_SURFACE}));
    private static final SurfaceRules.RuleSource FORGOTTEN_FOREST = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.FORGOTTEN_FOREST, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.LUSH_GRASS_BLOCK.get()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.LUSH_DIRT.get())})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), NOISE_COARSE_DIRT), PEAT_SURFACE}));
    private static final SurfaceRules.RuleSource FRAGMENT_JUNGLE = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.FRAGMENT_JUNGLE, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.OVERGROWN_STONE.get()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.STONE)})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), PEAT_SURFACE), PODZOL_DIRT_SURFACE}));
    private static final SurfaceRules.RuleSource FROSTED_CONIFEROUS_FOREST = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.CONIFEROUS_FOREST, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{NOISE_COARSE_DIRT, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), PEAT_SURFACE)}));
    private static final SurfaceRules.RuleSource FROSTED_TIAGA = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.FROSTED_TAIGA, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{NOISE_COARSE_DIRT, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), PEAT_SURFACE)}));
    private static final SurfaceRules.RuleSource HOWLING_PEAKS = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.HOWLING_PEAKS, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.GRASS_BLOCK), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.DIRT)})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), PEAT_SURFACE), PODZOL_DIRT_SURFACE}));
    private static final SurfaceRules.RuleSource IRONWOOD_GOUR = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.IRONWOOD_GOUR, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{NOISE_COARSE_DIRT, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), PACKED_MUD_SURFACE)}));
    private static final SurfaceRules.RuleSource JACARANDA_JUNGLE = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.JACARANDA_JUNGLE, BWGRuleSources.weightedRuleSource((WeightedList<SurfaceRules.RuleSource>)WeightedList.builder().add((Object)LUSH_GRASS_LUSH_DIRT_LUSH_DIRT_SURFACE, 5).add((Object)PEAT_SURFACE, 3).add((Object)COARSE_DIRT_DIRT_SURFACE, 1).add((Object)MUD_SURFACE, 1).add((Object)PODZOL_DIRT_SURFACE, 2).add((Object)PACKED_MUD_SURFACE, 1).build()));
    private static final SurfaceRules.RuleSource LUSH_STACKS = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.LUSH_STACKS, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{new BetweenRepeatingNoiseRange((ResourceKey<NormalNoise.NoiseParameters>)Noises.CALCITE, 0.02f, -2.0f, 2.0f, STONE, GRAVEL), STONE}));
    private static final SurfaceRules.RuleSource MOJAVE_DESERT = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.MOJAVE_DESERT, BWGRuleSources.weightedRuleSource((WeightedList<SurfaceRules.RuleSource>)WeightedList.builder().add((Object)SAND_SURFACE, 3).add((Object)SANDY_DIRT_SURFACE, 1).add((Object)CRACKED_SAND_SURFACE, 1).build()));
    private static final SurfaceRules.RuleSource OVERGROWTH_WOODLANDS = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.OVERGROWTH_WOODLANDS, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.MOSS_BLOCK), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.MOSS_BLOCK)})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), PEAT_SURFACE), LUSH_GRASS_LUSH_DIRT_LUSH_DIRT_SURFACE}));
    private static final SurfaceRules.RuleSource PALE_BOG = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.PALE_BOG, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SEA_LEVEL_WATER_NOISE, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.not((SurfaceRules.ConditionSource)WATER_CHECK), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), BWGBlocks.PACKED_PALE_MUD.get()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), BWGBlocks.BLACK_SAND_SET.getSand()), BWGOverworldSurfaceRules.makeStateRule(BWGBlocks.PALE_MUD.get())}))), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.68), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.PEAT.get()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.PALE_MUD.get())})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.77), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.PALE_MOSS_BLOCK)), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.PALE_MUD.get())})}));
    private static final SurfaceRules.RuleSource PUMPKIN_VALLEY = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.PUMPKIN_VALLEY, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.LUSH_GRASS_BLOCK.get()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.LUSH_DIRT.get())})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), LUSH_GRASS_LUSH_DIRT_LUSH_DIRT_SURFACE), PODZOL_DIRT_SURFACE}));
    private static final SurfaceRules.RuleSource RAINBOW_BEACH = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.RAINBOW_BEACH, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{new BetweenRepeatingNoiseRange((ResourceKey<NormalNoise.NoiseParameters>)Noises.CALCITE, 0.02f, -2.0f, 2.0f, PURPLE_SAND, WHITE_SAND, BLACK_SAND, PINK_SAND), BLUE_SAND}));
    private static final SurfaceRules.RuleSource RED_ROCK_PEAKS = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.RED_ROCK_PEAKS, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.RED_ROCK_SET.getBase()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.RED_ROCK_SET.getBase())})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), GRASS_DIRT_DIRT_SURFACE), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.45), RED_QUICKSAND_SURFACE), RAW_COPPER_SURFACE}));
    private static final SurfaceRules.RuleSource RED_ROCK_VALLEY = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.RED_ROCK_VALLEY, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.RED_ROCK_SET.getBase()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.RED_ROCK_SET.getBase())})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), GRASS_DIRT_DIRT_SURFACE), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.75), COARSE_DIRT_DIRT_SURFACE), CRACKED_RED_SAND_SURFACE}));
    private static final SurfaceRules.RuleSource REDWOOD_THICKET = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.REDWOOD_THICKET, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{NOISE_COARSE_DIRT, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), PODZOL_DIRT_SURFACE)}));
    private static final SurfaceRules.RuleSource RUGGED_BADLANDS = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.RUGGED_BADLANDS, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.SAND), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, Blocks.SANDSTONE)})), QUICKSAND_SURFACE, CRACKED_SAND_SURFACE}));
    private static final SurfaceRules.RuleSource SAKURA_GROVE = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.SAKURA_GROVE, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, Blocks.PODZOL))}));
    private static final SurfaceRules.RuleSource SIERRA_BADLANDS = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.SIERRA_BADLANDS, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{NOISE_COARSE_DIRT, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRuleData.surfaceNoiseAbove((double)-0.95)), GRASS_DIRT_DIRT_SURFACE), SurfaceRules.bandlands()}));
    private static final SurfaceRules.RuleSource SKYRIS_VALE = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.SKYRIS_VALE, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.LUSH_GRASS_BLOCK.get()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.LUSH_DIRT.get())})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), WHITE_OVERGROWN_PODZOL_DACITE_STONE_SURFACE), WHITE_OVERGROWN_DACITE_DACITE_SURFACE, BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.stoneDepthCheck((int)10, (boolean)false, (CaveSurface)CaveSurface.FLOOR), BWGBlocks.WHITE_DACITE_SET.getBase()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.stoneDepthCheck((int)10, (boolean)false, (CaveSurface)CaveSurface.CEILING), BWGBlocks.WHITE_DACITE_SET.getBase())}));
    private static final SurfaceRules.RuleSource WEEPING_WITCH_FOREST = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.WEEPING_WITCH_FOREST, SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)1.75), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, BWGBlocks.LUSH_GRASS_BLOCK.get()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, BWGBlocks.LUSH_DIRT.get())})), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRuleData.surfaceNoiseAbove((double)-0.95), NOISE_COARSE_DIRT), PEAT_SURFACE}));
    private static final SurfaceRules.RuleSource BLACK_ICE_BANDS = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.SHATTERED_GLACIER, new BandsRuleSource((WeightedList<BlockState>)WeightedList.builder().add((Object)BWGBlocks.PACKED_BLACK_ICE.get().defaultBlockState(), 3).add((Object)BWGBlocks.BLACK_ICE.get().defaultBlockState(), 1).build(), (IntProvider)UniformInt.of((int)1, (int)5), (IntProvider)UniformInt.of((int)20, (int)40), 1.0f, 10));
    private static final SurfaceRules.RuleSource WINDSWEPT_DESERT = BWGOverworldSurfaceRules.biomeAbovePreliminarySurface(BWGBiomes.WINDSWEPT_DESERT, BWGOverworldSurfaceRules.makeSandRule(BWGBlocks.WINDSWEPT_SAND_SET));

    public static SurfaceRules.RuleSource makeRules() {
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ASPEN_BOREAL, ATACAMA_OUTBACK, BAOBAB_SAVANNA, BASALT_BARRERA, BAYOU, BLACK_FOREST, BLACK_ICE_BANDS, CANADIAN_SHIELD, CIKA_WOODS, COCONINO_MEADOW, CONIFEROUS_FOREST, CYPRESS_MANGROVE, CYPRESS_WETLANDS, CRIMSON_TUNDRA, DACITE_RIDGES, DACITE_SHORE, DEAD_SEA, EBONY_WOODS, ENCHANTED_TANGLE, ERODED_BOREALIS, FORGOTTEN_FOREST, FRAGMENT_JUNGLE, FROSTED_CONIFEROUS_FOREST, FROSTED_TIAGA, HOWLING_PEAKS, IRONWOOD_GOUR, JACARANDA_JUNGLE, LUSH_STACKS, MOJAVE_DESERT, OVERGROWTH_WOODLANDS, PALE_BOG, PUMPKIN_VALLEY, RAINBOW_BEACH, RED_ROCK_PEAKS, RED_ROCK_VALLEY, REDWOOD_THICKET, RUGGED_BADLANDS, SAKURA_GROVE, SIERRA_BADLANDS, SKYRIS_VALE, WEEPING_WITCH_FOREST, WINDSWEPT_DESERT});
    }

    private static SurfaceRules.RuleSource makeSandRule(@NotNull BWGSandSet sandSet) {
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.ON_FLOOR, sandSet.getSand()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.UNDER_FLOOR, sandSet.getSand()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.stoneDepthCheck((int)10, (boolean)false, (CaveSurface)CaveSurface.FLOOR), sandSet.getSandstone()), BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.stoneDepthCheck((int)10, (boolean)false, (CaveSurface)CaveSurface.CEILING), sandSet.getSandstone())});
    }

    private static <B extends Block> SurfaceRules.RuleSource makeStateRule(B block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }

    private static SurfaceRules.RuleSource makeifTrueRule(ResourceKey<Biome> biome, SurfaceRules.RuleSource rule) {
        return BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biome}), rule);
    }

    private static <B extends Block> SurfaceRules.RuleSource makeifTrueRule(SurfaceRules.ConditionSource conditionSource, B block) {
        return BWGOverworldSurfaceRules.makeifTrueRule(conditionSource, BWGOverworldSurfaceRules.makeStateRule(block));
    }

    private static SurfaceRules.RuleSource makeifTrueRule(SurfaceRules.ConditionSource ifTrue, SurfaceRules.RuleSource thenRun) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)ifTrue, (SurfaceRules.RuleSource)thenRun);
    }

    private static SurfaceRules.RuleSource abovePreliminarySurface(SurfaceRules.RuleSource rule) {
        return BWGOverworldSurfaceRules.makeifTrueRule(SurfaceRules.abovePreliminarySurface(), rule);
    }

    private static SurfaceRules.RuleSource biomeAbovePreliminarySurface(ResourceKey<Biome> biome, SurfaceRules.RuleSource rule) {
        return BWGOverworldSurfaceRules.makeifTrueRule(biome, BWGOverworldSurfaceRules.abovePreliminarySurface(rule));
    }
}

