/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import corgitaco.corgilib.world.level.RandomTickScheduler;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.potionstudios.biomeswevegone.util.BWGUtil;
import net.potionstudios.biomeswevegone.util.UnsafeBoundingBox;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructurePieceTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;

public class LargeLakePiece
extends StructurePiece {
    private final BlockPos origin;
    private final int radius;
    private final int lakeDepth;
    private final HolderSet<PlacedFeature> lakeFeatures;

    protected LargeLakePiece(BlockPos origin, int radius, int lakeDepth, BoundingBox boundingBox, HolderSet<PlacedFeature> lakeFeatures) {
        super(BWGStructurePieceTypes.LARGE_LAKE.get(), 0, boundingBox);
        this.origin = origin;
        this.radius = radius;
        this.lakeDepth = lakeDepth;
        this.lakeFeatures = lakeFeatures;
    }

    public LargeLakePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(BWGStructurePieceTypes.LARGE_LAKE.get(), tag);
        this.origin = BWGUtil.readBlockPos(tag, "origin").orElseThrow();
        this.radius = tag.getIntOr("radius", 0);
        this.lakeDepth = tag.getIntOr("lakeDepth", 0);
        RegistryOps tagRegistryOps = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)context.registryAccess());
        this.lakeFeatures = (HolderSet)((Pair)PlacedFeature.LIST_CODEC.decode((DynamicOps)tagRegistryOps, (Object)tag.get("lake_features")).getOrThrow()).getFirst();
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.put("origin", BWGUtil.writeBlockPos(this.origin));
        tag.putInt("radius", this.radius);
        tag.putInt("lakeDepth", this.lakeDepth);
        RegistryOps tagRegistryOps = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)context.registryAccess());
        tag.put("lake_features", (Tag)PlacedFeature.LIST_CODEC.encodeStart((DynamicOps)tagRegistryOps, this.lakeFeatures).result().orElseThrow());
    }

    public void postProcess(WorldGenLevel worldGenLevel, @NotNull StructureManager structureManager, @NotNull ChunkGenerator generator, @NotNull RandomSource random, @NotNull BoundingBox box, ChunkPos chunkPos, @NotNull BlockPos pos) {
        ImprovedNoise noiseSampler = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(worldGenLevel.getSeed()));
        UnsafeBoundingBox unsafeBoundingBox = new UnsafeBoundingBox();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        ChunkAccess chunk = worldGenLevel.getChunk(chunkPos.x, chunkPos.z);
        boolean[] placedWater = new boolean[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int blockX = chunkPos.getBlockX(x);
                int blockZ = chunkPos.getBlockZ(z);
                mutableBlockPos.set(blockX, 0, blockZ);
                NoiseProvider stateProvider = new NoiseProvider(worldGenLevel.getSeed(), (NormalNoise.NoiseParameters)((Registry)worldGenLevel.registryAccess().lookup(Registries.NOISE).orElseThrow()).getOrThrow(Noises.BADLANDS_SURFACE).value(), 0.5f, List.of(Blocks.GRAVEL.defaultBlockState(), Blocks.MUD.defaultBlockState(), Blocks.CLAY.defaultBlockState()));
                int worldSurfaceY = worldGenLevel.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, blockX, blockZ);
                double radiusFrequency = 0.05;
                double noise = noiseSampler.noise((double)blockX * radiusFrequency, 0.0, (double)blockZ * radiusFrequency) + 1.0;
                double localRadius = (int)Mth.clampedLerp((double)((double)this.radius * 0.5), (double)this.radius, (double)(noise * 0.5));
                int blendWidth = 43;
                int rimSize = (int)(localRadius * 0.05);
                int fluidDepth = 1;
                BlockState[] topBlocks = LargeLakePiece.getSurfaceBlocks(mutableBlockPos, blockX, blockZ, worldSurfaceY, chunk);
                this.blendTerrainChecked(mutableBlockPos, localRadius, blendWidth, worldSurfaceY, blockX, blockZ, chunk, topBlocks, unsafeBoundingBox);
                placedWater[x + z * 16] = this.buildLakeChecked(worldGenLevel, random, mutableBlockPos, localRadius, blendWidth, rimSize, noiseSampler, fluidDepth, blockX, blockZ, chunk, (BlockStateProvider)stateProvider, topBlocks, unsafeBoundingBox);
            }
        }
        if (unsafeBoundingBox.valid()) {
            this.boundingBox = unsafeBoundingBox.toBoundingBox();
        }
        SectionPos sectionPos = SectionPos.of((ChunkPos)chunkPos, (int)worldGenLevel.getMinSectionY());
        BlockPos blockPos = sectionPos.origin();
        Predicate<BlockPos> test = blockPos1 -> {
            int localX = blockPos1.getX() & 0xF;
            int localZ = blockPos1.getZ() & 0xF;
            return placedWater[localX + localZ * 16];
        };
        for (Holder lakeFeature : this.lakeFeatures) {
            this.placeWithContext(new PlacementContext(worldGenLevel, generator, Optional.empty()), random, blockPos, (PlacedFeature)lakeFeature.value(), test);
        }
    }

    private boolean placeWithContext(PlacementContext context, RandomSource source, BlockPos pos, PlacedFeature feature, Predicate<BlockPos> placingPos) {
        Stream<Object> stream = Stream.of(pos);
        for (PlacementModifier placementModifier : feature.placement()) {
            stream = stream.flatMap(blockPos -> placementModifier.getPositions(context, source, blockPos));
        }
        ConfiguredFeature configuredFeature = (ConfiguredFeature)feature.feature().value();
        MutableBoolean mutableBoolean = new MutableBoolean();
        stream.forEach(blockPos -> {
            if (placingPos.test((BlockPos)blockPos) && configuredFeature.place(context.getLevel(), context.generator(), source, blockPos)) {
                mutableBoolean.setTrue();
            }
        });
        return mutableBoolean.isTrue();
    }

    private boolean buildLakeChecked(WorldGenLevel worldGenLevel, RandomSource random, BlockPos.MutableBlockPos mutableBlockPos, double localRadius, int blendWidth, int rimSize, ImprovedNoise noiseSampler, int waterLevel, int blockX, int blockZ, ChunkAccess chunk, BlockStateProvider stateProvider, BlockState[] topBlocks, UnsafeBoundingBox unsafeBoundingBox) {
        if (mutableBlockPos.setY(this.origin.getY()).closerThan((Vec3i)this.origin, localRadius - (double)blendWidth - (double)rimSize)) {
            return this.buildLake(worldGenLevel, random, localRadius, blendWidth, rimSize, mutableBlockPos, noiseSampler, waterLevel, blockX, blockZ, chunk, stateProvider, topBlocks, unsafeBoundingBox);
        }
        return false;
    }

    private boolean buildLake(WorldGenLevel worldGenLevel, RandomSource random, double localRadius, int blendWidth, int rimSize, BlockPos.MutableBlockPos mutableBlockPos, ImprovedNoise noiseSampler, int fluidLevel, int blockX, int blockZ, ChunkAccess chunk, BlockStateProvider stateProvider, BlockState[] topBlocks, UnsafeBoundingBox unsafeBoundingBox) {
        boolean placedWater = false;
        double offset = localRadius - (double)blendWidth - (double)rimSize;
        double delta = (mutableBlockPos.setY(this.origin.getY()).distSqr((Vec3i)this.origin) - Mth.square((double)offset)) / Mth.square((double)(localRadius - offset));
        float frequency = 0.05f;
        double depthNoise = (noiseSampler.noise((double)((float)(mutableBlockPos.getX() + 100000) * frequency), 0.0, (double)((float)(mutableBlockPos.getZ() + 100000) * frequency)) + 1.0) * 0.5;
        double depthOffset = Mth.clampedLerp((double)0.0, (double)10.0, (double)depthNoise);
        int minGenY = this.origin.getY() - this.lakeDepth;
        int waterGenY = this.origin.getY() - fluidLevel;
        int depth = (int)Mth.clampedLerp((double)this.origin.getY(), (double)((double)minGenY - depthOffset), (double)(-delta));
        for (int y = this.origin.getY(); y >= depth - 1; --y) {
            mutableBlockPos.set(blockX, y, blockZ);
            if (y == depth - 1) {
                chunk.setBlockState((BlockPos)mutableBlockPos, Blocks.STONE.defaultBlockState());
            } else if (y <= depth + 3) {
                if (y < waterGenY) {
                    chunk.setBlockState((BlockPos)mutableBlockPos, stateProvider.getState(random, (BlockPos)mutableBlockPos));
                } else {
                    chunk.setBlockState((BlockPos)mutableBlockPos, topBlocks[Math.min(this.origin.getY() - y, topBlocks.length - 1)]);
                    ((RandomTickScheduler)chunk).scheduleRandomTick(mutableBlockPos.immutable());
                    chunk.markPosForPostprocessing((BlockPos)mutableBlockPos);
                }
            } else if (y > waterGenY) {
                chunk.setBlockState((BlockPos)mutableBlockPos, Blocks.AIR.defaultBlockState());
            } else {
                placedWater = true;
                chunk.setBlockState((BlockPos)mutableBlockPos, Blocks.WATER.defaultBlockState());
                worldGenLevel.scheduleTick(mutableBlockPos.immutable(), (Fluid)Fluids.WATER, 0);
            }
            unsafeBoundingBox.encapsulate((Vec3i)mutableBlockPos);
        }
        return placedWater;
    }

    private void blendTerrainChecked(BlockPos.MutableBlockPos mutableBlockPos, double localRadius, int blendWidth, int worldSurfaceY, int blockX, int blockZ, ChunkAccess chunk, BlockState[] topBlocks, UnsafeBoundingBox unsafeBoundingBox) {
        if (mutableBlockPos.setY(this.origin.getY()).closerThan((Vec3i)this.origin, localRadius)) {
            this.blendTerrain(localRadius, blendWidth, mutableBlockPos, worldSurfaceY, blockX, blockZ, chunk, topBlocks, unsafeBoundingBox);
        }
    }

    private void blendTerrain(double localRadius, int blendWidth, BlockPos.MutableBlockPos mutableBlockPos, int worldSurfaceY, int blockX, int blockZ, ChunkAccess chunk, BlockState[] topBlocks, UnsafeBoundingBox unsafeBoundingBox) {
        int y;
        double offset = localRadius - (double)blendWidth;
        double delta = (mutableBlockPos.setY(this.origin.getY()).distSqr((Vec3i)this.origin) - Mth.square((double)offset)) / Mth.square((double)(localRadius - offset));
        int height = (int)Mth.clampedLerp((double)this.origin.getY(), (double)worldSurfaceY, (double)delta);
        if (this.origin.getY() >= worldSurfaceY) {
            for (y = worldSurfaceY; y <= height; ++y) {
                mutableBlockPos.set(blockX, y, blockZ);
                chunk.setBlockState((BlockPos)mutableBlockPos, topBlocks[topBlocks.length - 1]);
                unsafeBoundingBox.encapsulate((Vec3i)mutableBlockPos);
            }
        } else {
            for (y = worldSurfaceY; y > height; --y) {
                mutableBlockPos.set(blockX, y, blockZ);
                chunk.setBlockState((BlockPos)mutableBlockPos, Blocks.AIR.defaultBlockState());
                unsafeBoundingBox.encapsulate((Vec3i)mutableBlockPos);
            }
        }
        for (y = 0; y < topBlocks.length; ++y) {
            mutableBlockPos.set(blockX, height - y, blockZ);
            chunk.setBlockState((BlockPos)mutableBlockPos, topBlocks[y]);
            ((RandomTickScheduler)chunk).scheduleRandomTick(mutableBlockPos.immutable());
            chunk.markPosForPostprocessing((BlockPos)mutableBlockPos);
        }
    }

    private static BlockState @NotNull [] getSurfaceBlocks(BlockPos.MutableBlockPos mutableBlockPos, int blockX, int blockZ, int worldSurfaceY, ChunkAccess chunk) {
        BlockState[] topBlocks = new BlockState[]{Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.STONE.defaultBlockState(), Blocks.STONE.defaultBlockState()};
        for (int y = 0; y < topBlocks.length; ++y) {
            mutableBlockPos.set(blockX, worldSurfaceY - y, blockZ);
            BlockState blockState = chunk.getBlockState((BlockPos)mutableBlockPos);
            if (blockState.isAir() || !blockState.getFluidState().isEmpty()) continue;
            topBlocks[y] = blockState;
        }
        return topBlocks;
    }
}

