/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.plateau;

import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseThresholdProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructurePieceTypes;
import org.jetbrains.annotations.NotNull;

public class GourPlateauPiece
extends StructurePiece {
    private final BlockPos origin;
    private final int radius;
    private final int topY;

    protected GourPlateauPiece(BlockPos origin, int radius, int topY, BoundingBox boundingBox) {
        super(BWGStructurePieceTypes.GOUR_PLATEAU_PIECE.get(), 0, boundingBox);
        this.origin = origin;
        this.radius = radius;
        this.topY = topY;
    }

    public GourPlateauPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(BWGStructurePieceTypes.GOUR_PLATEAU_PIECE.get(), tag);
        this.origin = (BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"origin").orElseThrow();
        this.radius = tag.getInt("radius");
        this.topY = tag.getInt("topY");
    }

    protected void addAdditionalSaveData(@NotNull StructurePieceSerializationContext context, CompoundTag tag) {
        tag.put("origin", NbtUtils.writeBlockPos((BlockPos)this.origin));
        tag.putInt("radius", this.radius);
        tag.putInt("topY", this.topY);
    }

    public void postProcess(WorldGenLevel worldGenLevel, @NotNull StructureManager structureManager, @NotNull ChunkGenerator generator, @NotNull RandomSource random, @NotNull BoundingBox box, @NotNull ChunkPos chunkPos, @NotNull BlockPos pos) {
        int blockZ;
        int blockX;
        int z;
        int x;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        XoroshiroRandomSource randomSource = new XoroshiroRandomSource(worldGenLevel.getSeed() + this.origin.asLong());
        ImprovedNoise noiseSampler = new ImprovedNoise((RandomSource)randomSource);
        SimplexNoise simplexNoise = new SimplexNoise((RandomSource)randomSource);
        double minRadius = (double)this.radius * 0.175;
        int plateauThickness = randomSource.nextIntBetweenInclusive(0, 2);
        int plateauSurfacePull = randomSource.nextIntBetweenInclusive(1, 3);
        int[] topYs = new int[256];
        int[] bottomYs = new int[256];
        Arrays.fill(topYs, Integer.MIN_VALUE);
        Arrays.fill(bottomYs, Integer.MAX_VALUE);
        NoiseThresholdProvider noiseBasedStateProvider = new NoiseThresholdProvider(worldGenLevel.getSeed() + this.origin.asLong(), new NormalNoise.NoiseParameters(0, 1.0, new double[0]), 0.05f, -0.1f, 0.5f, Blocks.GRANITE.defaultBlockState(), List.of(Blocks.PACKED_MUD.defaultBlockState()), List.of(Blocks.COARSE_DIRT.defaultBlockState()));
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                blockX = chunkPos.getBlockX(x);
                blockZ = chunkPos.getBlockZ(z);
                int range = this.topY - this.origin.getY();
                mutable.set(blockX, 0, blockZ);
                double noise = noiseSampler.noise((double)blockX * 0.05, 0.0, (double)blockZ * 0.05) + 1.0;
                int minY = Math.min(worldGenLevel.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, blockX, blockZ) - 1, this.origin.getY());
                int idx = x + z * 16;
                this.buildColumn(worldGenLevel, minRadius, minY, this.topY - minY, mutable, blockX, blockZ, noise, topYs, bottomYs, idx, (RandomSource)randomSource, (BlockStateProvider)noiseBasedStateProvider);
                this.thickenPlateau(worldGenLevel, minRadius, mutable, blockX, range, blockZ, noise, plateauThickness, topYs, bottomYs, idx, (RandomSource)randomSource, (BlockStateProvider)noiseBasedStateProvider);
                this.pullUpPlateau(worldGenLevel, minRadius, range, mutable, blockX, blockZ, noise, plateauThickness, plateauSurfacePull, topYs, bottomYs, idx, (RandomSource)randomSource, (BlockStateProvider)noiseBasedStateProvider);
                this.buildPlateauTerrain(worldGenLevel, minRadius, range, mutable, blockX, blockZ, noise, simplexNoise, plateauThickness, plateauSurfacePull, topYs, bottomYs, idx, (RandomSource)randomSource, (BlockStateProvider)noiseBasedStateProvider);
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                blockX = chunkPos.getBlockX(x);
                blockZ = chunkPos.getBlockZ(z);
                int idx = x + z * 16;
                int topY = topYs[idx];
                if (topY == Integer.MIN_VALUE) continue;
                mutable.set(blockX, topY, blockZ);
                if (!worldGenLevel.getBlockState((BlockPos)mutable.move(Direction.DOWN)).isAir()) {
                    mutable.move(Direction.UP);
                    worldGenLevel.setBlock((BlockPos)mutable, Blocks.GRASS_BLOCK.defaultBlockState(), 2);
                }
                mutable.move(Direction.DOWN);
                if (worldGenLevel.getBlockState((BlockPos)mutable.move(Direction.DOWN)).isAir()) continue;
                mutable.move(Direction.UP);
                worldGenLevel.setBlock((BlockPos)mutable, Blocks.DIRT.defaultBlockState(), 2);
            }
        }
    }

    private void buildPlateauTerrain(WorldGenLevel worldGenLevel, double minRadius, int range, BlockPos.MutableBlockPos mutable, int blockX, int blockZ, double noise, SimplexNoise simplexNoise, int plateauThickness, int plateauSurfacePull, int[] topYs, int[] bottomYs, int idx, RandomSource randomSource, BlockStateProvider stateProvider) {
        double factor = Mth.clamp((double)((double)(range - 1 - plateauThickness - plateauSurfacePull) / (double)range), (double)0.0, (double)1.0);
        double radiusFactor = Mth.clampedLerp((double)-0.5, (double)1.0, (double)factor);
        mutable.set(blockX, this.origin.getY() + plateauThickness + range + plateauSurfacePull - 1, blockZ);
        double delta = noise * 0.5;
        double amplifiedDelta = Mth.clampedLerp((double)0.2, (double)1.0, (double)BlendingFunction.EaseOutQuint.INSTANCE.apply(delta));
        int localRadius = (int)(BlendingFunction.EaseInCirc.INSTANCE.apply(radiusFactor, minRadius, (double)this.radius) * amplifiedDelta);
        BlockPos offsetOrigin = this.origin.offset(0, plateauThickness + range + plateauSurfacePull, 0);
        if (offsetOrigin.closerThan((Vec3i)mutable, (double)localRadius)) {
            double simplexNoiseValue = simplexNoise.getValue((double)blockX * 0.007, (double)blockZ * 0.007) + 1.0;
            double maxNoiseY = simplexNoiseValue * 2.0;
            double noiseFactor = Mth.clamp((double)(mutable.distSqr((Vec3i)offsetOrigin) / (double)Mth.square((int)localRadius)), (double)0.0, (double)1.0);
            double apply = BlendingFunction.EaseOutCubic.INSTANCE.apply(1.0 - noiseFactor, 0.0, maxNoiseY);
            int noiseY = 0;
            while ((double)noiseY <= apply) {
                mutable.move(Direction.UP);
                worldGenLevel.setBlock((BlockPos)mutable, stateProvider.getState(randomSource, (BlockPos)mutable), 2);
                topYs[idx] = Math.max(mutable.getY(), topYs[idx]);
                bottomYs[idx] = Math.max(mutable.getY(), bottomYs[idx]);
                ++noiseY;
            }
        }
    }

    private void pullUpPlateau(WorldGenLevel worldGenLevel, double minRadius, int range, BlockPos.MutableBlockPos mutable, int blockX, int blockZ, double noise, int plateauThickness, int plateauSurfacePull, int[] topYs, int[] bottomYs, int idx, RandomSource randomSource, BlockStateProvider stateProvider) {
        for (int y = 0; y < plateauSurfacePull; ++y) {
            double factor = Mth.clamp((double)((double)(range - 2 - y) / (double)range), (double)0.0, (double)1.0);
            double radiusFactor = Mth.clampedLerp((double)-0.5, (double)1.0, (double)factor);
            mutable.set(blockX, this.origin.getY() + y + range + plateauThickness, blockZ);
            double delta = noise * 0.5;
            double amplifiedDelta = Mth.clampedLerp((double)0.2, (double)1.0, (double)BlendingFunction.EaseOutQuint.INSTANCE.apply(delta));
            int localRadius = (int)(BlendingFunction.EaseInCirc.INSTANCE.apply(radiusFactor, minRadius, (double)this.radius) * amplifiedDelta);
            if (!this.origin.offset(0, y + range + plateauThickness, 0).closerThan((Vec3i)mutable, (double)localRadius)) continue;
            worldGenLevel.setBlock((BlockPos)mutable, stateProvider.getState(randomSource, (BlockPos)mutable), 2);
            topYs[idx] = Math.max(mutable.getY(), topYs[idx]);
            bottomYs[idx] = Math.max(mutable.getY(), bottomYs[idx]);
            mutable.setY(this.origin.getY());
        }
    }

    private void thickenPlateau(WorldGenLevel worldGenLevel, double minRadius, BlockPos.MutableBlockPos mutable, int blockX, int range, int blockZ, double noise, int plateauThickness, int[] topYs, int[] bottomYs, int idx, RandomSource randomSource, BlockStateProvider stateProvider) {
        double factor = Mth.clamp((double)((double)(range - 1) / (double)range), (double)0.0, (double)1.0);
        double radiusFactor = Mth.clampedLerp((double)-0.5, (double)1.0, (double)factor);
        double delta = noise * 0.5;
        double amplifiedDelta = Mth.clampedLerp((double)0.2, (double)1.0, (double)BlendingFunction.EaseOutQuint.INSTANCE.apply(delta));
        int localRadius = (int)(BlendingFunction.EaseInCirc.INSTANCE.apply(radiusFactor, minRadius, (double)this.radius) * amplifiedDelta);
        for (int y = 0; y < plateauThickness; ++y) {
            mutable.set(blockX, this.origin.getY() + y + range, blockZ);
            if (!this.origin.offset(0, y + range, 0).closerThan((Vec3i)mutable, (double)localRadius)) continue;
            worldGenLevel.setBlock((BlockPos)mutable, stateProvider.getState(randomSource, (BlockPos)mutable), 2);
            topYs[idx] = Math.max(mutable.getY(), topYs[idx]);
            bottomYs[idx] = Math.max(mutable.getY(), bottomYs[idx]);
            mutable.setY(this.origin.getY());
        }
    }

    private void buildColumn(WorldGenLevel worldGenLevel, double minRadius, int minY, int range, BlockPos.MutableBlockPos mutable, int blockX, int blockZ, double noise, int[] topYs, int[] bottomYs, int idx, RandomSource randomSource, BlockStateProvider stateProvider) {
        for (int y = 0; y < range; ++y) {
            double factor = Mth.clamp((double)((double)y / (double)range), (double)0.0, (double)1.0);
            double radiusFactor = Mth.clampedLerp((double)-0.5, (double)1.0, (double)factor);
            mutable.set(blockX, minY + y, blockZ);
            double delta = noise * 0.5;
            double amplifiedDelta = Mth.clampedLerp((double)0.2, (double)1.0, (double)BlendingFunction.EaseOutQuint.INSTANCE.apply(delta));
            int localRadius = (int)(BlendingFunction.EaseInCirc.INSTANCE.apply(radiusFactor, minRadius, (double)this.radius) * amplifiedDelta);
            if (!this.origin.atY(minY).offset(0, y, 0).closerThan((Vec3i)mutable, (double)localRadius)) continue;
            worldGenLevel.setBlock((BlockPos)mutable, stateProvider.getState(randomSource, (BlockPos)mutable), 2);
            topYs[idx] = Math.max(mutable.getY(), topYs[idx]);
            bottomYs[idx] = Math.max(mutable.getY(), bottomYs[idx]);
            mutable.setY(minY);
        }
    }
}

