/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.potionstudios.biomeswevegone.BiomesWeveGone;

public class PlacedFeaturesUtil {
    public static final Map<ResourceKey<PlacedFeature>, PlacedFeatureFactory> PLACED_FEATURE_FACTORIES = new Reference2ObjectOpenHashMap();
    private static final NoiseThresholdCountPlacement CLEARING_NOISE = NoiseThresholdCountPlacement.of((double)0.545, (int)1, (int)0);

    protected static Supplier<List<PlacementModifier>> clearingTreePlacement(PlacementModifier placementModifier) {
        ArrayList<NoiseThresholdCountPlacement> placementModifiers = new ArrayList<NoiseThresholdCountPlacement>(VegetationPlacements.treePlacement((PlacementModifier)placementModifier));
        placementModifiers.add(CLEARING_NOISE);
        return () -> placementModifiers;
    }

    public static Supplier<List<PlacementModifier>> treePlacementBaseOceanFloor(PlacementModifier ... $$0) {
        return PlacedFeaturesUtil.treePlacementBaseOceanFloor(OptionalInt.empty(), $$0);
    }

    public static Supplier<List<PlacementModifier>> treePlacementBaseOceanFloor(OptionalInt maxDepth, PlacementModifier ... $$0) {
        ImmutableList.Builder placementModifierBuilder = ImmutableList.builder().add((Object[])$$0).add((Object)InSquarePlacement.spread()).add((Object)PlacementUtils.HEIGHTMAP_TOP_SOLID).add((Object)BiomeFilter.biome());
        if (maxDepth.isPresent()) {
            placementModifierBuilder.add((Object)SurfaceWaterDepthFilter.forMaxDepth((int)maxDepth.getAsInt()));
        }
        return () -> ((ImmutableList.Builder)placementModifierBuilder).build();
    }

    public static Supplier<List<PlacementModifier>> oceanFloorSquaredWithCount(int $$0, PlacementModifier ... modifiers) {
        return PlacedFeaturesUtil.oceanFloorSquaredWithCountAndMaxDepth($$0, OptionalInt.empty(), modifiers);
    }

    public static Supplier<List<PlacementModifier>> oceanFloorSquaredWithCountAndMaxDepth(int $$0, OptionalInt maxDepth, PlacementModifier ... modifiers) {
        ArrayList<BiomeFilter> placementModifiers = new ArrayList<BiomeFilter>(List.of(CountPlacement.of((int)$$0), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome()));
        if (maxDepth.isPresent()) {
            placementModifiers.add((BiomeFilter)SurfaceWaterDepthFilter.forMaxDepth((int)maxDepth.getAsInt()));
        }
        placementModifiers.addAll(Arrays.asList(modifiers));
        return () -> placementModifiers;
    }

    public static <FC extends FeatureConfiguration> Holder<PlacedFeature> createPlacedFeatureDirect(Holder<ConfiguredFeature<?, ?>> feature, PlacementModifier ... placementModifiers) {
        return PlacedFeaturesUtil.createPlacedFeatureDirect(feature, List.of(placementModifiers));
    }

    public static <FC extends FeatureConfiguration> Holder<PlacedFeature> createPlacedFeatureDirect(Holder<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placementModifiers) {
        return Holder.direct((Object)new PlacedFeature(feature, placementModifiers));
    }

    protected static <FC extends FeatureConfiguration> ResourceKey<PlacedFeature> createPlacedFeature(String id, ResourceKey<ConfiguredFeature<?, ?>> feature, Supplier<List<PlacementModifier>> placementModifiers) {
        ResourceKey<PlacedFeature> placedFeatureKey = PlacedFeaturesUtil.registerKey(id);
        PLACED_FEATURE_FACTORIES.put(placedFeatureKey, configuredFeatureHolderGetter -> new PlacedFeature((Holder)configuredFeatureHolderGetter.getOrThrow(feature), (List)placementModifiers.get()));
        return placedFeatureKey;
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return BiomesWeveGone.key(Registries.PLACED_FEATURE, name);
    }

    @FunctionalInterface
    public static interface PlacedFeatureFactory {
        public PlacedFeature generate(HolderGetter<ConfiguredFeature<?, ?>> var1);
    }
}

