/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseBasedStateProvider;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.stateproviders.BWGStateProviders;
import org.jetbrains.annotations.NotNull;

public class BetweenNoiseThresholdProvider
extends NoiseBasedStateProvider {
    public static final MapCodec<BetweenNoiseThresholdProvider> CODEC = RecordCodecBuilder.mapCodec(builder -> BetweenNoiseThresholdProvider.noiseCodec((RecordCodecBuilder.Instance)builder).and(builder.group((App)FloatProvider.CODEC.listOf().fieldOf("thresholds").forGetter(stateProvider -> stateProvider.thresholds), (App)BlockStateProvider.CODEC.fieldOf("within_noise_state_provider").forGetter(stateProvider -> stateProvider.withinNoiseStateProvider), (App)BlockStateProvider.CODEC.fieldOf("outside_noise_state_provider").forGetter(stateProvider -> stateProvider.outsideNoiseStateProvider), (App)Codec.BOOL.fieldOf("use_3d_noise").forGetter(stateprovider -> stateprovider.use3D))).apply((Applicative)builder, BetweenNoiseThresholdProvider::new));
    private final List<FloatProvider> thresholds;
    private final BlockStateProvider withinNoiseStateProvider;
    private final BlockStateProvider outsideNoiseStateProvider;
    private final boolean use3D;

    public BetweenNoiseThresholdProvider(long seed, NormalNoise.NoiseParameters noiseParameters, float scale, List<FloatProvider> thresholds, BlockStateProvider withinNoiseStateProvider, BlockStateProvider outsideNoiseStateProvider, boolean use3D) {
        super(seed, noiseParameters, scale);
        this.thresholds = thresholds;
        this.withinNoiseStateProvider = withinNoiseStateProvider;
        this.outsideNoiseStateProvider = outsideNoiseStateProvider;
        this.use3D = use3D;
    }

    @NotNull
    public BlockState getState(@NotNull RandomSource random, @NotNull BlockPos pos) {
        double noiseValue = this.use3D ? this.getNoiseValue2D(pos, 4.0) : this.getNoiseValue(pos, this.scale);
        for (FloatProvider threshold : this.thresholds) {
            if (!(noiseValue >= (double)threshold.getMinValue()) || !(noiseValue <= (double)threshold.getMaxValue())) continue;
            return this.withinNoiseStateProvider.getState(random, pos);
        }
        return this.outsideNoiseStateProvider.getState(random, pos);
    }

    protected double getNoiseValue2D(BlockPos pos, double v) {
        return this.noise.getValue((double)pos.getX() * v, 0.0, (double)pos.getZ() * v);
    }

    @NotNull
    protected BlockStateProviderType<?> type() {
        return BWGStateProviders.BETWEEN_NOISE_THRESHOLD_PROVIDER.get();
    }

    public static List<FloatProvider> createThresholds(float size, float min, float max) {
        ArrayList<FloatProvider> thresholds = new ArrayList<FloatProvider>();
        for (float start = min; start <= max; start += size * 2.0f) {
            thresholds.add((FloatProvider)UniformFloat.of((float)start, (float)(start + size)));
        }
        return thresholds;
    }
}

