/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client.renderer.entity.manowar;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.potionstudios.biomeswevegone.client.renderer.entity.manowar.ManOWarModel;
import net.potionstudios.biomeswevegone.world.entity.manowar.ManOWar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class ManOWarRenderer<T extends ManOWar>
extends GeoEntityRenderer<T> {
    public ManOWarRenderer(EntityRendererProvider.Context context) {
        super(context, new ManOWarModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (animatable.isBaby()) {
            poseStack.scale(0.5f, 0.5f, 0.5f);
        }
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        float i = Mth.lerp((float)partialTick, (float)((ManOWar)((Object)animatable)).xBodyRotO, (float)((ManOWar)((Object)animatable)).xBodyRot);
        float j = Mth.lerp((float)partialTick, (float)((ManOWar)((Object)animatable)).zBodyRotO, (float)((ManOWar)((Object)animatable)).zBodyRot);
        poseStack.translate(0.0, 0.5, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(i));
        poseStack.mulPose(Axis.YP.rotationDegrees(j));
        poseStack.translate(0.0, (double)-1.2f, 0.0);
    }

    protected float getShadowRadius(@NotNull EntityRenderState renderState) {
        if (this.getAnimatable() == null) {
            return 0.8f;
        }
        return ((ManOWar)this.getAnimatable()).isBaby() ? 0.5f : 0.8f;
    }
}

