/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.forge;

import com.google.auto.service.AutoService;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.luckperms.api.LuckPermsProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.forge.world.level.block.BWGForgeFarmLandBlock;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.custom.BWGFarmLandBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import org.jetbrains.annotations.NotNull;

@AutoService(value={PlatformHandler.class})
public final class ForgePlatformHandler
implements PlatformHandler {
    private static final boolean luckPerms = ModList.get().isLoaded("luckperms");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"biomeswevegone");
    private static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"biomeswevegone");
    private static final Map<ResourceKey<?>, DeferredRegister> CACHED = new Reference2ObjectOpenHashMap();

    @Override
    public PlatformHandler.Platform getPlatform() {
        return PlatformHandler.Platform.FORGE;
    }

    @Override
    public Path configPath() {
        return FMLPaths.CONFIGDIR.get().resolve("biomeswevegone");
    }

    @Override
    public boolean hasPermission(@NotNull CommandSourceStack sourceStack, @NotNull String permission) {
        return PlatformHandler.super.hasPermission(sourceStack, permission) || luckPerms && LuckPermsProvider.get().getUserManager().getUser(sourceStack.getPlayer().getUUID()).getCachedData().getPermissionData().checkPermission(permission).asBoolean();
    }

    @Override
    public FlowerPotBlock createPottedBlock(Supplier<? extends Block> block, BlockBehaviour.Properties properties) {
        return new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, block, properties);
    }

    @Override
    public Supplier<MobBucketItem> createMobBucket(Supplier<EntityType<? extends Mob>> entity, Supplier<Fluid> fluid, Supplier<SoundEvent> sound) {
        return () -> new MobBucketItem(entity, fluid, sound, new Item.Properties().stacksTo(1).component(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY).setId(BiomesWeveGone.key(Registries.ITEM, ((EntityType)entity.get()).toShortString() + "_bucket")));
    }

    @Override
    public BWGFarmLandBlock bwgFarmLandBlock(BlockBehaviour.Properties properties, Supplier<Block> dirt) {
        return new BWGForgeFarmLandBlock(properties, dirt);
    }

    @Override
    public WoodType createWoodType(String id, @NotNull BlockSetType setType) {
        return WoodType.register((WoodType)new WoodType("biomeswevegone:" + id, setType));
    }

    @Override
    public Supplier<SimpleParticleType> registerCreateParticle(String name) {
        return PARTICLES.register(name, () -> new SimpleParticleType(false));
    }

    @Override
    @SafeVarargs
    public final Supplier<CreativeModeTab> createCreativeTab(String name, Supplier<ItemStack> icon, ArrayList<Supplier<? extends Item>> ... items) {
        return this.register(BuiltInRegistries.CREATIVE_MODE_TAB, name, () -> CreativeModeTab.builder().title((Component)Component.translatable((String)("itemGroup.biomeswevegone." + name))).icon(icon).displayItems((context, entries) -> {
            for (ArrayList item : items) {
                item.forEach(item1 -> entries.accept((ItemLike)item1.get()));
            }
        }).withSearchBar().build());
    }

    @Override
    public <T> Supplier<T> register(Registry<? super T> registry, String name, Supplier<T> value) {
        return CACHED.computeIfAbsent(registry.key(), key -> DeferredRegister.create((ResourceLocation)registry.key().location(), (String)"biomeswevegone")).register(name, value);
    }

    @Override
    public <T> Supplier<Holder.Reference<T>> registerForHolder(Registry<T> registry, String name, Supplier<T> value) {
        RegistryObject registryObject = CACHED.computeIfAbsent(registry.key(), key -> DeferredRegister.create((ResourceLocation)registry.key().location(), (String)"biomeswevegone")).register(name, value);
        return () -> (Holder.Reference)registryObject.getHolder().get();
    }

    public static void registerPottedPlants() {
        BWGBlocks.BLOCKS.forEach((Consumer<Supplier<? extends Block>>)((Consumer<Supplier>)entry -> {
            if (entry.get() instanceof FlowerPotBlock) {
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((FlowerPotBlock)entry.get()).getPotted())), entry);
            }
        }));
        BWGWood.WOOD.forEach((Consumer<Supplier<? extends Block>>)((Consumer<Supplier>)entry -> {
            if (entry.get() instanceof FlowerPotBlock) {
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((FlowerPotBlock)entry.get()).getPotted())), entry);
            }
        }));
    }

    public static void register(IEventBus bus) {
        PARTICLES.register(bus);
        CACHED.values().forEach(deferredRegister -> deferredRegister.register(bus));
        BLOCK_ENTITIES.register(bus);
    }
}

