/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.npc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.potionstudios.biomeswevegone.config.configs.BWGTradesConfig;
import net.potionstudios.biomeswevegone.tags.BWGStructureTags;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGVillagerProfessions;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGVillagerTypes;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.sand.BWGSandSet;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import net.potionstudios.biomeswevegone.world.level.saveddata.maps.BWGMapDecorationTypes;

public class BWGVillagerTrades {
    public static final Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ItemListing>>> TRADES = new HashMap<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ItemListing>>>();
    public static final Int2ObjectMap<List<VillagerTrades.ItemListing>> WANDERING_TRADER_TRADES = new Int2ObjectOpenHashMap();

    public static void makeTrades() {
        if (BWGTradesConfig.INSTANCE.villagerTrades.allowBWGForagerTrades.value().booleanValue()) {
            TRADES.put(BWGVillagerProfessions.FORAGER.get(), BWGVillagerTrades.toIntMap((ImmutableMap<Integer, List<VillagerTrades.ItemListing>>)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)Items.RED_MUSHROOM, 10, 12, 2), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)Items.BROWN_MUSHROOM, 10, 12, 2), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.GREEN_MUSHROOM.get(), 10, 12, 2)), (Object)2, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.WOOD_BLEWIT.get(), 8, 12, 3), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGItems.WHITE_PUFFBALL_CAP.get(), 4, 5, 4, 2, 0.05f), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGItems.WREATH.get(), 1, 2, 8, 2, 0.05f)), (Object)3, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.WHITE_PUFFBALL_SPORES.get(), 4, 5, 4), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGItems.HOLLY_WREATH.get(), 2, 1, 8, 2, 0.05f), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGItems.ROSY_WREATH.get(), 2, 1, 8, 2, 0.05f), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGItems.PETAL_WREATH.get(), 2, 1, 8, 2, 0.05f)), (Object)4, (Object)ImmutableList.of((Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.WITCH_HAZEL_BRANCH.get(), 4, 9, 4, 3, 0.05f), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.WITCH_HAZEL_BLOSSOM.get(), 10, 1, 10, 3, 0.05f)), (Object)5, (Object)ImmutableList.of((Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.SHELF_FUNGI.get(), 3, 9, 4, 4, 0.05f), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)Items.SWEET_BERRIES, 16, 4, 2), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.BLUEBERRIES.get(), 16, 4, 2)))));
        }
        TRADES.put(VillagerProfession.FISHERMAN, BWGVillagerTrades.toIntMap((ImmutableMap<Integer, List<VillagerTrades.ItemListing>>)ImmutableMap.of((Object)5, (Object)ImmutableList.of((Object)new VillagerTrades.EmeraldsForVillagerTypeItem(1, 12, 30, (Map)ImmutableMap.builder().put((Object)BWGVillagerTypes.SKYRIS.get(), (Object)BWGWood.SKYRIS.boatItem().get()).put((Object)BWGVillagerTypes.SALEM.get(), (Object)BWGWood.WITCH_HAZEL.boatItem().get()).build())))));
        if (!BWGTradesConfig.INSTANCE.villagerTrades.enableBWGVanillaProfessionTradeAdditions.value().booleanValue()) {
            return;
        }
        TRADES.put(VillagerProfession.BUTCHER, BWGVillagerTrades.toIntMap((ImmutableMap<Integer, List<VillagerTrades.ItemListing>>)ImmutableMap.of((Object)2, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.BLUEBERRIES.get(), 10, 12, 2)))));
        TRADES.put(VillagerProfession.FARMER, BWGVillagerTrades.toIntMap((ImmutableMap<Integer, List<VillagerTrades.ItemListing>>)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.CATTAIL_SPROUT.get(), 24, 12, 2)), (Object)2, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.BAOBAB_FRUIT.get(), 10, 12, 2), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.GREEN_APPLE.get(), 24, 12, 2), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.ALOE_VERA.get(), 16, 12, 2)), (Object)3, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGItems.YUCCA_FRUIT.get(), 10, 12, 2)))));
        TRADES.put(VillagerProfession.MASON, BWGVillagerTrades.toIntMap((ImmutableMap<Integer, List<VillagerTrades.ItemListing>>)ImmutableMap.of((Object)3, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.ROCKY_STONE_SET.getBase(), 12, 12, 20), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.ROCKY_STONE_SET.getBase(), 1, 1, 12, 10, 0.05f), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.MOSSY_STONE_SET.getBase(), 12, 12, 20), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.MOSSY_STONE_SET.getBase(), 1, 1, 12, 10, 0.05f)), (Object)4, (Object)ImmutableList.of((Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.DACITE_SET.getBase(), 12, 12, 30), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.DACITE_SET.getBase(), 1, 1, 12, 15, 0.05f), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.WHITE_DACITE_SET.getBase(), 12, 12, 30), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.WHITE_DACITE_SET.getBase(), 1, 1, 12, 15, 0.05f), (Object)BWGVillagerTrades.createEmeraldForItemsOffer((ItemLike)BWGBlocks.RED_ROCK_SET.getBase(), 12, 12, 30), (Object)BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.RED_ROCK_SET.getBase(), 1, 1, 12, 15, 0.05f)))));
        TRADES.put(VillagerProfession.CARTOGRAPHER, BWGVillagerTrades.toIntMap((ImmutableMap<Integer, List<VillagerTrades.ItemListing>>)ImmutableMap.of((Object)3, (Object)ImmutableList.of((Object)new VillagerTrades.TreasureMapForEmeralds(12, BWGStructureTags.BOG_TRIALS, "filled_map.bog_trial", (Holder)BWGMapDecorationTypes.BOG_TRIAL.get(), 12, 10)))));
    }

    public static void makeWanderingTrades() {
        ArrayList<VillagerTrades.ItemListing> level1Items = new ArrayList<VillagerTrades.ItemListing>();
        BWGWood.WOOD.stream().filter(item -> item.get() instanceof SaplingBlock).forEach(item -> level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)item.get(), 5, 1, 8, 1, 0.05f)));
        BWGSandSet.getSandSets().forEach(bwgSandSet -> level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)bwgSandSet.getSand(), 1, 8, 8, 1, 0.05f)));
        BWGBlocks.BLOCKS.stream().filter(block -> block.get() instanceof FlowerBlock).forEach(block -> level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)block.get(), 1, 1, 13, 1, 0.05f)));
        level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGItems.TINY_LILY_PADS.get(), 1, 2, 5, 1, 0.05f));
        level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGItems.FLOWERING_TINY_LILY_PADS.get(), 1, 2, 5, 1, 0.05f));
        level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.WEEPING_MILKCAP.get(), 1, 1, 12, 1, 0.05f));
        level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.GREEN_MUSHROOM.get(), 1, 1, 12, 1, 0.05f));
        level1Items.add(BWGVillagerTrades.createItemsForEmeraldsOffer((ItemLike)BWGBlocks.WOOD_BLEWIT.get(), 1, 1, 12, 1, 0.05f));
        WANDERING_TRADER_TRADES.put(1, level1Items);
    }

    private static VillagerTrades.ItemListing createEmeraldForItemsOffer(ItemLike item, int cost, int maxUses, int villagerXp) {
        return new VillagerTrades.EmeraldForItems((ItemLike)item.asItem(), cost, maxUses, villagerXp);
    }

    private static VillagerTrades.ItemListing createItemsForEmeraldsOffer(ItemLike item, int emeraldCost, int numberOfItems, int maxUses, int villagerXp, float priceMultiplier) {
        return new VillagerTrades.ItemsForEmeralds(item.asItem(), emeraldCost, numberOfItems, maxUses, villagerXp, priceMultiplier);
    }

    private static Int2ObjectMap<List<VillagerTrades.ItemListing>> toIntMap(ImmutableMap<Integer, List<VillagerTrades.ItemListing>> map) {
        return new Int2ObjectOpenHashMap(map);
    }
}

