/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector4d;

public class CragFeature
extends Feature<NoneFeatureConfiguration> {
    public CragFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return true;
    }

    public static double getHeight(BlockPos pos, WorldGenLevel worldGenLevel, ImprovedNoise noise, double noiseFreq) {
        int radius = 3;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        double centerHeight = CragFeature.getHexHeight(noise, noiseFreq, mutableBlockPos);
        double lowestHexHeight = Double.MAX_VALUE;
        double highestHexHeight = Double.MAX_VALUE;
        BlockPos toBlend = null;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x == 0 && z == 0) continue;
                mutableBlockPos.setWithOffset((Vec3i)pos, x, 0, z);
                double hexHeight = CragFeature.getHexHeight(noise, noiseFreq, mutableBlockPos);
                if (!(hexHeight < lowestHexHeight)) continue;
                lowestHexHeight = hexHeight;
                toBlend = mutableBlockPos.immutable();
            }
        }
        return Mth.clampedLerp((double)centerHeight, (double)lowestHexHeight, (double)((double)Mth.square((int)radius) / pos.distSqr(toBlend))) / 2.0;
    }

    private static double getHexHeight(ImprovedNoise noise, double noiseFreq, BlockPos.MutableBlockPos mutableBlockPos) {
        Vector4d vector4d = MathUtil.calcHexInfo(new Vector2d((double)mutableBlockPos.getX(), (double)mutableBlockPos.getZ()), 30.0);
        Vector2d hexCenter = new Vector2d((double)mutableBlockPos.getX() - vector4d.x, (double)mutableBlockPos.getZ() - vector4d.y);
        double heightDelta = (noise.noise(hexCenter.x * noiseFreq, 0.0, hexCenter.y * noiseFreq) + 1.0) * 0.5;
        return BlendingFunction.EaseInOutCirc.INSTANCE.apply(heightDelta, 150.0, 250.0);
    }

    public static double random(Vector2d co) {
        return Math.sin(co.dot((Vector2dc)new Vector2d(12.9898, 78.233))) * 43758.546875 % 1.0;
    }
}

