import os

items = [
    "enchanted_golden_apple",
    "golden_apple",
    "golden_carrot",
    "chorus_fruit"
]

# Get the directory where the current script is located
output_folder = os.path.dirname(os.path.realpath(__file__)) + '/'

# Loop through each item and create a JSON-like string file
for item in items:
    # Manually create the JSON structure as a string
    json_content = (
        "{\n"
        '  "parent": "item/smaller_util",\n'
        '  "textures": {\n'
        '    "particle": "minecraft:item/transparent",\n'
        f'    "layer0": "minecraft:item/{item}"\n'
        "  }\n"
        "}\n"
    )
    
    # Create a JSON file with the item name
    file_name = f"{item}.json"
    file_path = output_folder + file_name
    
    # Write the JSON-like string to the file
    with open(file_path, 'w') as f:
        f.write(json_content)
    
    print(f"Created {file_name} in {output_folder}")

print("JSON files creation completed.")
# ChatGPT is so cool