/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.class_10055;
import net.minecraft.class_1792;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.client.BLClientAbstractions;
import net.oxcodsnet.beltborne_lanterns.common.client.BLDebugRender;
import net.oxcodsnet.beltborne_lanterns.common.client.ClientBeltPlayers;
import net.oxcodsnet.beltborne_lanterns.common.client.ReflectUtilBL;
import net.oxcodsnet.beltborne_lanterns.common.client.RenderStatePlayerUuidAccess;
import net.oxcodsnet.beltborne_lanterns.common.client.RenderStateUUIDMap;
import net.oxcodsnet.beltborne_lanterns.common.config.BLConfig;
import net.oxcodsnet.beltborne_lanterns.common.config.BLConfigs;
import net.oxcodsnet.beltborne_lanterns.common.physics.LanternSwingManager;
import org.joml.Quaternionfc;

public class LanternBeltFeatureRenderer
extends class_3887<class_10055, class_591> {
    private static final float MODEL_Y_ROTATION_DEGREES = 180.0f;
    private static boolean UUID_LOOKUP_WARNED = false;

    public LanternBeltFeatureRenderer(class_3883<?, ?> context) {
        super(context);
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, class_10055 state, float limbAngle, float limbDistance) {
        UUID subject;
        block17: {
            subject = null;
            if (state instanceof RenderStatePlayerUuidAccess) {
                RenderStatePlayerUuidAccess acc = (RenderStatePlayerUuidAccess)state;
                subject = acc.bl$getPlayerUuid();
            }
            if (subject == null) {
                subject = RenderStateUUIDMap.get(state);
            }
            try {
                String[] profileFieldCandidates;
                String[] uuidFieldCandidates;
                Class<?> cls = state.getClass();
                for (String name : uuidFieldCandidates = new String[]{"uuid", "profileId", "gameProfileId", "playerUuid"}) {
                    try {
                        UUID u;
                        Field f = ReflectUtilBL.findFieldRecursive(cls, name);
                        f.setAccessible(true);
                        Object v = f.get(state);
                        if (!(v instanceof UUID)) continue;
                        subject = u = (UUID)v;
                        break;
                    }
                    catch (NoSuchFieldException f) {
                        // empty catch block
                    }
                }
                if (subject != null) break block17;
                for (String name : profileFieldCandidates = new String[]{"gameProfile", "profile"}) {
                    try {
                        Field f = ReflectUtilBL.findFieldRecursive(cls, name);
                        f.setAccessible(true);
                        Object v = f.get(state);
                        if (v == null) continue;
                        try {
                            UUID u;
                            Method m = v.getClass().getMethod("getId", new Class[0]);
                            Object id = m.invoke(v, new Object[0]);
                            if (!(id instanceof UUID)) continue;
                            subject = u = (UUID)id;
                            break;
                        }
                        catch (ReflectiveOperationException m) {
                        }
                    }
                    catch (NoSuchFieldException f) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable cls) {
                // empty catch block
            }
        }
        if (subject == null && class_310.method_1551().field_1724 != null) {
            subject = class_310.method_1551().field_1724.method_5667();
            if (!UUID_LOOKUP_WARNED) {
                BLMod.LOGGER.warn("Beltborne Lanterns: falling back to local player UUID in feature renderer; mixin may be needed for this mapping.");
                UUID_LOOKUP_WARNED = true;
            }
        }
        if (subject == null) {
            return;
        }
        class_1792 lampItem = ClientBeltPlayers.getLamp(subject);
        if (lampItem == null) {
            return;
        }
        BLConfig c = BLConfigs.get();
        matrices.method_22903();
        LanternBeltFeatureRenderer.applyModelPart(matrices, ((class_591)this.method_17165()).field_3391);
        float offX = c.fOffsetX();
        float offY = c.fOffsetY();
        float offZ = c.fOffsetZ();
        float pivX = c.fPivotX();
        float pivY = c.fPivotY();
        float pivZ = c.fPivotZ();
        float s = c.fScale();
        matrices.method_46416(offX, offY, offZ);
        if (BLClientAbstractions.isDebugDrawEnabled()) {
            matrices.method_22903();
            matrices.method_46416(pivX, pivY, pivZ);
            BLDebugRender.drawAxesAndAnchor(matrices, vertexConsumers, 0.25f);
            matrices.method_22909();
        }
        matrices.method_46416(pivX, pivY, pivZ);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        matrices.method_22905(s, s, s);
        float dynX = LanternSwingManager.getXDeg(subject);
        float dynZ = LanternSwingManager.getZDeg(subject);
        float baseX = LanternSwingManager.getBaseXDeg(subject);
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(baseX + dynX));
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)c.rotYDeg));
        matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees((float)c.rotZDeg + dynZ));
        matrices.method_46416(-pivX, -pivY, -pivZ);
        class_776 brm = class_310.method_1551().method_1541();
        class_2680 blockState = LampRegistry.getState(lampItem);
        brm.method_3353(blockState, matrices, vertexConsumers, light, class_4608.field_21444);
        matrices.method_22909();
    }

    private static void applyModelPart(class_4587 matrices, class_630 part) {
        part.method_22703(matrices);
    }
}

