/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.datapack;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashSet;
import net.minecraft.class_2960;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.config.BLClientConfig;
import net.oxcodsnet.beltborne_lanterns.common.config.BLLampConfigAccess;

public final class BLRuntimeDataPack {
    private static final String PACK_FOLDER = "beltborne_lanterns_generated";

    private BLRuntimeDataPack() {
    }

    public static boolean writeOrUpdate(MinecraftServer server) {
        try {
            Path datapacksDir = server.method_27050(class_5218.field_24186);
            Path packDir = datapacksDir.resolve(PACK_FOLDER);
            Path meta = packDir.resolve("pack.mcmeta");
            Path lampsTag = packDir.resolve("data/beltborne_lanterns/tags/item/lamps.json");
            LinkedHashSet<String> values = new LinkedHashSet<String>();
            for (BLClientConfig.ExtraLampEntry e : BLLampConfigAccess.get().extraLampLight) {
                class_2960 id;
                if (e == null || e.id == null || (id = class_2960.method_12829((String)e.id)) == null) continue;
                values.add(id.toString());
            }
            String metaJson = "{\n  \"pack\": {\n    \"pack_format\": 61,\n    \"supported_formats\": { \"min_inclusive\": 1, \"max_inclusive\": 999 },\n    \"description\": \"Beltborne Lanterns runtime tags generated from config\"\n  }\n}\n";
            StringBuilder sb = new StringBuilder();
            sb.append("{\n  \"replace\": false,\n  \"values\": [\n");
            boolean first = true;
            for (String v : values) {
                if (!first) {
                    sb.append(",\n");
                }
                sb.append("    \"").append(v).append("\"");
                first = false;
            }
            sb.append("\n  ]\n}\n");
            String lampsJson = sb.toString();
            boolean changed = false;
            Files.createDirectories(lampsTag.getParent(), new FileAttribute[0]);
            if (BLRuntimeDataPack.writeIfChanged(meta, metaJson)) {
                changed = true;
            }
            if (BLRuntimeDataPack.writeIfChanged(lampsTag, lampsJson)) {
                changed = true;
            }
            if (changed) {
                BLMod.LOGGER.info("Runtime datapack written: {} ({} entries)", (Object)packDir.toAbsolutePath(), (Object)values.size());
            } else {
                BLMod.LOGGER.debug("Runtime datapack up-to-date ({} entries)", (Object)values.size());
            }
            return changed;
        }
        catch (Throwable t) {
            BLMod.LOGGER.warn("Failed to write runtime datapack: {}", (Object)t.toString());
            return false;
        }
    }

    private static boolean writeIfChanged(Path file, String content) throws IOException {
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        if (Files.exists(file, new LinkOption[0])) {
            byte[] prev = Files.readAllBytes(file);
            if (Arrays.equals(prev, bytes)) {
                return false;
            }
        } else {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        Files.write(file, bytes, new OpenOption[0]);
        return true;
    }
}

