/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Function;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.client.BLClientAbstractions;

public final class LambDynLightsCompat {
    public static void init() {
        try {
            Class<?> handlerClass = Class.forName("dev.lambdaurora.lambdynlights.api.DynamicLightHandler");
            Class<?> handlersClass = Class.forName("dev.lambdaurora.lambdynlights.api.DynamicLightHandlers");
            Function<class_1657, Integer> luminance = player -> {
                class_1792 lamp = BLClientAbstractions.clientLamp(player);
                return lamp != null ? LampRegistry.getLuminance(lamp) : 0;
            };
            Function<class_1657, Boolean> waterSensitive = player -> false;
            Method makeHandler = handlerClass.getMethod("makeHandler", Function.class, Function.class);
            Object handler = makeHandler.invoke(null, luminance, waterSensitive);
            Method makeLiving = handlerClass.getMethod("makeLivingEntityHandler", handlerClass);
            Object livingHandler = makeLiving.invoke(null, handler);
            Method register = handlersClass.getMethod("registerDynamicLightHandler", class_1299.class, handlerClass);
            register.invoke(null, class_1299.field_6097, livingHandler);
            BLMod.LOGGER.info("Dynamic lights: integrated via LambDynamicLights API (handler)");
        }
        catch (ReflectiveOperationException ignored) {
            try {
                Class<?> lambClass = Class.forName("dev.lambdaurora.lambdynlights.LambDynLights");
                Method get = lambClass.getMethod("get", new Class[0]);
                Object instance = get.invoke(null, new Object[0]);
                Method managerMethod = lambClass.getMethod("entityLightSourceManager", new Class[0]);
                Object manager = managerMethod.invoke(instance, new Object[0]);
                Method eventMethod = manager.getClass().getMethod("onRegisterEvent", new Class[0]);
                Object event = eventMethod.invoke(manager, new Object[0]);
                Class<?> eventClass = Class.forName("dev.yumi.commons.event.Event");
                Class<?> identifierClass = Class.forName("net.minecraft.resources.Identifier");
                Method identifierOf = identifierClass.getMethod("of", String.class, String.class);
                Object identifier = identifierOf.invoke(null, "beltborne_lanterns", "player_lantern");
                Class<?> onRegisterClass = Class.forName("dev.lambdaurora.lambdynlights.api.entity.EntityLightSourceManager$OnRegister");
                Class<?> registerContextClass = Class.forName("dev.lambdaurora.lambdynlights.api.entity.EntityLightSourceManager$RegisterContext");
                Class<?> entityLuminanceClass = Class.forName("dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance");
                Class<?> entityLuminanceTypeClass = Class.forName("dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance$Type");
                Field valueTypeField = entityLuminanceTypeClass.getField("VALUE");
                Object valueType = valueTypeField.get(null);
                Object luminanceProxy = Proxy.newProxyInstance(entityLuminanceClass.getClassLoader(), new Class[]{entityLuminanceClass}, (proxy, method, args) -> {
                    switch (method.getName()) {
                        case "getLuminance": {
                            Object entity = args[1];
                            if (entity instanceof class_1657) {
                                class_1657 player = (class_1657)entity;
                                class_1792 lamp = BLClientAbstractions.clientLamp(player);
                                return lamp != null ? LampRegistry.getLuminance(lamp) : 0;
                            }
                            return 0;
                        }
                        case "type": {
                            return valueType;
                        }
                    }
                    return null;
                });
                Object listener = Proxy.newProxyInstance(onRegisterClass.getClassLoader(), new Class[]{onRegisterClass}, (proxy, method, args) -> {
                    if ("onRegister".equals(method.getName())) {
                        Object context = args[0];
                        Method registerMethod = registerContextClass.getMethod("register", class_1299.class, entityLuminanceClass);
                        registerMethod.invoke(context, class_1299.field_6097, luminanceProxy);
                    }
                    return null;
                });
                Method register = eventClass.getMethod("register", Object.class, Object.class);
                register.invoke(event, identifier, listener);
                BLMod.LOGGER.info("Dynamic lights: integrated via LambDynamicLights API (event)");
            }
            catch (ReflectiveOperationException ignored2) {
                BLMod.LOGGER.debug("Dynamic lights: LambDynamicLights not present; skipping integration");
            }
        }
    }
}

