/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.fabric.client;

import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.LambDynLightsCompat;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.client.BLClientAbstractions;
import net.oxcodsnet.beltborne_lanterns.common.client.ClientBeltPlayers;
import net.oxcodsnet.beltborne_lanterns.common.client.LanternBeltFeatureRenderer;
import net.oxcodsnet.beltborne_lanterns.common.client.LanternClientLogic;
import net.oxcodsnet.beltborne_lanterns.common.client.LanternClientScreens;
import net.oxcodsnet.beltborne_lanterns.common.client.ui.LanternDebugScreen;
import net.oxcodsnet.beltborne_lanterns.common.config.BLClientConfig;
import net.oxcodsnet.beltborne_lanterns.common.config.BLClientConfigAccess;
import net.oxcodsnet.beltborne_lanterns.common.network.BeltSyncPayload;
import net.oxcodsnet.beltborne_lanterns.common.network.LampConfigSyncPayload;
import net.oxcodsnet.beltborne_lanterns.common.network.ToggleLanternPayload;
import net.oxcodsnet.beltborne_lanterns.common.physics.LanternSwingManager;

public final class BLFabricClient
implements ClientModInitializer {
    private static class_304 openConfigKey;
    private static class_304 toggleDebugKey;
    private static class_304 openDebugEditorKey;
    private static class_304 toggleLanternKey;

    public void onInitializeClient() {
        LampRegistry.init();
        BLMod.LOGGER.info("Client initialization started [Fabric]");
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> client.execute(() -> {
            ClientBeltPlayers.clear();
            LanternSwingManager.clearAll();
            LampRegistry.init();
        }));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> class_310.method_1551().execute(() -> {
            ClientBeltPlayers.clear();
            LanternSwingManager.clearAll();
        }));
        ClientPlayNetworking.registerGlobalReceiver(BeltSyncPayload.ID, (payload, context) -> {
            UUID uuid = payload.playerUuid();
            class_1792 lamp = payload.lampId() != null ? (class_1792)class_7923.field_41178.method_63535(payload.lampId()) : null;
            class_310.method_1551().execute(() -> ClientBeltPlayers.setLamp(uuid, lamp));
        });
        ClientPlayNetworking.registerGlobalReceiver(LampConfigSyncPayload.ID, (payload, context) -> {
            class_310 client = class_310.method_1551();
            client.execute(() -> {
                BLClientConfig cliCfg = BLClientConfigAccess.get();
                cliCfg.extraLampLight.clear();
                payload.lamps().forEach((id, lum) -> cliCfg.extraLampLight.add(new BLClientConfig.ExtraLampEntry(id.toString(), (int)lum)));
                BLClientConfigAccess.save();
                LampRegistry.init();
            });
        });
        LivingEntityFeatureRendererRegistrationCallback playerFeatureRendererCallback = (entityType, renderer, helper, context) -> {
            if (entityType == class_1299.field_6097) {
                helper.register((class_3887)new LanternBeltFeatureRenderer((class_3883<?, ?>)renderer));
            }
        };
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((Object)playerFeatureRendererCallback);
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            if (entity instanceof class_1657) {
                LanternSwingManager.removePlayer(entity.method_5667());
            }
        });
        boolean hasLamb = FabricLoader.getInstance().isModLoaded("lambdynlights");
        if (hasLamb) {
            LambDynLightsCompat.init();
        }
        openConfigKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.beltborne_lanterns.open_config", class_3675.class_307.field_1668, 76, "category.beltborne_lanterns"));
        toggleDebugKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.beltborne_lanterns.toggle_debug", class_3675.class_307.field_1668, 75, "category.beltborne_lanterns"));
        openDebugEditorKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.beltborne_lanterns.open_debug", class_3675.class_307.field_1668, 80, "category.beltborne_lanterns"));
        toggleLanternKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.beltborne_lanterns.toggle_lantern", class_3675.class_307.field_1668, 66, "category.beltborne_lanterns"));
        BLClientAbstractions.init(ClientBeltPlayers::getLamp);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (openConfigKey.method_1436() && client.field_1755 == null) {
                client.method_1507(LanternClientScreens.openConfig(client.field_1755));
            }
            if (toggleDebugKey.method_1436() && BLClientConfigAccess.get().debug) {
                BLClientAbstractions.setDebugDrawEnabled(!BLClientAbstractions.isDebugDrawEnabled());
            }
            if (openDebugEditorKey.method_1436() && BLClientConfigAccess.get().debug && client.field_1755 == null) {
                client.method_1507((class_437)new LanternDebugScreen());
            }
            if (toggleLanternKey.method_1436()) {
                ClientPlayNetworking.send((class_8710)new ToggleLanternPayload());
            }
            LanternClientLogic.tickLanternPhysics(client);
        });
        String dyn = hasLamb ? "enabled" : "disabled";
        BLMod.LOGGER.info("Client ready [Fabric]. Dynamic lights: {}.", (Object)dyn);
    }
}

