/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Function;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.client.BLClientAbstractions;

public final class LambDynLightsCompat {
    public static void init() {
        try {
            Class<?> handlerClass = Class.forName("dev.lambdaurora.lambdynlights.api.DynamicLightHandler");
            Class<?> handlersClass = Class.forName("dev.lambdaurora.lambdynlights.api.DynamicLightHandlers");
            Function<Player, Integer> luminance = player -> {
                Item lamp = BLClientAbstractions.clientLamp(player);
                return lamp != null ? LampRegistry.getLuminance(lamp) : 0;
            };
            Function<Player, Boolean> waterSensitive = player -> false;
            Method makeHandler = handlerClass.getMethod("makeHandler", Function.class, Function.class);
            Object handler = makeHandler.invoke(null, luminance, waterSensitive);
            Method makeLiving = handlerClass.getMethod("makeLivingEntityHandler", handlerClass);
            Object livingHandler = makeLiving.invoke(null, handler);
            Method register = handlersClass.getMethod("registerDynamicLightHandler", EntityType.class, handlerClass);
            register.invoke(null, EntityType.PLAYER, livingHandler);
            BLMod.LOGGER.info("Dynamic lights: integrated via LambDynamicLights API (handler)");
        }
        catch (ReflectiveOperationException ignored) {
            try {
                Class<?> lambClass = Class.forName("dev.lambdaurora.lambdynlights.LambDynLights");
                Method get = lambClass.getMethod("get", new Class[0]);
                Object instance = get.invoke(null, new Object[0]);
                Method managerMethod = lambClass.getMethod("entityLightSourceManager", new Class[0]);
                Object manager = managerMethod.invoke(instance, new Object[0]);
                Method eventMethod = manager.getClass().getMethod("onRegisterEvent", new Class[0]);
                Object event = eventMethod.invoke(manager, new Object[0]);
                Class<?> eventClass = Class.forName("dev.yumi.commons.event.Event");
                Class<?> identifierClass = Class.forName("net.minecraft.resources.Identifier");
                Method identifierOf = identifierClass.getMethod("of", String.class, String.class);
                Object identifier = identifierOf.invoke(null, "beltborne_lanterns", "player_lantern");
                Class<?> onRegisterClass = Class.forName("dev.lambdaurora.lambdynlights.api.entity.EntityLightSourceManager$OnRegister");
                Class<?> registerContextClass = Class.forName("dev.lambdaurora.lambdynlights.api.entity.EntityLightSourceManager$RegisterContext");
                Class<?> entityLuminanceClass = Class.forName("dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance");
                Class<?> entityLuminanceTypeClass = Class.forName("dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance$Type");
                Field valueTypeField = entityLuminanceTypeClass.getField("VALUE");
                Object valueType = valueTypeField.get(null);
                Object luminanceProxy = Proxy.newProxyInstance(entityLuminanceClass.getClassLoader(), new Class[]{entityLuminanceClass}, (proxy, method, args) -> {
                    switch (method.getName()) {
                        case "getLuminance": {
                            Object entity = args[1];
                            if (entity instanceof Player) {
                                Player player = (Player)entity;
                                Item lamp = BLClientAbstractions.clientLamp(player);
                                return lamp != null ? LampRegistry.getLuminance(lamp) : 0;
                            }
                            return 0;
                        }
                        case "type": {
                            return valueType;
                        }
                    }
                    return null;
                });
                Object listener = Proxy.newProxyInstance(onRegisterClass.getClassLoader(), new Class[]{onRegisterClass}, (proxy, method, args) -> {
                    if ("onRegister".equals(method.getName())) {
                        Object context = args[0];
                        Method registerMethod = registerContextClass.getMethod("register", EntityType.class, entityLuminanceClass);
                        registerMethod.invoke(context, EntityType.PLAYER, luminanceProxy);
                    }
                    return null;
                });
                Method register = eventClass.getMethod("register", Object.class, Object.class);
                register.invoke(event, identifier, listener);
                BLMod.LOGGER.info("Dynamic lights: integrated via LambDynamicLights API (event)");
            }
            catch (ReflectiveOperationException ignored2) {
                BLMod.LOGGER.debug("Dynamic lights: LambDynamicLights not present; skipping integration");
            }
        }
    }
}

