/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.persistence;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;

public final class BeltLanternSave
extends SavedData {
    private static final String SAVE_NAME = "beltborne_lanterns_belts";
    private static final String PLAYERS_KEY = "players";
    private final Map<UUID, ItemStack> playersWithLamps = new HashMap<UUID, ItemStack>();
    private static final SavedDataType<BeltLanternSave> TYPE = new SavedDataType("beltborne_lanterns_belts", ctx -> new BeltLanternSave(), BeltLanternSave::codec, (DataFixTypes)null);

    private static Codec<BeltLanternSave> codec(final SavedData.Context ctx) {
        return Codec.of((Encoder)new Encoder<BeltLanternSave>(){

            public <T> DataResult<T> encode(BeltLanternSave value, DynamicOps<T> ops, T prefix) {
                CompoundTag nbt = new CompoundTag();
                ServerLevel world = ctx.levelOrThrow();
                HolderLookup.Provider registries = new RegistrySetBuilder().build(world.registryAccess());
                value.writeNbt(nbt, registries);
                return CompoundTag.CODEC.encodeStart(ops, (Object)nbt);
            }
        }, (Decoder)new Decoder<BeltLanternSave>(){

            public <T> DataResult<Pair<BeltLanternSave, T>> decode(DynamicOps<T> ops, T input) {
                return CompoundTag.CODEC.parse(ops, input).map(nbt -> {
                    ServerLevel world = ctx.levelOrThrow();
                    HolderLookup.Provider registries = new RegistrySetBuilder().build(world.registryAccess());
                    return Pair.of((Object)((Object)BeltLanternSave.fromNbt(nbt, registries)), (Object)input);
                });
            }
        });
    }

    public static BeltLanternSave get(MinecraftServer server) {
        DimensionDataStorage psManager = server.overworld().getDataStorage();
        return (BeltLanternSave)psManager.computeIfAbsent(TYPE);
    }

    public BeltLanternSave() {
    }

    public BeltLanternSave(SavedData.Context ctx) {
    }

    public boolean has(UUID uuid) {
        return this.playersWithLamps.containsKey(uuid);
    }

    public Item get(UUID uuid) {
        ItemStack stack = this.playersWithLamps.get(uuid);
        return stack != null ? stack.getItem() : null;
    }

    public ItemStack getStack(UUID uuid) {
        ItemStack stack = this.playersWithLamps.get(uuid);
        return stack != null ? stack.copy() : null;
    }

    public void set(UUID uuid, ItemStack lamp) {
        if (lamp != null && !lamp.isEmpty()) {
            this.playersWithLamps.put(uuid, lamp.copyWithCount(1));
        } else {
            this.playersWithLamps.remove(uuid);
        }
        this.setDirty();
    }

    public void set(UUID uuid, Item lamp) {
        if (lamp != null) {
            this.playersWithLamps.put(uuid, new ItemStack((ItemLike)lamp));
        } else {
            this.playersWithLamps.remove(uuid);
        }
        this.setDirty();
    }

    public static BeltLanternSave fromNbt(CompoundTag nbt) {
        BeltLanternSave save = new BeltLanternSave();
        CompoundTag map = nbt.getCompoundOrEmpty(PLAYERS_KEY);
        for (String key : map.keySet()) {
            try {
                UUID uuid = UUID.fromString(key);
                map.getString(key).ifPresent(str -> {
                    ResourceLocation id = ResourceLocation.tryParse((String)str);
                    if (id != null) {
                        save.playersWithLamps.put(uuid, new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(id)));
                    }
                });
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return save;
    }

    public static BeltLanternSave fromNbt(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        BeltLanternSave save = new BeltLanternSave();
        CompoundTag map = nbt.getCompoundOrEmpty(PLAYERS_KEY);
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryLookup);
        for (String key : map.keySet()) {
            try {
                UUID uuid = UUID.fromString(key);
                Tag el = map.get(key);
                if (el != null && !(el instanceof StringTag)) {
                    ItemStack.CODEC.parse((DynamicOps)ops, (Object)el).result().ifPresent(stack -> {
                        if (!stack.isEmpty()) {
                            save.playersWithLamps.put(uuid, (ItemStack)stack);
                        }
                    });
                    continue;
                }
                map.getString(key).ifPresent(str -> {
                    ResourceLocation id = ResourceLocation.tryParse((String)str);
                    if (id != null) {
                        save.playersWithLamps.put(uuid, new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(id)));
                    }
                });
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return save;
    }

    public CompoundTag writeNbt(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        CompoundTag map = new CompoundTag();
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryLookup);
        for (Map.Entry<UUID, ItemStack> e : this.playersWithLamps.entrySet()) {
            ItemStack stack = e.getValue();
            ItemStack.CODEC.encodeStart((DynamicOps)ops, (Object)stack).result().ifPresent(el -> map.put(((UUID)e.getKey()).toString(), el));
        }
        nbt.put(PLAYERS_KEY, (Tag)map);
        return nbt;
    }
}

