/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.BeltState;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;

public final class DynamicLightsCompat {
    private static volatile boolean PRESENT = false;
    private static Class<?> lightInterface;
    private static Method addLightSource;
    private static Method removeLightSource;
    private static final Map<UUID, Object> ACTIVE;

    private DynamicLightsCompat() {
    }

    public static void init() {
        if (PRESENT) {
            return;
        }
        try {
            Class<?> dlClass = Class.forName("atomicstryker.dynamiclights.server.DynamicLights");
            lightInterface = Class.forName("atomicstryker.dynamiclights.server.IDynamicLightSource");
            addLightSource = dlClass.getMethod("addLightSource", lightInterface);
            removeLightSource = dlClass.getMethod("removeLightSource", lightInterface);
            PRESENT = true;
            BLMod.LOGGER.info("Dynamic lights: integrated via AtomicStryker DynamicLights API");
        }
        catch (Throwable t) {
            PRESENT = false;
            BLMod.LOGGER.debug("Dynamic lights: DynamicLights not present; skipping integration");
        }
    }

    public static void addFor(ServerPlayer player) {
        if (!PRESENT || player == null) {
            return;
        }
        UUID id = player.getUUID();
        if (ACTIVE.containsKey(id)) {
            return;
        }
        Object proxy = Proxy.newProxyInstance(lightInterface.getClassLoader(), new Class[]{lightInterface}, (p, m, args) -> {
            String name = m.getName();
            if ("getAttachmentEntity".equals(name)) {
                return player;
            }
            if ("getLightLevel".equals(name)) {
                Item lamp = BeltState.getLamp((Player)player);
                return lamp != null ? LampRegistry.getLuminance(lamp) : 0;
            }
            return null;
        });
        try {
            addLightSource.invoke(null, proxy);
            ACTIVE.put(id, proxy);
        }
        catch (Throwable t) {
            BLMod.LOGGER.debug("Failed to register DynamicLights source for {}", (Object)id, (Object)t);
        }
    }

    public static void removeFor(ServerPlayer player) {
        if (!PRESENT || player == null) {
            return;
        }
        Object proxy = ACTIVE.remove(player.getUUID());
        if (proxy == null) {
            return;
        }
        try {
            removeLightSource.invoke(null, proxy);
        }
        catch (Throwable t) {
            BLMod.LOGGER.debug("Failed to remove DynamicLights source for {}", (Object)player.getUUID(), (Object)t);
        }
    }

    static {
        ACTIVE = new ConcurrentHashMap<UUID, Object>();
    }
}

