/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.physics;

public final class LanternSwingState {
    private final float omega;
    private final float zeta;
    private float x;
    private float xDot;
    private float z;
    private float zDot;
    private float prevX;
    private float prevZ;
    private float impulseXdot;

    public LanternSwingState(float omega, float zeta) {
        this.omega = omega;
        this.zeta = zeta;
        this.x = 0.0f;
        this.z = 0.0f;
        this.xDot = 0.0f;
        this.zDot = 0.0f;
        this.prevX = 0.0f;
        this.prevZ = 0.0f;
        this.impulseXdot = 0.0f;
    }

    public void impulseX(float vRadPerSec) {
        this.impulseXdot += vRadPerSec;
    }

    public void step(float dtSec, float uX, float uZ) {
        if (dtSec <= 0.0f) {
            return;
        }
        this.prevX = this.x;
        this.prevZ = this.z;
        if (this.impulseXdot != 0.0f) {
            this.xDot += this.impulseXdot;
            this.impulseXdot = 0.0f;
        }
        float ax = uX - 2.0f * this.zeta * this.omega * this.xDot - this.omega * this.omega * this.x;
        float az = uZ - 2.0f * this.zeta * this.omega * this.zDot - this.omega * this.omega * this.z;
        this.xDot += ax * dtSec;
        this.zDot += az * dtSec;
        this.x += this.xDot * dtSec;
        this.z += this.zDot * dtSec;
    }

    public float getXDeg() {
        return (float)Math.toDegrees(this.x);
    }

    public float getZDeg() {
        return (float)Math.toDegrees(this.z);
    }
}

