/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class BeltState {
    private static final Map<UUID, ItemStack> PLAYER_LAMPS = new ConcurrentHashMap<UUID, ItemStack>();

    private BeltState() {
    }

    public static boolean hasLamp(UUID uuid) {
        return PLAYER_LAMPS.containsKey(uuid);
    }

    public static boolean hasLamp(Player player) {
        return BeltState.hasLamp(player.getUUID());
    }

    public static Item getLamp(UUID uuid) {
        ItemStack stack = PLAYER_LAMPS.get(uuid);
        return stack != null ? stack.getItem() : null;
    }

    public static Item getLamp(Player player) {
        return BeltState.getLamp(player.getUUID());
    }

    public static ItemStack getLampStack(UUID uuid) {
        ItemStack stack = PLAYER_LAMPS.get(uuid);
        return stack != null ? stack.copy() : null;
    }

    public static ItemStack getLampStack(Player player) {
        return BeltState.getLampStack(player.getUUID());
    }

    public static void setLamp(UUID uuid, ItemStack lamp) {
        if (lamp != null && !lamp.isEmpty()) {
            PLAYER_LAMPS.put(uuid, lamp.copyWithCount(1));
        } else {
            PLAYER_LAMPS.remove(uuid);
        }
    }

    public static void setLamp(Player player, ItemStack lamp) {
        BeltState.setLamp(player.getUUID(), lamp);
    }

    public static void setLamp(UUID uuid, Item lamp) {
        if (lamp != null) {
            PLAYER_LAMPS.put(uuid, new ItemStack((ItemLike)lamp));
        } else {
            PLAYER_LAMPS.remove(uuid);
        }
    }

    public static void setLamp(Player player, Item lamp) {
        BeltState.setLamp(player.getUUID(), lamp);
    }
}

