/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.physics;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.oxcodsnet.beltborne_lanterns.common.physics.LanternSwingState;

public final class LanternSwingManager {
    private static final float DEFAULT_OMEGA = 7.0f;
    private static final float DEFAULT_ZETA = 0.42f;
    private static final float K_YAW = 3.2f;
    private static final float K_HSPEED = 0.2f;
    private static final float K_HACCEL = 1.7f;
    private static final float K_YACCEL = 0.3f;
    private static final float K_STRAFE_A = 1.4f;
    private static final float K_STRAFE_V = 0.25f;
    private static final float IMPULSE_JUMP_X = -1.3f;
    private static final float IMPULSE_LAND_X = 1.8f;
    private static final float IMPULSE_CROUCH_X = 0.6f;
    private static final float IMPULSE_UNCROUCH_X = -0.4f;
    private static final float IMPULSE_START_MOVE_X = -0.7f;
    private static final float IMPULSE_STOP_MOVE_X = 0.5f;
    private static final double MOVE_THRESHOLD_BPS = 1.6;
    private static final double JUMP_THRESHOLD_B_TICK = 0.08;
    private static final double LAND_THRESHOLD_B_TICK = -0.08;
    private static final float SNEAK_BASE_ROT_X_DEG = 215.0f;
    private static final float SNEAK_BLEND_TAU_SEC = 0.15f;
    private static final Map<UUID, LanternSwingState> STATES = new ConcurrentHashMap<UUID, LanternSwingState>();
    private static final Map<UUID, Kinematics> KIN = new ConcurrentHashMap<UUID, Kinematics>();

    private LanternSwingManager() {
    }

    private static LanternSwingState getOrCreate(UUID id) {
        return STATES.computeIfAbsent(id, u -> new LanternSwingState(7.0f, 0.42f));
    }

    public static void tickPlayer(Player p, float dtSec, float baseRotXDeg) {
        float targetBaseX;
        UUID id = p.getUUID();
        LanternSwingState state = LanternSwingManager.getOrCreate(id);
        Kinematics kin = KIN.computeIfAbsent(id, u -> new Kinematics());
        float yaw = LanternSwingManager.wrapDegrees(p.getYRot());
        float yawRateDegPerSec = LanternSwingManager.wrapDegrees(yaw - kin.prevYaw) / Math.max(dtSec, 1.0E-4f);
        float yawRateRadPerSec = (float)Math.toRadians(yawRateDegPerSec);
        double vx = p.getDeltaMovement().x;
        double vz = p.getDeltaMovement().z;
        double vy = p.getDeltaMovement().y;
        double hSpeedPerSec = Math.hypot(vx, vz) * 20.0;
        double prevHSpeedPerSec = kin.prevHSpeedPerSec;
        double hAccel = (hSpeedPerSec - prevHSpeedPerSec) / Math.max((double)dtSec, 1.0E-4);
        double yAcc = (vy - kin.prevYVel) * 20.0 / Math.max((double)dtSec, 1.0E-4);
        float yawRad = (float)Math.toRadians(yaw);
        double fwdX = -Math.sin(yawRad);
        double fwdZ = Math.cos(yawRad);
        double rightX = Math.cos(yawRad);
        double rightZ = Math.sin(yawRad);
        double vFwd = vx * fwdX + vz * fwdZ;
        double vRight = vx * rightX + vz * rightZ;
        double vFwdPerSec = vFwd * 20.0;
        double vRightPerSec = vRight * 20.0;
        double aFwd = (vFwdPerSec - kin.prevVFwdPerSec) / Math.max((double)dtSec, 1.0E-4);
        double aRight = (vRightPerSec - kin.prevVRightPerSec) / Math.max((double)dtSec, 1.0E-4);
        float uZ = (float)((double)(3.2f * yawRateRadPerSec) + (double)1.4f * aRight + 0.25 * vRightPerSec);
        float uX = (float)((double)0.2f * vFwdPerSec + (double)1.7f * aFwd + (double)0.3f * yAcc);
        boolean onGround = p.onGround();
        boolean wasOnGround = kin.prevOnGround;
        boolean sneaking = p.isShiftKeyDown();
        boolean wasSneaking = kin.prevSneaking;
        boolean moving = hSpeedPerSec > 1.6;
        boolean wasMoving = kin.prevMoving;
        if (wasOnGround && !onGround && vy > 0.08) {
            state.impulseX(-1.3f);
        }
        if (!wasOnGround && onGround && kin.prevYVel < -0.08) {
            state.impulseX(1.8f);
        }
        if (!wasSneaking && sneaking) {
            state.impulseX(0.6f);
        } else if (wasSneaking && !sneaking) {
            state.impulseX(-0.4f);
        }
        if (!wasMoving && moving) {
            state.impulseX(-0.7f);
        } else if (wasMoving && !moving) {
            state.impulseX(0.5f);
        }
        float f = targetBaseX = sneaking ? 215.0f : baseRotXDeg;
        if (!kin.baseInit) {
            kin.baseXDegSmoothed = targetBaseX;
            kin.baseInit = true;
        }
        kin.baseXDegSmoothed = LanternSwingManager.approachExp(kin.baseXDegSmoothed, targetBaseX, dtSec, 0.15f);
        state.step(dtSec, uX, uZ);
        kin.prevYaw = yaw;
        kin.prevHSpeedPerSec = hSpeedPerSec;
        kin.prevYVel = vy;
        kin.prevOnGround = onGround;
        kin.prevSneaking = sneaking;
        kin.prevVFwdPerSec = vFwdPerSec;
        kin.prevVRightPerSec = vRightPerSec;
        kin.prevMoving = moving;
        KIN.put(id, kin);
        STATES.put(id, state);
    }

    public static float getXDeg(UUID id) {
        return STATES.getOrDefault(id, new LanternSwingState(7.0f, 0.42f)).getXDeg();
    }

    public static float getZDeg(UUID id) {
        return STATES.getOrDefault(id, new LanternSwingState(7.0f, 0.42f)).getZDeg();
    }

    public static float getBaseXDeg(UUID id) {
        Kinematics k = KIN.get(id);
        if (k == null) {
            return 0.0f;
        }
        return k.baseXDegSmoothed;
    }

    public static void removePlayer(UUID id) {
        STATES.remove(id);
        KIN.remove(id);
    }

    private static float wrapDegrees(float deg) {
        return Mth.wrapDegrees((float)deg);
    }

    private static float approachExp(float current, float target, float dtSec, float tauSec) {
        if (tauSec <= 0.0f) {
            return target;
        }
        float a = 1.0f - (float)Math.exp(-dtSec / tauSec);
        if (a < 0.0f) {
            a = 0.0f;
        } else if (a > 1.0f) {
            a = 1.0f;
        }
        return current + (target - current) * a;
    }

    private static final class Kinematics {
        float prevYaw = 0.0f;
        double prevHSpeedPerSec = 0.0;
        double prevYVel = 0.0;
        boolean prevOnGround = false;
        boolean prevSneaking = false;
        double prevVFwdPerSec = 0.0;
        double prevVRightPerSec = 0.0;
        boolean prevMoving = false;
        float baseXDegSmoothed = 0.0f;
        boolean baseInit = false;

        private Kinematics() {
        }
    }
}

