/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.config.BLLampConfig;
import net.oxcodsnet.beltborne_lanterns.common.config.BLLampConfigAccess;

public final class LampRegistry {
    private static final Map<class_1792, LampData> LAMPS = new LinkedHashMap<class_1792, LampData>();
    public static final class_6862<class_1792> EXTRA_LAMPS_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"beltborne_lanterns", (String)"lamps"));

    private LampRegistry() {
    }

    public static void init() {
        LAMPS.clear();
        LampRegistry.register(class_1802.field_16539, (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_2741.field_16561, (Comparable)Boolean.valueOf(false)));
        LampRegistry.register(class_1802.field_22016, (class_2680)class_2246.field_22110.method_9564().method_11657((class_2769)class_2741.field_16561, (Comparable)Boolean.valueOf(false)));
        LampRegistry.registerCopperLanterns();
        try {
            int discovered = 0;
            for (class_6880 entry2 : class_7923.field_41178.method_40286(EXTRA_LAMPS_TAG)) {
                ++discovered;
                class_2960 id = class_7923.field_41178.method_10221((Object)((class_1792)entry2.comp_349()));
                BLMod.LOGGER.debug(" - {}", (Object)id);
                class_1792 item = (class_1792)entry2.comp_349();
                if (LAMPS.containsKey(item) || !(item instanceof class_1747)) continue;
                class_1747 blockItem = (class_1747)item;
                class_2680 state = blockItem.method_7711().method_9564();
                if (state.method_28498((class_2769)class_2741.field_16561)) {
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_16561, (Comparable)Boolean.valueOf(false));
                }
                LampRegistry.register(item, state);
            }
            if (discovered > 0) {
                BLMod.LOGGER.debug("Found {} entries in #{}:lamps", (Object)discovered, (Object)"beltborne_lanterns");
            }
        }
        catch (IllegalStateException notBound) {
            BLMod.LOGGER.debug("Tags not bound yet; skipping tag-based lamps for now");
        }
        BLLampConfig cfg = BLLampConfigAccess.get();
        cfg.extraLampLight.forEach(entry -> {
            class_2960 id = class_2960.method_12829((String)entry.id);
            if (id == null) {
                return;
            }
            class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
            if (item == class_1802.field_8162) {
                return;
            }
            if (!(item instanceof class_1747)) {
                return;
            }
            class_1747 blockItem = (class_1747)item;
            class_2680 state = blockItem.method_7711().method_9564();
            if (state.method_28498((class_2769)class_2741.field_16561)) {
                state = (class_2680)state.method_11657((class_2769)class_2741.field_16561, (Comparable)Boolean.valueOf(false));
            }
            LampRegistry.register(item, state, entry.luminance);
        });
        int total = LAMPS.size();
        int builtin = 0;
        if (LAMPS.containsKey(class_1802.field_16539)) {
            ++builtin;
        }
        if (LAMPS.containsKey(class_1802.field_22016)) {
            ++builtin;
        }
        int extras = Math.max(0, total - builtin);
        BLMod.LOGGER.info("Lamp registry ready: {} items ({} builtin, {} extra)", new Object[]{total, builtin, extras});
    }

    private static void registerCopperLanterns() {
        LampRegistry.registerCopperVariant("copper_lantern");
        LampRegistry.registerCopperVariant("exposed_copper_lantern");
        LampRegistry.registerCopperVariant("weathered_copper_lantern");
        LampRegistry.registerCopperVariant("oxidized_copper_lantern");
        LampRegistry.registerCopperVariant("waxed_copper_lantern");
        LampRegistry.registerCopperVariant("waxed_exposed_copper_lantern");
        LampRegistry.registerCopperVariant("waxed_weathered_copper_lantern");
        LampRegistry.registerCopperVariant("waxed_oxidized_copper_lantern");
    }

    private static void registerCopperVariant(String path) {
        class_2960 id = class_2960.method_60655((String)"minecraft", (String)path);
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
        if (!(item instanceof class_1747)) {
            BLMod.LOGGER.warn("Expected copper lantern item {}, but it was not found or not a block item", (Object)id);
            return;
        }
        class_1747 blockItem = (class_1747)item;
        class_2680 state = blockItem.method_7711().method_9564();
        if (state.method_28498((class_2769)class_2741.field_16561)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_16561, (Comparable)Boolean.valueOf(false));
        }
        LampRegistry.register(item, state);
    }

    private static int clampLuminance(int lum) {
        return Math.max(0, Math.min(15, lum));
    }

    public static void register(class_1792 item, class_2680 state) {
        LAMPS.put(item, new LampData(state, state.method_26213()));
    }

    public static void register(class_1792 item, class_2680 state, int luminance) {
        LAMPS.put(item, new LampData(state, LampRegistry.clampLuminance(luminance)));
    }

    public static boolean isLamp(class_1799 stack) {
        return stack != null && LAMPS.containsKey(stack.method_7909());
    }

    public static boolean isLamp(class_1792 item) {
        return item != null && LAMPS.containsKey(item);
    }

    public static class_2680 getState(class_1792 item) {
        LampData data = LAMPS.get(item);
        return data != null ? data.state() : (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_2741.field_16561, (Comparable)Boolean.valueOf(false));
    }

    public static int getLuminance(class_1792 item) {
        LampData data = LAMPS.get(item);
        return data != null ? data.luminance() : 0;
    }

    public static class_2960 getId(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item);
    }

    public static class_1792 getById(class_2960 id) {
        return (class_1792)class_7923.field_41178.method_63535(id);
    }

    public static Set<class_1792> items() {
        return Collections.unmodifiableSet(LAMPS.keySet());
    }

    private record LampData(class_2680 state, int luminance) {
    }
}

